/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import org.glowroot.shaded.h2.command.ddl.DefineCommand;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.engine.User;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.security.SHA256;
import org.glowroot.shaded.h2.util.StringUtils;

public class AlterUser
extends DefineCommand {
    private int type;
    private User user;
    private String newName;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean admin;

    public AlterUser(Session session) {
        super(session);
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public void setSalt(Expression expression) {
        this.salt = expression;
    }

    public void setHash(Expression expression) {
        this.hash = expression;
    }

    public void setPassword(Expression expression) {
        this.password = expression;
    }

    private char[] getCharArray(Expression expression) {
        return expression.optimize(this.session).getValue(this.session).getString().toCharArray();
    }

    private byte[] getByteArray(Expression expression) {
        return StringUtils.convertHexToBytes(expression.optimize(this.session).getValue(this.session).getString());
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        switch (this.type) {
            case 19: {
                if (this.user != this.session.getUser()) {
                    this.session.getUser().checkAdmin();
                }
                if (this.hash != null && this.salt != null) {
                    this.user.setSaltAndHash(this.getByteArray(this.salt), this.getByteArray(this.hash));
                    break;
                }
                String string = this.newName == null ? this.user.getName() : this.newName;
                char[] cArray = this.getCharArray(this.password);
                byte[] byArray = SHA256.getKeyPasswordHash(string, cArray);
                this.user.setUserPasswordHash(byArray);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                if (database.findUser(this.newName) != null || this.newName.equals(this.user.getName())) {
                    throw DbException.get(90033, this.newName);
                }
                database.renameDatabaseObject(this.session, this.user, this.newName);
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                if (!this.admin) {
                    this.user.checkOwnsNoSchemas();
                }
                this.user.setAdmin(this.admin);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.update(this.session, this.user);
        return 0;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

