/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.glowroot.shaded.h2.command.ddl.AlterTableAddConstraint;
import org.glowroot.shaded.h2.command.ddl.CreateIndex;
import org.glowroot.shaded.h2.command.ddl.CreateTableData;
import org.glowroot.shaded.h2.command.ddl.DefineCommand;
import org.glowroot.shaded.h2.command.ddl.SchemaCommand;
import org.glowroot.shaded.h2.command.dml.Insert;
import org.glowroot.shaded.h2.command.dml.Query;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.schema.Sequence;
import org.glowroot.shaded.h2.table.Column;
import org.glowroot.shaded.h2.table.IndexColumn;
import org.glowroot.shaded.h2.table.Table;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.value.DataType;

public class CreateTable
extends SchemaCommand {
    private final CreateTableData data = new CreateTableData();
    private final ArrayList<DefineCommand> constraintCommands = New.arrayList();
    private IndexColumn[] pkColumns;
    private boolean ifNotExists;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean sortedInsertMode;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl) {
        this.data.temporary = bl;
    }

    public void setTableName(String string) {
        this.data.tableName = string;
    }

    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public void addConstraintCommand(DefineCommand defineCommand) {
        if (defineCommand instanceof CreateIndex) {
            this.constraintCommands.add(defineCommand);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)defineCommand;
            boolean bl = alterTableAddConstraint.getType() == 6 ? this.setPrimaryKeyColumns(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl) {
                this.constraintCommands.add(defineCommand);
            }
        }
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        block27: {
            boolean bl;
            Database database;
            if (!this.transactional) {
                this.session.commit(true);
            }
            if (!(database = this.session.getDatabase()).isPersistent()) {
                this.data.persistIndexes = false;
            }
            if (this.getSchema().findTableOrView(this.session, this.data.tableName) != null) {
                if (this.ifNotExists) {
                    return 0;
                }
                throw DbException.get(42101, this.data.tableName);
            }
            if (this.asQuery != null) {
                this.asQuery.prepare();
                if (this.data.columns.size() == 0) {
                    this.generateColumnsFromQuery();
                } else if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                    throw DbException.get(21002);
                }
            }
            if (this.pkColumns != null) {
                for (Column object2 : this.data.columns) {
                    for (IndexColumn n : this.pkColumns) {
                        if (!object2.getName().equals(n.columnName)) continue;
                        object2.setNullable(false);
                    }
                }
            }
            this.data.id = this.getObjectId();
            this.data.create = this.create;
            this.data.session = this.session;
            boolean bl2 = bl = this.data.temporary && !this.data.globalTemporary;
            if (!bl) {
                database.lockMeta(this.session);
            }
            Table table = this.getSchema().createTable(this.data);
            ArrayList arrayList = New.arrayList();
            for (Column column : this.data.columns) {
                Sequence sequence;
                if (column.isAutoIncrement()) {
                    int n = this.getObjectId();
                    column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, this.data.temporary);
                }
                if ((sequence = column.getSequence()) == null) continue;
                arrayList.add(sequence);
            }
            table.setComment(this.comment);
            if (bl) {
                if (this.onCommitDrop) {
                    table.setOnCommitDrop(true);
                }
                if (this.onCommitTruncate) {
                    table.setOnCommitTruncate(true);
                }
                this.session.addLocalTempTable(table);
            } else {
                database.lockMeta(this.session);
                database.addSchemaObject(this.session, table);
            }
            try {
                for (Column sequence : this.data.columns) {
                    sequence.prepareExpression(this.session);
                }
                Iterator<Object> bl3 = arrayList.iterator();
                while (bl3.hasNext()) {
                    Sequence defineCommand = (Sequence)((Object)bl3.next());
                    table.addSequence(defineCommand);
                }
                for (DefineCommand insert : this.constraintCommands) {
                    insert.setTransactional(this.transactional);
                    insert.update();
                }
                if (this.asQuery == null) break block27;
                boolean dbException = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    this.session.startStatementWithinTransaction();
                    Insert insert = null;
                    insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.sortedInsertMode);
                    insert.setQuery(this.asQuery);
                    insert.setTable(table);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(dbException);
                }
            }
            catch (DbException dbException) {
                database.checkPowerOff();
                database.removeSchemaObject(this.session, table);
                if (!this.transactional) {
                    this.session.commit(true);
                }
                throw dbException;
            }
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n = this.asQuery.getColumnCount();
        ArrayList<Expression> arrayList = this.asQuery.getExpressions();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = arrayList.get(i);
            int n3 = expression.getType();
            String string = expression.getAlias();
            long l = expression.getPrecision();
            int n4 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n3);
            if (l > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l && dataType.defaultPrecision < 127L)) {
                l = dataType.defaultPrecision;
            }
            if ((n2 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n2 && (long)dataType.defaultScale < l)) {
                n2 = dataType.defaultScale;
            }
            if ((long)n2 > l) {
                l = n2;
            }
            Column column = new Column(string, n3, l, n2, n4);
            this.addColumn(column);
        }
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] indexColumnArray) {
        if (this.pkColumns != null) {
            int n = indexColumnArray.length;
            if (n != this.pkColumns.length) {
                throw DbException.get(90017);
            }
            for (int i = 0; i < n; ++i) {
                if (indexColumnArray[i].columnName.equals(this.pkColumns[i].columnName)) continue;
                throw DbException.get(90017);
            }
            return true;
        }
        this.pkColumns = indexColumnArray;
        return false;
    }

    public void setPersistIndexes(boolean bl) {
        this.data.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.data.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setPersistData(boolean bl) {
        this.data.persistData = bl;
        if (!bl) {
            this.data.persistIndexes = false;
        }
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    public void setTableEngine(String string) {
        this.data.tableEngine = string;
    }

    public void setTableEngineParams(ArrayList<String> arrayList) {
        this.data.tableEngineParams = arrayList;
    }

    public void setHidden(boolean bl) {
        this.data.isHidden = bl;
    }

    @Override
    public int getType() {
        return 30;
    }
}

