/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import java.util.ArrayList;
import org.glowroot.shaded.h2.command.ddl.DefineCommand;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.DbObject;
import org.glowroot.shaded.h2.engine.DbObjectBase;
import org.glowroot.shaded.h2.engine.Role;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.engine.User;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.schema.SchemaObject;
import org.glowroot.shaded.h2.table.Table;
import org.glowroot.shaded.h2.util.New;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    @Override
    public int update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() {
        ArrayList<Object> arrayList;
        boolean bl;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        database.lockMeta(this.session);
        do {
            arrayList = database.getAllTablesAndViews(false);
            ArrayList object32 = New.arrayList();
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || !"VIEW".equals(((Table)object).getTableType())) continue;
                object32.add(object);
            }
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || !"TABLE LINK".equals(((Table)object).getTableType())) continue;
                object32.add(object);
            }
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || !"TABLE".equals(((Table)object).getTableType()) || ((Table)object).isHidden()) continue;
                object32.add(object);
            }
            for (Object object : arrayList) {
                if (((DbObjectBase)object).getName() == null || !"EXTERNAL".equals(((Table)object).getTableType()) || ((Table)object).isHidden()) continue;
                object32.add(object);
            }
            bl = false;
            for (Object object : object32) {
                if (((DbObjectBase)object).getName() == null) continue;
                if (database.getDependentTable((SchemaObject)object, (Table)object) == null) {
                    database.removeSchemaObject(this.session, (SchemaObject)object);
                    continue;
                }
                bl = true;
            }
        } while (bl);
        for (Schema schema : database.getAllSchemas()) {
            if (!schema.canDrop()) continue;
            database.removeDatabaseObject(this.session, schema);
        }
        this.session.findLocalTempTable(null);
        arrayList = New.arrayList();
        arrayList.addAll(database.getAllSchemaObjects(3));
        arrayList.addAll(database.getAllSchemaObjects(5));
        arrayList.addAll(database.getAllSchemaObjects(4));
        arrayList.addAll(database.getAllSchemaObjects(11));
        arrayList.addAll(database.getAllSchemaObjects(9));
        for (SchemaObject schemaObject : arrayList) {
            if (schemaObject.isHidden()) continue;
            database.removeSchemaObject(this.session, schemaObject);
        }
        for (User user : database.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            database.removeDatabaseObject(this.session, user);
        }
        for (Role role : database.getAllRoles()) {
            Object object;
            object = role.getCreateSQL();
            if (object == null) continue;
            database.removeDatabaseObject(this.session, role);
        }
        ArrayList arrayList2 = New.arrayList();
        arrayList2.addAll(database.getAllRights());
        arrayList2.addAll(database.getAllAggregates());
        arrayList2.addAll(database.getAllUserDataTypes());
        for (Object object : arrayList2) {
            String string = object.getCreateSQL();
            if (string == null) continue;
            database.removeDatabaseObject(this.session, (DbObject)object);
        }
    }

    public void setDropAllObjects(boolean bl) {
        this.dropAllObjects = bl;
    }

    public void setDeleteFiles(boolean bl) {
        this.deleteFiles = bl;
    }

    @Override
    public int getType() {
        return 38;
    }
}

