/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import java.util.ArrayList;
import org.glowroot.shaded.h2.command.ddl.SchemaCommand;
import org.glowroot.shaded.h2.constraint.Constraint;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.index.Index;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.table.Table;

public class DropIndex
extends SchemaCommand {
    private String indexName;
    private boolean ifExists;

    public DropIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Index index = this.getSchema().findIndex(this.session, this.indexName);
        if (index == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.indexName);
            }
        } else {
            Table table = index.getTable();
            this.session.getUser().checkRight(index.getTable(), 15);
            Constraint constraint = null;
            ArrayList<Constraint> arrayList = table.getConstraints();
            for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                Constraint constraint2 = arrayList.get(i);
                if (!constraint2.usesIndex(index)) continue;
                if ("PRIMARY KEY".equals(constraint2.getConstraintType())) {
                    constraint = constraint2;
                    continue;
                }
                throw DbException.get(90085, this.indexName, constraint2.getName());
            }
            index.getTable().setModified();
            if (constraint != null) {
                database.removeSchemaObject(this.session, constraint);
            } else {
                database.removeSchemaObject(this.session, index);
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return 40;
    }
}

