/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.compress;

import java.nio.ByteBuffer;
import org.glowroot.shaded.h2.compress.Compressor;

public final class CompressLZF
implements Compressor {
    private static final int HASH_SIZE = 16384;
    private static final int MAX_LITERAL = 32;
    private static final int MAX_OFF = 8192;
    private static final int MAX_REF = 264;
    private int[] cachedHashTable;

    @Override
    public void setOptions(String string) {
    }

    private static int first(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int first(ByteBuffer byteBuffer, int n) {
        return byteBuffer.get(n) << 8 | byteBuffer.get(n + 1) & 0xFF;
    }

    private static int next(int n, byte[] byArray, int n2) {
        return n << 8 | byArray[n2 + 2] & 0xFF;
    }

    private static int next(int n, ByteBuffer byteBuffer, int n2) {
        return n << 8 | byteBuffer.get(n2 + 2) & 0xFF;
    }

    private static int hash(int n) {
        return n * 2777 >> 9 & 0x3FFF;
    }

    @Override
    public int compress(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] nArray = this.cachedHashTable;
        int n4 = 0;
        ++n2;
        int n5 = CompressLZF.first(byArray, 0);
        while (n3 < n - 4) {
            byte by = byArray[n3 + 2];
            n5 = (n5 << 8) + (by & 0xFF);
            int n6 = CompressLZF.hash(n5);
            int n7 = nArray[n6];
            nArray[n6] = n3;
            if (n7 < n3 && n7 > 0 && (n6 = n3 - n7 - 1) < 8192 && byArray[n7 + 2] == by && byArray[n7 + 1] == (byte)(n5 >> 8) && byArray[n7] == (byte)(n5 >> 16)) {
                int n8;
                int n9 = n - n3 - 2;
                if (n9 > 264) {
                    n9 = 264;
                }
                if (n4 == 0) {
                    --n2;
                } else {
                    byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
                    n4 = 0;
                }
                for (n8 = 3; n8 < n9 && byArray[n7 + n8] == byArray[n3 + n8]; ++n8) {
                }
                if ((n8 -= 2) < 7) {
                    byArray2[n2++] = (byte)((n6 >> 8) + (n8 << 5));
                } else {
                    byArray2[n2++] = (byte)((n6 >> 8) + 224);
                    byArray2[n2++] = (byte)(n8 - 7);
                }
                byArray2[n2++] = (byte)n6;
                ++n2;
                n5 = CompressLZF.first(byArray, n3 += n8);
                n5 = CompressLZF.next(n5, byArray, n3);
                nArray[CompressLZF.hash((int)n5)] = n3++;
                n5 = CompressLZF.next(n5, byArray, n3);
                nArray[CompressLZF.hash((int)n5)] = n3++;
                continue;
            }
            byArray2[n2++] = byArray[n3++];
            if (++n4 != 32) continue;
            byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
            n4 = 0;
            ++n2;
        }
        while (n3 < n) {
            byArray2[n2++] = byArray[n3++];
            if (++n4 != 32) continue;
            byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
            n4 = 0;
            ++n2;
        }
        byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
        if (n4 == 0) {
            --n2;
        }
        return n2;
    }

    public int compress(ByteBuffer byteBuffer, byte[] byArray, int n) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.capacity() - n2;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] nArray = this.cachedHashTable;
        int n4 = 0;
        ++n;
        int n5 = CompressLZF.first(byteBuffer, 0);
        while (n2 < n3 - 4) {
            byte by = byteBuffer.get(n2 + 2);
            n5 = (n5 << 8) + (by & 0xFF);
            int n6 = CompressLZF.hash(n5);
            int n7 = nArray[n6];
            nArray[n6] = n2;
            if (n7 < n2 && n7 > 0 && (n6 = n2 - n7 - 1) < 8192 && byteBuffer.get(n7 + 2) == by && byteBuffer.get(n7 + 1) == (byte)(n5 >> 8) && byteBuffer.get(n7) == (byte)(n5 >> 16)) {
                int n8;
                int n9 = n3 - n2 - 2;
                if (n9 > 264) {
                    n9 = 264;
                }
                if (n4 == 0) {
                    --n;
                } else {
                    byArray[n - n4 - 1] = (byte)(n4 - 1);
                    n4 = 0;
                }
                for (n8 = 3; n8 < n9 && byteBuffer.get(n7 + n8) == byteBuffer.get(n2 + n8); ++n8) {
                }
                if ((n8 -= 2) < 7) {
                    byArray[n++] = (byte)((n6 >> 8) + (n8 << 5));
                } else {
                    byArray[n++] = (byte)((n6 >> 8) + 224);
                    byArray[n++] = (byte)(n8 - 7);
                }
                byArray[n++] = (byte)n6;
                ++n;
                n5 = CompressLZF.first(byteBuffer, n2 += n8);
                n5 = CompressLZF.next(n5, byteBuffer, n2);
                nArray[CompressLZF.hash((int)n5)] = n2++;
                n5 = CompressLZF.next(n5, byteBuffer, n2);
                nArray[CompressLZF.hash((int)n5)] = n2++;
                continue;
            }
            byArray[n++] = byteBuffer.get(n2++);
            if (++n4 != 32) continue;
            byArray[n - n4 - 1] = (byte)(n4 - 1);
            n4 = 0;
            ++n;
        }
        while (n2 < n3) {
            byArray[n++] = byteBuffer.get(n2++);
            if (++n4 != 32) continue;
            byArray[n - n4 - 1] = (byte)(n4 - 1);
            n4 = 0;
            ++n;
        }
        byArray[n - n4 - 1] = (byte)(n4 - 1);
        if (n4 == 0) {
            --n;
        }
        return n;
    }

    @Override
    public void expand(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException();
        }
        do {
            int n5;
            if ((n5 = byArray[n++] & 0xFF) < 32) {
                System.arraycopy(byArray, n, byArray2, n3, ++n5);
                n3 += n5;
                n += n5;
                continue;
            }
            int n6 = n5 >> 5;
            if (n6 == 7) {
                n6 += byArray[n++] & 0xFF;
            }
            n5 = -((n5 & 0x1F) << 8) - 1;
            n5 -= byArray[n++] & 0xFF;
            n5 += n3;
            if (n3 + (n6 += 2) >= byArray2.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < n6; ++i) {
                byArray2[n3++] = byArray2[n5++];
            }
        } while (n3 < n4);
    }

    public static void expand(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        do {
            int n;
            int n2;
            if ((n2 = byteBuffer.get() & 0xFF) < 32) {
                ++n2;
                for (n = 0; n < n2; ++n) {
                    byteBuffer2.put(byteBuffer.get());
                }
            } else {
                n = n2 >> 5;
                if (n == 7) {
                    n += byteBuffer.get() & 0xFF;
                }
                n += 2;
                n2 = -((n2 & 0x1F) << 8) - 1;
                n2 -= byteBuffer.get() & 0xFF;
                n2 += byteBuffer2.position();
                for (int i = 0; i < n; ++i) {
                    byteBuffer2.put(byteBuffer2.get(n2++));
                }
            }
        } while (byteBuffer2.position() < byteBuffer2.capacity());
    }

    @Override
    public int getAlgorithm() {
        return 1;
    }
}

