/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.constraint;

import java.util.HashSet;
import java.util.Iterator;
import org.glowroot.shaded.h2.constraint.Constraint;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.expression.ExpressionVisitor;
import org.glowroot.shaded.h2.index.Index;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.result.ResultInterface;
import org.glowroot.shaded.h2.result.Row;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.table.Column;
import org.glowroot.shaded.h2.table.Table;
import org.glowroot.shaded.h2.table.TableFilter;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.util.StringUtils;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int n, String string, Table table) {
        super(schema, n, string, table);
    }

    @Override
    public String getConstraintType() {
        return "CHECK";
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.filter = tableFilter;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("ALTER TABLE ");
        stringBuilder.append(table.getSQL()).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append(" CHECK").append(StringUtils.enclose(this.expr.getSQL())).append(" NOCHECK");
        return stringBuilder.toString();
    }

    private String getShortDescription() {
        return this.getName() + ": " + this.expr.getSQL();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
        Boolean bl;
        if (row2 == null) {
            return;
        }
        this.filter.set(row2);
        try {
            bl = this.expr.getValue(session).getBoolean();
        }
        catch (DbException dbException) {
            throw DbException.get(23514, dbException, this.getShortDescription());
        }
        if (Boolean.FALSE.equals(bl)) {
            throw DbException.get(23513, this.getShortDescription());
        }
    }

    @Override
    public boolean usesIndex(Index index) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index) {
        DbException.throwInternalError();
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet = New.hashSet();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(hashSet));
        Iterator<Column> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getTable() == table) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        String string = "SELECT 1 FROM " + this.filter.getTable().getSQL() + " WHERE NOT(" + this.expr.getSQL() + ")";
        ResultInterface resultInterface = session.prepare(string).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23513, this.getName());
        }
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }
}

