/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.mvstore;

import java.util.BitSet;
import org.glowroot.shaded.h2.util.MathUtils;

public class FreeSpaceBitSet {
    private final int firstFreeBlock;
    private final int blockSize;
    private final BitSet set = new BitSet();

    public FreeSpaceBitSet(int n, int n2) {
        this.firstFreeBlock = n;
        this.blockSize = n2;
        this.clear();
    }

    public void clear() {
        this.set.clear();
        this.set.set(0, this.firstFreeBlock);
    }

    public boolean isUsed(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        for (int i = n2; i < n2 + n3; ++i) {
            if (this.set.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isFree(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        for (int i = n2; i < n2 + n3; ++i) {
            if (!this.set.get(i)) continue;
            return false;
        }
        return true;
    }

    public long allocate(int n) {
        int n2 = this.getBlockCount(n);
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.set.nextSetBit((n4 = this.set.nextClearBit(n3)) + 1)) < 0 || n5 - n4 >= n2) {
                this.set.set(n4, n4 + n2);
                return this.getPos(n4);
            }
            n3 = n5;
        }
    }

    public void markUsed(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        this.set.set(n2, n2 + n3);
    }

    public void free(long l, int n) {
        int n2 = this.getBlock(l);
        int n3 = this.getBlockCount(n);
        this.set.clear(n2, n2 + n3);
    }

    private long getPos(int n) {
        return (long)n * (long)this.blockSize;
    }

    private int getBlock(long l) {
        return (int)(l / (long)this.blockSize);
    }

    private int getBlockCount(int n) {
        return MathUtils.roundUpInt(n, this.blockSize) / this.blockSize;
    }

    public int getFillRate() {
        int n = this.set.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.set.get(i)) continue;
            ++n2;
        }
        if (n2 == 0) {
            return 0;
        }
        return Math.max(1, (int)(100L * (long)n2 / (long)n));
    }

    public long getFirstFree() {
        return this.getPos(this.set.nextClearBit(0));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n = 0;
        while (true) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            int n2 = this.set.nextClearBit(n);
            stringBuilder.append(Integer.toHexString(n2)).append('-');
            int n3 = this.set.nextSetBit(n2 + 1);
            if (n3 < 0) break;
            stringBuilder.append(Integer.toHexString(n3 - 1));
            n = n3 + 1;
        }
        return stringBuilder.append(']').toString();
    }
}

