/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.security;

import java.util.Arrays;

public class SHA256 {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] HH = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private final byte[] result = new byte[32];
    private final int[] w = new int[64];
    private final int[] hh = new int[8];

    public static byte[] getHashWithSalt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return SHA256.getHash(byArray3, true);
    }

    public static byte[] getKeyPasswordHash(String string, char[] cArray) {
        String string2 = string + "@";
        byte[] byArray = new byte[2 * (string2.length() + cArray.length)];
        int n = 0;
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string2.charAt(i);
            byArray[n++] = (byte)(n3 >> 8);
            byArray[n++] = (byte)n3;
        }
        for (char c : cArray) {
            byArray[n++] = (byte)(c >> 8);
            byArray[n++] = (byte)c;
        }
        Arrays.fill(cArray, '\u0000');
        return SHA256.getHash(byArray, true);
    }

    public static byte[] getHMAC(byte[] byArray, byte[] byArray2) {
        byArray = SHA256.normalizeKeyForHMAC(byArray);
        int n = byArray2.length;
        int n2 = 64 + Math.max(32, n);
        int n3 = SHA256.getIntCount(n2);
        byte[] byArray3 = new byte[n3 * 4];
        int[] nArray = new int[n3];
        SHA256 sHA256 = new SHA256();
        byte[] byArray4 = new byte[64 + n];
        byte[] byArray5 = new byte[96];
        sHA256.calculateHMAC(byArray, byArray2, n, byArray4, byArray5, byArray3, nArray);
        return sHA256.result;
    }

    private void calculateHMAC(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4, byte[] byArray5, int[] nArray) {
        Arrays.fill(byArray3, 0, 64, (byte)54);
        SHA256.xor(byArray3, byArray, 64);
        System.arraycopy(byArray2, 0, byArray3, 64, n);
        this.calculateHash(byArray3, 64 + n, byArray5, nArray);
        Arrays.fill(byArray4, 0, 64, (byte)92);
        SHA256.xor(byArray4, byArray, 64);
        System.arraycopy(this.result, 0, byArray4, 64, 32);
        this.calculateHash(byArray4, 96, byArray5, nArray);
    }

    private static byte[] normalizeKeyForHMAC(byte[] byArray) {
        if (byArray.length > 64) {
            byArray = SHA256.getHash(byArray, false);
        }
        if (byArray.length < 64) {
            byArray = Arrays.copyOf(byArray, 64);
        }
        return byArray;
    }

    private static void xor(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i]);
        }
    }

    public static byte[] getPBKDF2(byte[] byArray, byte[] byArray2, int n, int n2) {
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = SHA256.normalizeKeyForHMAC(byArray);
        SHA256 sHA256 = new SHA256();
        int n3 = 64 + Math.max(32, byArray2.length + 4);
        byte[] byArray5 = new byte[n3];
        int n4 = SHA256.getIntCount(n3);
        byte[] byArray6 = new byte[n4 * 4];
        int[] nArray = new int[n4];
        byte[] byArray7 = new byte[64 + n3];
        byte[] byArray8 = new byte[96];
        int n5 = 1;
        for (int i = 0; i < n2; i += 32) {
            for (int j = 0; j < n; ++j) {
                if (j == 0) {
                    System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
                    SHA256.writeInt(byArray5, byArray2.length, n5);
                    n3 = byArray2.length + 4;
                } else {
                    System.arraycopy(sHA256.result, 0, byArray5, 0, 32);
                    n3 = 32;
                }
                sHA256.calculateHMAC(byArray4, byArray5, n3, byArray7, byArray8, byArray6, nArray);
                for (int k = 0; k < 32 && k + i < n2; ++k) {
                    int n6 = k + i;
                    byArray3[n6] = (byte)(byArray3[n6] ^ sHA256.result[k]);
                }
            }
            ++n5;
        }
        Arrays.fill(byArray, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        return byArray3;
    }

    public static byte[] getHash(byte[] byArray, boolean bl) {
        int n = byArray.length;
        int n2 = SHA256.getIntCount(n);
        byte[] byArray2 = new byte[n2 * 4];
        int[] nArray = new int[n2];
        SHA256 sHA256 = new SHA256();
        sHA256.calculateHash(byArray, n, byArray2, nArray);
        if (bl) {
            sHA256.fillWithNull();
            Arrays.fill(nArray, 0);
            Arrays.fill(byArray2, (byte)0);
            Arrays.fill(byArray, (byte)0);
        }
        return sHA256.result;
    }

    private static int getIntCount(int n) {
        return (n + 9 + 63) / 64 * 16;
    }

    private void fillWithNull() {
        Arrays.fill(this.w, 0);
        Arrays.fill(this.hh, 0);
    }

    private void calculateHash(byte[] byArray, int n, byte[] byArray2, int[] nArray) {
        int n2;
        int[] nArray2 = this.w;
        int[] nArray3 = this.hh;
        byte[] byArray3 = this.result;
        int n3 = SHA256.getIntCount(n);
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = -128;
        Arrays.fill(byArray2, n + 1, n3 * 4, (byte)0);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = SHA256.readInt(byArray2, n4);
            n4 += 4;
        }
        nArray[n3 - 2] = n >>> 29;
        nArray[n3 - 1] = n << 3;
        System.arraycopy(HH, 0, nArray3, 0, 8);
        for (n4 = 0; n4 < n3; n4 += 16) {
            int n5;
            int n6;
            int n7;
            for (n2 = 0; n2 < 16; ++n2) {
                nArray2[n2] = nArray[n4 + n2];
            }
            for (n2 = 16; n2 < 64; ++n2) {
                n7 = nArray2[n2 - 2];
                n6 = SHA256.rot(n7, 17) ^ SHA256.rot(n7, 19) ^ n7 >>> 10;
                n7 = nArray2[n2 - 15];
                n5 = SHA256.rot(n7, 7) ^ SHA256.rot(n7, 18) ^ n7 >>> 3;
                nArray2[n2] = n6 + nArray2[n2 - 7] + n5 + nArray2[n2 - 16];
            }
            n2 = nArray3[0];
            n7 = nArray3[1];
            n6 = nArray3[2];
            n5 = nArray3[3];
            int n8 = nArray3[4];
            int n9 = nArray3[5];
            int n10 = nArray3[6];
            int n11 = nArray3[7];
            for (int i = 0; i < 64; ++i) {
                int n12 = n11 + (SHA256.rot(n8, 6) ^ SHA256.rot(n8, 11) ^ SHA256.rot(n8, 25)) + (n8 & n9 ^ ~n8 & n10) + K[i] + nArray2[i];
                int n13 = (SHA256.rot(n2, 2) ^ SHA256.rot(n2, 13) ^ SHA256.rot(n2, 22)) + (n2 & n7 ^ n2 & n6 ^ n7 & n6);
                n11 = n10;
                n10 = n9;
                n9 = n8;
                n8 = n5 + n12;
                n5 = n6;
                n6 = n7;
                n7 = n2;
                n2 = n12 + n13;
            }
            nArray3[0] = nArray3[0] + n2;
            nArray3[1] = nArray3[1] + n7;
            nArray3[2] = nArray3[2] + n6;
            nArray3[3] = nArray3[3] + n5;
            nArray3[4] = nArray3[4] + n8;
            nArray3[5] = nArray3[5] + n9;
            nArray3[6] = nArray3[6] + n10;
            nArray3[7] = nArray3[7] + n11;
        }
        for (n4 = 0; n4 < 8; ++n4) {
            SHA256.writeInt(byArray3, n4 * 4, nArray3[n4]);
        }
    }

    private static int rot(int n, int n2) {
        return Integer.rotateRight(n, n2);
    }

    private static int readInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    private static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }
}

