/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.message.Trace;
import org.glowroot.shaded.h2.store.Page;
import org.glowroot.shaded.h2.store.PageStore;
import org.glowroot.shaded.h2.store.PageStreamData;
import org.glowroot.shaded.h2.store.PageStreamTrunk;
import org.glowroot.shaded.h2.util.BitField;

public class PageInputStream
extends InputStream {
    private final PageStore store;
    private final Trace trace;
    private final int firstTrunkPage;
    private final PageStreamTrunk.Iterator trunkIterator;
    private int dataPage;
    private PageStreamTrunk trunk;
    private int trunkIndex;
    private PageStreamData data;
    private int dataPos;
    private boolean endOfFile;
    private int remaining;
    private final byte[] buffer = new byte[]{0};
    private int logKey;

    PageInputStream(PageStore pageStore, int n, int n2, int n3) {
        this.store = pageStore;
        this.trace = pageStore.getTrace();
        this.logKey = n - 1;
        this.firstTrunkPage = n2;
        this.trunkIterator = new PageStreamTrunk.Iterator(pageStore, n2);
        this.dataPage = n3;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.buffer);
        return n < 0 ? -1 : this.buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
            n4 += n3;
            n += n3;
            n2 -= n3;
        }
        return n4 == 0 ? -1 : n4;
    }

    private int readBlock(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.data.read(this.dataPos, byArray, n, n3);
            this.remaining -= n3;
            this.dataPos += n3;
            return n3;
        }
        catch (DbException dbException) {
            throw new EOFException();
        }
    }

    private void fillBuffer() {
        int n;
        if (this.remaining > 0 || this.endOfFile) {
            return;
        }
        while (true) {
            if (this.trunk == null) {
                this.trunk = this.trunkIterator.next();
                this.trunkIndex = 0;
                ++this.logKey;
                if (this.trunk == null || this.trunk.getLogKey() != this.logKey) {
                    this.endOfFile = true;
                    return;
                }
            }
            if (this.trunk == null) continue;
            if ((n = this.trunk.getPageData(this.trunkIndex++)) == -1) {
                this.trunk = null;
                continue;
            }
            if (this.dataPage == -1 || this.dataPage == n) break;
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageIn.readPage " + n);
        }
        this.dataPage = -1;
        this.data = null;
        Page page = this.store.getPage(n);
        if (page instanceof PageStreamData) {
            this.data = (PageStreamData)page;
        }
        if (this.data == null || this.data.getLogKey() != this.logKey) {
            this.endOfFile = true;
            return;
        }
        this.dataPos = PageStreamData.getReadStart();
        this.remaining = this.store.getPageSize() - this.dataPos;
    }

    BitField allocateAllPages() {
        BitField bitField = new BitField();
        int n = this.logKey;
        PageStreamTrunk.Iterator iterator = new PageStreamTrunk.Iterator(this.store, this.firstTrunkPage);
        block0: while (true) {
            PageStreamTrunk pageStreamTrunk = iterator.next();
            ++n;
            if (iterator.canDelete()) {
                this.store.allocatePage(iterator.getCurrentPageId());
            }
            if (pageStreamTrunk == null || pageStreamTrunk.getLogKey() != n) break;
            bitField.set(pageStreamTrunk.getPos());
            int n2 = 0;
            while (true) {
                int n3;
                if ((n3 = pageStreamTrunk.getPageData(n2)) == -1) continue block0;
                bitField.set(n3);
                this.store.allocatePage(n3);
                ++n2;
            }
            break;
        }
        return bitField;
    }

    int getDataPage() {
        return this.data.getPos();
    }

    @Override
    public void close() {
    }
}

