/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.ning.compress;

import java.lang.ref.SoftReference;

public final class BufferRecycler {
    private static final int MIN_ENCODING_BUFFER = 4000;
    private static final int MIN_OUTPUT_BUFFER = 8000;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    private byte[] _inputBuffer;
    private byte[] _outputBuffer;
    private byte[] _decodingBuffer;
    private byte[] _encodingBuffer;
    private int[] _encodingHash;

    public static BufferRecycler instance() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            _recyclerRef.set(new SoftReference<BufferRecycler>(br));
        }
        return br;
    }

    public byte[] allocEncodingBuffer(int minSize) {
        byte[] buf = this._encodingBuffer;
        if (buf == null || buf.length < minSize) {
            buf = new byte[Math.max(minSize, 4000)];
        } else {
            this._encodingBuffer = null;
        }
        return buf;
    }

    public void releaseEncodeBuffer(byte[] buffer) {
        if (this._encodingBuffer == null || buffer != null && buffer.length > this._encodingBuffer.length) {
            this._encodingBuffer = buffer;
        }
    }

    public byte[] allocOutputBuffer(int minSize) {
        byte[] buf = this._outputBuffer;
        if (buf == null || buf.length < minSize) {
            buf = new byte[Math.max(minSize, 8000)];
        } else {
            this._outputBuffer = null;
        }
        return buf;
    }

    public void releaseOutputBuffer(byte[] buffer) {
        if (this._outputBuffer == null || buffer != null && buffer.length > this._outputBuffer.length) {
            this._outputBuffer = buffer;
        }
    }

    public int[] allocEncodingHash(int suggestedSize) {
        int[] buf = this._encodingHash;
        if (buf == null || buf.length < suggestedSize) {
            buf = new int[suggestedSize];
        } else {
            this._encodingHash = null;
        }
        return buf;
    }

    public void releaseEncodingHash(int[] buffer) {
        if (this._encodingHash == null || buffer != null && buffer.length > this._encodingHash.length) {
            this._encodingHash = buffer;
        }
    }

    public byte[] allocInputBuffer(int minSize) {
        byte[] buf = this._inputBuffer;
        if (buf == null || buf.length < minSize) {
            buf = new byte[Math.max(minSize, 8000)];
        } else {
            this._inputBuffer = null;
        }
        return buf;
    }

    public void releaseInputBuffer(byte[] buffer) {
        if (this._inputBuffer == null || buffer != null && buffer.length > this._inputBuffer.length) {
            this._inputBuffer = buffer;
        }
    }

    public byte[] allocDecodeBuffer(int size) {
        byte[] buf = this._decodingBuffer;
        if (buf == null || buf.length < size) {
            buf = new byte[size];
        } else {
            this._decodingBuffer = null;
        }
        return buf;
    }

    public void releaseDecodeBuffer(byte[] buffer) {
        if (this._decodingBuffer == null || buffer != null && buffer.length > this._decodingBuffer.length) {
            this._decodingBuffer = buffer;
        }
    }
}

