/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.ning.compress.lzf;

import java.util.concurrent.atomic.AtomicReference;
import org.glowroot.shaded.ning.compress.lzf.ChunkDecoder;
import org.glowroot.shaded.ning.compress.lzf.LZFException;
import org.glowroot.shaded.ning.compress.lzf.util.ChunkDecoderFactory;

public class LZFDecoder {
    protected static final AtomicReference<ChunkDecoder> _fastDecoderRef = new AtomicReference();
    protected static final AtomicReference<ChunkDecoder> _safeDecoderRef = new AtomicReference();

    public static ChunkDecoder fastDecoder() {
        ChunkDecoder dec = _fastDecoderRef.get();
        if (dec == null) {
            dec = ChunkDecoderFactory.optimalInstance();
            _fastDecoderRef.compareAndSet(null, dec);
        }
        return dec;
    }

    public static ChunkDecoder safeDecoder() {
        ChunkDecoder dec = _safeDecoderRef.get();
        if (dec == null) {
            dec = ChunkDecoderFactory.safeInstance();
            _safeDecoderRef.compareAndSet(null, dec);
        }
        return dec;
    }

    public static int calculateUncompressedSize(byte[] data, int offset, int length) throws LZFException {
        return ChunkDecoder.calculateUncompressedSize(data, length, length);
    }

    public static byte[] decode(byte[] inputBuffer) throws LZFException {
        return LZFDecoder.fastDecoder().decode(inputBuffer, 0, inputBuffer.length);
    }

    public static byte[] decode(byte[] inputBuffer, int offset, int length) throws LZFException {
        return LZFDecoder.fastDecoder().decode(inputBuffer, offset, length);
    }

    public static int decode(byte[] inputBuffer, byte[] targetBuffer) throws LZFException {
        return LZFDecoder.fastDecoder().decode(inputBuffer, 0, inputBuffer.length, targetBuffer);
    }

    public static int decode(byte[] sourceBuffer, int offset, int length, byte[] targetBuffer) throws LZFException {
        return LZFDecoder.fastDecoder().decode(sourceBuffer, offset, length, targetBuffer);
    }

    public static byte[] safeDecode(byte[] inputBuffer) throws LZFException {
        return LZFDecoder.safeDecoder().decode(inputBuffer, 0, inputBuffer.length);
    }

    public static byte[] safeDecode(byte[] inputBuffer, int offset, int length) throws LZFException {
        return LZFDecoder.safeDecoder().decode(inputBuffer, offset, length);
    }

    public static int safeDecode(byte[] inputBuffer, byte[] targetBuffer) throws LZFException {
        return LZFDecoder.safeDecoder().decode(inputBuffer, 0, inputBuffer.length, targetBuffer);
    }

    public static int safeDecode(byte[] sourceBuffer, int offset, int length, byte[] targetBuffer) throws LZFException {
        return LZFDecoder.safeDecoder().decode(sourceBuffer, offset, length, targetBuffer);
    }
}

