/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.ning.compress.lzf.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.glowroot.shaded.ning.compress.lzf.ChunkDecoder;
import org.glowroot.shaded.ning.compress.lzf.LZFException;
import sun.misc.Unsafe;

public class UnsafeChunkDecoder
extends ChunkDecoder {
    private static final Unsafe unsafe;
    private static final long BYTE_ARRAY_OFFSET;

    @Override
    public final int decodeChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer) throws IOException {
        int bytesRead = UnsafeChunkDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            this._reportCorruptHeader();
        }
        byte type = inputBuffer[2];
        int compLen = UnsafeChunkDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            UnsafeChunkDecoder.readFully(is, false, outputBuffer, 0, compLen);
            return compLen;
        }
        UnsafeChunkDecoder.readFully(is, true, inputBuffer, 0, 2 + compLen);
        int uncompLen = UnsafeChunkDecoder.uint16(inputBuffer, 0);
        this.decodeChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
        return uncompLen;
    }

    @Override
    public final void decodeChunk(byte[] in, int inPos, byte[] out, int outPos, int outEnd) throws LZFException {
        int outputEnd8 = outEnd - 8;
        int outputEnd32 = outEnd - 32;
        block0: do {
            int ctrl = in[inPos++] & 0xFF;
            while (ctrl < 32) {
                if (outPos > outputEnd32) {
                    System.arraycopy(in, inPos, out, outPos, ctrl + 1);
                } else {
                    UnsafeChunkDecoder.copyUpTo32(in, inPos, out, outPos, ctrl);
                }
                inPos += ++ctrl;
                if ((outPos += ctrl) >= outEnd) break block0;
                ctrl = in[inPos++] & 0xFF;
            }
            int len = ctrl >> 5;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (len < 7) {
                if ((ctrl -= in[inPos++] & 0xFF) < -7 && outPos < outputEnd8) {
                    long rawOffset = BYTE_ARRAY_OFFSET + (long)outPos;
                    unsafe.putLong(out, rawOffset, unsafe.getLong(out, rawOffset + (long)ctrl));
                    outPos += len + 2;
                    continue;
                }
                outPos = this.copyOverlappingShort(out, outPos, ctrl, len);
                continue;
            }
            len = (in[inPos++] & 0xFF) + 9;
            if ((ctrl -= in[inPos++] & 0xFF) > -9 || outPos > outputEnd32) {
                outPos = UnsafeChunkDecoder.copyOverlappingLong(out, outPos, ctrl, len - 9);
                continue;
            }
            if (len <= 32) {
                UnsafeChunkDecoder.copyUpTo32(out, outPos + ctrl, outPos, len - 1);
                outPos += len;
                continue;
            }
            UnsafeChunkDecoder.copyLong(out, outPos + ctrl, outPos, len, outputEnd32);
            outPos += len;
        } while (outPos < outEnd);
        if (outPos != outEnd) {
            throw new LZFException("Corrupt data: overrun in decompress, input offset " + inPos + ", output offset " + outPos);
        }
    }

    @Override
    public int skipOrDecodeChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer, long maxToSkip) throws IOException {
        int bytesRead = UnsafeChunkDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            this._reportCorruptHeader();
        }
        byte type = inputBuffer[2];
        int compLen = UnsafeChunkDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            if ((long)compLen <= maxToSkip) {
                UnsafeChunkDecoder.skipFully(is, compLen);
                return compLen;
            }
            UnsafeChunkDecoder.readFully(is, false, outputBuffer, 0, compLen);
            return -(compLen + 1);
        }
        UnsafeChunkDecoder.readFully(is, true, inputBuffer, 0, 2);
        int uncompLen = UnsafeChunkDecoder.uint16(inputBuffer, 0);
        if ((long)uncompLen <= maxToSkip) {
            UnsafeChunkDecoder.skipFully(is, compLen);
            return uncompLen;
        }
        UnsafeChunkDecoder.readFully(is, true, inputBuffer, 2, compLen);
        this.decodeChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
        return -(uncompLen + 1);
    }

    private final int copyOverlappingShort(byte[] out, int outPos, int offset, int len) {
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        switch (len) {
            case 6: {
                out[outPos] = out[outPos++ + offset];
            }
            case 5: {
                out[outPos] = out[outPos++ + offset];
            }
            case 4: {
                out[outPos] = out[outPos++ + offset];
            }
            case 3: {
                out[outPos] = out[outPos++ + offset];
            }
            case 2: {
                out[outPos] = out[outPos++ + offset];
            }
            case 1: {
                out[outPos] = out[outPos++ + offset];
            }
        }
        return outPos;
    }

    private static final int copyOverlappingLong(byte[] out, int outPos, int offset, int len) {
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        out[outPos] = out[outPos++ + offset];
        int end = (len += outPos) - 3;
        while (outPos < end) {
            out[outPos] = out[outPos++ + offset];
            out[outPos] = out[outPos++ + offset];
            out[outPos] = out[outPos++ + offset];
            out[outPos] = out[outPos++ + offset];
        }
        switch (len - outPos) {
            case 3: {
                out[outPos] = out[outPos++ + offset];
            }
            case 2: {
                out[outPos] = out[outPos++ + offset];
            }
            case 1: {
                out[outPos] = out[outPos++ + offset];
            }
        }
        return outPos;
    }

    private static final void copyUpTo32(byte[] buffer, int inputIndex, int outputIndex, int lengthMinusOne) {
        long inPtr = BYTE_ARRAY_OFFSET + (long)inputIndex;
        long outPtr = BYTE_ARRAY_OFFSET + (long)outputIndex;
        unsafe.putLong(buffer, outPtr, unsafe.getLong(buffer, inPtr));
        if (lengthMinusOne > 7) {
            unsafe.putLong(buffer, outPtr += 8L, unsafe.getLong(buffer, inPtr += 8L));
            if (lengthMinusOne > 15) {
                unsafe.putLong(buffer, outPtr += 8L, unsafe.getLong(buffer, inPtr += 8L));
                if (lengthMinusOne > 23) {
                    unsafe.putLong(buffer, outPtr += 8L, unsafe.getLong(buffer, inPtr += 8L));
                }
            }
        }
    }

    private static final void copyUpTo32(byte[] in, int inputIndex, byte[] out, int outputIndex, int lengthMinusOne) {
        long inPtr = BYTE_ARRAY_OFFSET + (long)inputIndex;
        long outPtr = BYTE_ARRAY_OFFSET + (long)outputIndex;
        unsafe.putLong(out, outPtr, unsafe.getLong(in, inPtr));
        if (lengthMinusOne > 7) {
            unsafe.putLong(out, outPtr += 8L, unsafe.getLong(in, inPtr += 8L));
            if (lengthMinusOne > 15) {
                unsafe.putLong(out, outPtr += 8L, unsafe.getLong(in, inPtr += 8L));
                if (lengthMinusOne > 23) {
                    unsafe.putLong(out, outPtr += 8L, unsafe.getLong(in, inPtr += 8L));
                }
            }
        }
    }

    private static final void copyLong(byte[] buffer, int inputIndex, int outputIndex, int length, int outputEnd8) {
        if (outputIndex + length > outputEnd8) {
            UnsafeChunkDecoder.copyLongTail(buffer, inputIndex, outputIndex, length);
            return;
        }
        long inPtr = BYTE_ARRAY_OFFSET + (long)inputIndex;
        long outPtr = BYTE_ARRAY_OFFSET + (long)outputIndex;
        while (length >= 8) {
            unsafe.putLong(buffer, outPtr, unsafe.getLong(buffer, inPtr));
            inPtr += 8L;
            outPtr += 8L;
            length -= 8;
        }
        if (length > 4) {
            unsafe.putLong(buffer, outPtr, unsafe.getLong(buffer, inPtr));
        } else if (length > 0) {
            unsafe.putInt(buffer, outPtr, unsafe.getInt(buffer, inPtr));
        }
    }

    private static final void copyLongTail(byte[] buffer, int inputIndex, int outputIndex, int length) {
        int inEnd = inputIndex + length;
        while (inputIndex < inEnd) {
            buffer[outputIndex++] = buffer[inputIndex++];
        }
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    }
}

