/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.core;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.glowroot.shaded.qos.logback.core.OutputStreamAppender;
import org.glowroot.shaded.qos.logback.core.recovery.ResilientFileOutputStream;
import org.glowroot.shaded.qos.logback.core.util.FileUtil;

public class FileAppender<E>
extends OutputStreamAppender<E> {
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;

    public void setFile(String file) {
        this.fileName = file == null ? file : file.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int errors = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            try {
                this.openFile(this.getFile());
            }
            catch (IOException e) {
                ++errors;
                this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", e);
            }
        } else {
            ++errors;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (errors == 0) {
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String file_name) throws IOException {
        this.lock.lock();
        try {
            File file = new File(file_name);
            boolean result = FileUtil.createMissingParentDirectories(file);
            if (!result) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFos = new ResilientFileOutputStream(file, this.append);
            resilientFos.setContext(this.context);
            this.setOutputStream(resilientFos);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean prudent) {
        this.prudent = prudent;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(E event) throws IOException {
        ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFOS.getChannel();
        if (fileChannel == null) {
            return;
        }
        boolean interrupted = Thread.interrupted();
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long position = fileChannel.position();
            long size = fileChannel.size();
            if (size != position) {
                fileChannel.position(size);
            }
            super.writeOut(event);
        }
        catch (IOException e) {
            resilientFOS.postIOFailure(e);
        }
        finally {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void writeOut(E event) throws IOException {
        if (this.prudent) {
            this.safeWrite(event);
        } else {
            super.writeOut(event);
        }
    }
}

