/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.core.status;

import java.io.PrintStream;
import java.util.List;
import org.glowroot.shaded.qos.logback.core.spi.ContextAwareBase;
import org.glowroot.shaded.qos.logback.core.spi.LifeCycle;
import org.glowroot.shaded.qos.logback.core.status.Status;
import org.glowroot.shaded.qos.logback.core.status.StatusListener;
import org.glowroot.shaded.qos.logback.core.status.StatusManager;
import org.glowroot.shaded.qos.logback.core.util.StatusPrinter;

abstract class OnPrintStreamStatusListenerBase
extends ContextAwareBase
implements StatusListener,
LifeCycle {
    boolean isStarted = false;
    static final long DEFAULT_RETROSPECTIVE = 300L;
    long retrospective = 300L;

    OnPrintStreamStatusListenerBase() {
    }

    protected abstract PrintStream getPrintStream();

    private void print(Status status) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStr(sb, "", status);
        this.getPrintStream().print(sb);
    }

    @Override
    public void addStatusEvent(Status status) {
        if (!this.isStarted) {
            return;
        }
        this.print(status);
    }

    private void retrospectivePrint() {
        if (this.context == null) {
            return;
        }
        long now = System.currentTimeMillis();
        StatusManager sm = this.context.getStatusManager();
        List<Status> statusList = sm.getCopyOfStatusList();
        for (Status status : statusList) {
            long timestamp = status.getDate();
            if (now - timestamp >= this.retrospective) continue;
            this.print(status);
        }
    }

    @Override
    public void start() {
        this.isStarted = true;
        if (this.retrospective > 0L) {
            this.retrospectivePrint();
        }
    }

    public void setRetrospective(long retrospective) {
        this.retrospective = retrospective;
    }

    public long getRetrospective() {
        return this.retrospective;
    }

    @Override
    public void stop() {
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }
}

