/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.glowroot.advicegen.AdviceGenerator;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.plugin.api.weaving.Mixin;
import org.glowroot.plugin.api.weaving.Pointcut;
import org.glowroot.plugin.api.weaving.Shim;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.google.common.collect.ImmutableCollection;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Iterables;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.IsolatedClassLoader;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceBuilder;
import org.glowroot.weaving.ClassLoaders;
import org.glowroot.weaving.LazyDefinedClass;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.MixinTypeBase;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.ShimTypeBase;

public class AdviceCache {
    private static final Logger logger = LoggerFactory.getLogger(AdviceCache.class);
    private static final AtomicInteger jarFileCounter = new AtomicInteger();
    private final ImmutableList<Advice> pluginAdvisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    @Nullable
    private final Instrumentation instrumentation;
    private final File baseDir;
    private volatile ImmutableList<Advice> reweavableAdvisors;
    private volatile ImmutableSet<String> reweavableConfigVersions;
    private volatile ImmutableList<Advice> allAdvisors;

    AdviceCache(List<PluginDescriptor> pluginDescriptors, List<File> pluginJars, List<InstrumentationConfig> reweavableConfigs, @Nullable Instrumentation instrumentation, File baseDir) throws Exception {
        ArrayList<Advice> pluginAdvisors = Lists.newArrayList();
        ArrayList<ShimType> shimTypes = Lists.newArrayList();
        ArrayList<MixinType> mixinTypes = Lists.newArrayList();
        HashMap<Advice, LazyDefinedClass> lazyAdvisors = Maps.newHashMap();
        URL[] pluginJarURLs = new URL[pluginJars.size()];
        for (int i = 0; i < pluginJars.size(); ++i) {
            pluginJarURLs[i] = pluginJars.get(i).toURI().toURL();
        }
        IsolatedClassLoader tempIsolatedClassLoader = new IsolatedClassLoader(pluginJarURLs);
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            for (String aspect : pluginDescriptor.aspects()) {
                try {
                    Class<?> aspectClass = Class.forName(aspect, false, tempIsolatedClassLoader);
                    pluginAdvisors.addAll(AdviceCache.getAdvisors(aspectClass));
                    shimTypes.addAll(AdviceCache.getShimTypes(aspectClass));
                    mixinTypes.addAll(AdviceCache.getMixinTypes(aspectClass));
                }
                catch (ClassNotFoundException e) {
                    logger.warn("aspect not found: {}", (Object)aspect, (Object)e);
                }
            }
            lazyAdvisors.putAll(AdviceGenerator.createAdvisors(pluginDescriptor.instrumentationConfigs(), pluginDescriptor.id()));
        }
        for (Map.Entry entry : lazyAdvisors.entrySet()) {
            pluginAdvisors.add((Advice)entry.getKey());
        }
        if (instrumentation == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(loader, "Context class loader must be set");
            ClassLoaders.defineClassesInClassLoader(lazyAdvisors.values(), loader);
        } else {
            File generatedJarDir = new File(baseDir, "tmp");
            ClassLoaders.createDirectoryOrCleanPreviousContentsWithPrefix(generatedJarDir, "plugin-pointcuts.jar");
            if (!lazyAdvisors.isEmpty()) {
                File file = new File(generatedJarDir, "plugin-pointcuts.jar");
                ClassLoaders.defineClassesInBootstrapClassLoader(lazyAdvisors.values(), instrumentation, file);
            }
        }
        this.pluginAdvisors = ImmutableList.copyOf(pluginAdvisors);
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.instrumentation = instrumentation;
        this.baseDir = baseDir;
        this.updateAdvisors(reweavableConfigs, true);
    }

    Supplier<List<Advice>> getAdvisorsSupplier() {
        return new Supplier<List<Advice>>(){

            @Override
            public List<Advice> get() {
                return AdviceCache.this.allAdvisors;
            }
        };
    }

    @VisibleForTesting
    public List<ShimType> getShimTypes() {
        return this.shimTypes;
    }

    @VisibleForTesting
    public List<MixinType> getMixinTypes() {
        return this.mixinTypes;
    }

    @EnsuresNonNull(value={"reweavableAdvisors", "reweavableConfigVersions", "allAdvisors"})
    public void updateAdvisors(List<InstrumentationConfig> reweavableConfigs, boolean cleanTmpDir) throws Exception {
        ImmutableMap<Advice, LazyDefinedClass> advisors = AdviceGenerator.createAdvisors(reweavableConfigs, null);
        if (this.instrumentation == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(loader, "Context class loader must be set");
            ClassLoaders.defineClassesInClassLoader(advisors.values(), loader);
        } else {
            File generatedJarDir = new File(this.baseDir, "tmp");
            if (cleanTmpDir) {
                ClassLoaders.createDirectoryOrCleanPreviousContentsWithPrefix(generatedJarDir, "config-pointcuts");
            }
            if (!advisors.isEmpty()) {
                String suffix = "";
                int count = jarFileCounter.incrementAndGet();
                if (count > 1) {
                    suffix = "-" + count;
                }
                File jarFile = new File(generatedJarDir, "config-pointcuts" + suffix + ".jar");
                ClassLoaders.defineClassesInBootstrapClassLoader(advisors.values(), this.instrumentation, jarFile);
            }
        }
        this.reweavableAdvisors = ((ImmutableCollection)((Object)advisors.keySet())).asList();
        this.reweavableConfigVersions = AdviceCache.createReweavableConfigVersions(reweavableConfigs);
        this.allAdvisors = ImmutableList.copyOf(Iterables.concat(this.pluginAdvisors, this.reweavableAdvisors));
    }

    public boolean isOutOfSync(List<InstrumentationConfig> reweavableConfigs) {
        HashSet<String> versions = Sets.newHashSet();
        for (InstrumentationConfig reweavableConfig : reweavableConfigs) {
            versions.add(reweavableConfig.version());
        }
        return !versions.equals(this.reweavableConfigVersions);
    }

    private static List<Advice> getAdvisors(Class<?> aspectClass) {
        ArrayList<Advice> advisors = Lists.newArrayList();
        for (Class<?> memberClass : aspectClass.getClasses()) {
            if (!memberClass.isAnnotationPresent(Pointcut.class)) continue;
            try {
                advisors.add(new AdviceBuilder(memberClass, false).build());
            }
            catch (Exception e) {
                logger.error("error creating advice: {}", (Object)memberClass.getName(), (Object)e);
            }
        }
        return advisors;
    }

    private static List<ShimType> getShimTypes(Class<?> aspectClass) throws IOException {
        ArrayList<ShimType> shimTypes = Lists.newArrayList();
        for (Class<?> memberClass : aspectClass.getClasses()) {
            Shim shim = memberClass.getAnnotation(Shim.class);
            if (shim == null) continue;
            shimTypes.add(ShimTypeBase.from(shim, memberClass));
        }
        return shimTypes;
    }

    private static List<MixinType> getMixinTypes(Class<?> aspectClass) throws IOException {
        ArrayList<MixinType> mixinTypes = Lists.newArrayList();
        for (Class<?> memberClass : aspectClass.getClasses()) {
            Mixin mixin = memberClass.getAnnotation(Mixin.class);
            if (mixin == null) continue;
            mixinTypes.add(MixinTypeBase.from(mixin, memberClass));
        }
        return mixinTypes;
    }

    private static ImmutableSet<String> createReweavableConfigVersions(List<InstrumentationConfig> reweavableConfigs) {
        HashSet<String> versions = Sets.newHashSet();
        for (InstrumentationConfig reweavableConfig : reweavableConfigs) {
            versions.add(reweavableConfig.version());
        }
        return ImmutableSet.copyOf(versions);
    }

    @OnlyUsedByTests
    public List<Advice> getAdvisors() {
        return this.getAdvisorsSupplier().get();
    }
}

