/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.plugin.api.config.BooleanProperty;
import org.glowroot.plugin.api.config.ConfigListener;
import org.glowroot.plugin.api.config.ConfigService;
import org.glowroot.plugin.api.config.DoubleProperty;
import org.glowroot.plugin.api.config.StringProperty;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.MapMaker;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class ConfigServiceImpl
implements ConfigService,
ConfigListener {
    private static final Logger logger = LoggerFactory.getLogger(ConfigServiceImpl.class);
    private final org.glowroot.config.ConfigService configService;
    @Nullable
    private final String pluginId;
    private boolean enabled;
    @MonotonicNonNull
    private PluginConfig pluginConfig;
    private final Map<ConfigListener, Boolean> weakConfigListeners = new MapMaker().weakKeys().makeMap();

    static ConfigServiceImpl create(org.glowroot.config.ConfigService configService, List<PluginDescriptor> pluginDescriptors, String pluginId) {
        ConfigServiceImpl configServiceImpl = new ConfigServiceImpl(configService, pluginDescriptors, pluginId);
        configService.addPluginConfigListener(pluginId, configServiceImpl);
        configService.addConfigListener(configServiceImpl);
        return configServiceImpl;
    }

    private ConfigServiceImpl(org.glowroot.config.ConfigService configService, List<PluginDescriptor> pluginDescriptors, String pluginId) {
        this.configService = configService;
        PluginConfig pluginConfig = configService.getPluginConfig(pluginId);
        if (pluginConfig == null) {
            ArrayList<String> ids = Lists.newArrayList();
            for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
                ids.add(pluginDescriptor.id());
            }
            logger.warn("unexpected plugin id: {} (available plugin ids are {})", (Object)pluginId, (Object)Joiner.on(", ").join(ids));
            this.pluginId = null;
        } else {
            this.pluginId = pluginId;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public StringProperty getStringProperty(String name) {
        if (name == null) {
            logger.error("getStringProperty(): argument 'name' must be non-null");
            return new StringPropertyImpl("");
        }
        StringPropertyImpl stringProperty = new StringPropertyImpl(name);
        this.weakConfigListeners.put(stringProperty, true);
        return stringProperty;
    }

    @Override
    public BooleanProperty getBooleanProperty(String name) {
        if (name == null) {
            logger.error("getBooleanProperty(): argument 'name' must be non-null");
            return new BooleanPropertyImpl("");
        }
        BooleanPropertyImpl booleanProperty = new BooleanPropertyImpl(name);
        this.weakConfigListeners.put(booleanProperty, true);
        return booleanProperty;
    }

    @Override
    public DoubleProperty getDoubleProperty(String name) {
        if (name == null) {
            logger.error("getDoubleProperty(): argument 'name' must be non-null");
            return new DoublePropertyImpl("");
        }
        DoublePropertyImpl doubleProperty = new DoublePropertyImpl(name);
        this.weakConfigListeners.put(doubleProperty, true);
        return doubleProperty;
    }

    @Override
    public BooleanProperty getEnabledProperty(String name) {
        if (name == null) {
            logger.error("getEnabledProperty(): argument 'name' must be non-null");
            return new BooleanPropertyImpl("");
        }
        EnabledPropertyImpl enabledProperty = new EnabledPropertyImpl(name);
        this.weakConfigListeners.put(enabledProperty, true);
        return enabledProperty;
    }

    @Override
    public void registerConfigListener(ConfigListener listener) {
        if (this.pluginId == null) {
            return;
        }
        if (listener == null) {
            logger.error("registerConfigListener(): argument 'listener' must be non-null");
            return;
        }
        this.configService.addPluginConfigListener(this.pluginId, listener);
        listener.onChange();
    }

    @Override
    public void onChange() {
        if (this.pluginId == null) {
            this.enabled = true;
        } else {
            PluginConfig pluginConfig = this.configService.getPluginConfig(this.pluginId);
            Preconditions.checkNotNull(pluginConfig);
            this.enabled = pluginConfig.enabled();
            this.pluginConfig = pluginConfig;
        }
        for (ConfigListener weakConfigListener : this.weakConfigListeners.keySet()) {
            weakConfigListener.onChange();
        }
        this.configService.writeMemoryBarrier();
    }

    private class EnabledPropertyImpl
    implements BooleanProperty,
    ConfigListener {
        private final String name;
        private boolean value;

        private EnabledPropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.enabled && ConfigServiceImpl.this.pluginConfig.getBooleanProperty(name);
            }
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.enabled && ConfigServiceImpl.this.pluginConfig.getBooleanProperty(this.name);
            }
        }
    }

    private class DoublePropertyImpl
    implements DoubleProperty,
    ConfigListener {
        private final String name;
        @Nullable
        private Double value;

        private DoublePropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getDoubleProperty(name);
            }
        }

        @Override
        @Nullable
        public Double value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getDoubleProperty(this.name);
            }
        }
    }

    private class BooleanPropertyImpl
    implements BooleanProperty,
    ConfigListener {
        private final String name;
        private boolean value;

        private BooleanPropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getBooleanProperty(name);
            }
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getBooleanProperty(this.name);
            }
        }
    }

    private class StringPropertyImpl
    implements StringProperty,
    ConfigListener {
        private final String name;
        private String value = "";

        private StringPropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getStringProperty(name);
            }
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getStringProperty(this.name);
            }
        }
    }
}

