/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.ErrorMessageBase;
import org.glowroot.transaction.ThrowableInfo;

@ParametersAreNonnullByDefault
@Immutable
public final class ErrorMessage
extends ErrorMessageBase {
    private final String message;
    @Nullable
    private final ThrowableInfo throwable;

    private ErrorMessage(String message, @Nullable ThrowableInfo throwable) {
        this.message = message;
        this.throwable = throwable;
    }

    @Override
    @JsonProperty(value="message")
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty(value="throwable")
    public ThrowableInfo throwable() {
        return this.throwable;
    }

    public final ErrorMessage withMessage(String value) {
        if (this.message == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ErrorMessage(newValue, this.throwable);
    }

    public final ErrorMessage withThrowable(@Nullable ThrowableInfo value) {
        if (this.throwable == value) {
            return this;
        }
        ThrowableInfo newValue = value;
        return new ErrorMessage(this.message, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorMessage && this.equalTo((ErrorMessage)another);
    }

    private boolean equalTo(ErrorMessage another) {
        return this.message.equals(another.message) && Objects.equal(this.throwable, another.throwable);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.message.hashCode();
        h = h * 17 + Objects.hashCode(this.throwable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorMessage").add("message", this.message).add("throwable", this.throwable).toString();
    }

    @JsonCreator
    public static ErrorMessage fromAllAttributes(@JsonProperty(value="message") @Nullable String message, @JsonProperty(value="throwable") @Nullable ThrowableInfo throwable) {
        Builder builder = ErrorMessage.builder();
        if (message != null) {
            builder.message(message);
        }
        if (throwable != null) {
            builder.throwable(throwable);
        }
        return builder.build();
    }

    public static ErrorMessage of(String message, @Nullable ThrowableInfo throwable) {
        return new ErrorMessage(message, throwable);
    }

    public static ErrorMessage copyOf(ErrorMessageBase instance) {
        if (instance instanceof ErrorMessage) {
            return (ErrorMessage)instance;
        }
        return ErrorMessage.builder().message(instance.message()).throwable(instance.throwable()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_MESSAGE = 1L;
        private static final long NONDEFAULT_BIT_THROWABLE = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String message;
        @Nullable
        private ThrowableInfo throwable;

        private Builder() {
        }

        public final Builder message(String message) {
            this.checkNotIsSet(this.messageIsSet(), "message");
            this.message = Preconditions.checkNotNull(message);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder throwable(@Nullable ThrowableInfo throwable) {
            this.checkNotIsSet(this.throwableIsSet(), "throwable");
            this.throwable = throwable;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public ErrorMessage build() {
            this.checkRequiredAttributes();
            return new ErrorMessage(this.message, this.throwable);
        }

        private boolean throwableIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean messageIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ErrorMessage is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            return "Cannot build ErrorMessage, some of required attributes are not set " + attributes;
        }
    }
}

