/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import javax.annotation.Nullable;
import org.glowroot.common.Styles;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.transaction.ErrorMessage;
import org.glowroot.transaction.ThrowableInfo;
import org.glowroot.transaction.ThrowableInfoBase;
import org.immutables.value.Value;

@Value.Immutable
@Styles.AllParameters
public abstract class ErrorMessageBase {
    public abstract String message();

    @Nullable
    public abstract ThrowableInfo throwable();

    public static ErrorMessage from(Throwable t) {
        return ErrorMessageBase.from(null, t);
    }

    public static ErrorMessage from(@Nullable String message) {
        return ErrorMessageBase.from(message, null);
    }

    public static ErrorMessage from(@Nullable String message, @Nullable Throwable t) {
        String msg = Strings.nullToEmpty(message);
        if (t == null) {
            return ErrorMessage.of(msg, null);
        }
        if (msg.isEmpty()) {
            msg = Strings.nullToEmpty(t.getMessage());
        }
        return ErrorMessage.of(msg, ThrowableInfoBase.from(t));
    }
}

