/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.api.internal.GlowrootService;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.primitives.Ints;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.ErrorMessageBase;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.UserProfileScheduler;
import org.glowroot.transaction.model.Transaction;

class GlowrootServiceImpl
implements GlowrootService {
    private static final Logger logger = LoggerFactory.getLogger(GlowrootServiceImpl.class);
    private final TransactionRegistry transactionRegistry;
    private final UserProfileScheduler userProfileScheduler;

    GlowrootServiceImpl(TransactionRegistry transactionRegistry, UserProfileScheduler userProfileScheduler) {
        this.transactionRegistry = transactionRegistry;
        this.userProfileScheduler = userProfileScheduler;
    }

    @Override
    public void setTransactionType(@Nullable String transactionType) {
        if (Strings.isNullOrEmpty(transactionType)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionType(transactionType, Transaction.OverrideSource.USER_API);
        }
    }

    @Override
    public void setTransactionName(@Nullable String transactionName) {
        if (Strings.isNullOrEmpty(transactionName)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionName(transactionName, Transaction.OverrideSource.USER_API);
        }
    }

    @Override
    public void setTransactionError(@Nullable Throwable t) {
        if (t == null) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(ErrorMessageBase.from(t), Transaction.OverrideSource.USER_API);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message) {
        if (Strings.isNullOrEmpty(message)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(ErrorMessageBase.from(message), Transaction.OverrideSource.USER_API);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message, @Nullable Throwable t) {
        if (Strings.isNullOrEmpty(message) && t == null) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(ErrorMessageBase.from(message, t), Transaction.OverrideSource.USER_API);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user) {
        if (Strings.isNullOrEmpty(user)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setUser(user, Transaction.OverrideSource.USER_API);
            if (transaction.getUserProfileRunnable() == null) {
                this.userProfileScheduler.maybeScheduleUserProfiling(transaction, user);
            }
        }
    }

    @Override
    public void addTransactionCustomAttribute(String name, @Nullable String value) {
        if (name == null) {
            logger.error("addTransactionCustomAttribute(): argument 'name' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.addCustomAttribute(name, value);
        }
    }

    @Override
    public void setTransactionSlowThreshold(long threshold, TimeUnit unit) {
        if (threshold < 0L) {
            logger.error("setTransactionSlowThreshold(): argument 'threshold' must be non-negative");
            return;
        }
        if (unit == null) {
            logger.error("setTransactionSlowThreshold(): argument 'unit' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            int thresholdMillis = Ints.saturatedCast(unit.toMillis(threshold));
            transaction.setSlowThresholdMillis(thresholdMillis, Transaction.OverrideSource.USER_API);
        }
    }
}

