/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.glowroot.shaded.google.common.io.ByteStreams;

class IsolatedClassLoader
extends URLClassLoader {
    IsolatedClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] b;
        if (this.useBootstrapClassLoader(name)) {
            return super.findClass(name);
        }
        String resourceName = name.replace('.', '/') + ".class";
        InputStream input = this.getResourceAsStream(resourceName);
        if (input == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            b = ByteStreams.toByteArray(input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf != -1) {
            String packageName = name.substring(0, lastIndexOf);
            this.createPackageIfNecessary(packageName);
        }
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.useBootstrapClassLoader(name)) {
            return super.loadClass(name, resolve);
        }
        return this.findClass(name);
    }

    private boolean useBootstrapClassLoader(String name) {
        return name.startsWith("java.") || name.startsWith("sun.") || name.startsWith("javax.management.") || name.startsWith("org.glowroot.plugin.api.");
    }

    private void createPackageIfNecessary(String packageName) {
        if (this.getPackage(packageName) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }
}

