/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.api.internal.GlowrootService;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.markers.UsedByReflection;
import org.glowroot.plugin.api.config.ConfigService;
import org.glowroot.plugin.api.internal.ServiceRegistry;
import org.glowroot.plugin.api.transaction.TransactionService;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;

@UsedByReflection
public class ServiceRegistryImpl
implements ServiceRegistry {
    @MonotonicNonNull
    private static volatile ServiceRegistryImpl INSTANCE;
    private final GlowrootService glowrootService;
    private final TransactionService transactionService;
    private final LoadingCache<String, ConfigService> configServices;

    ServiceRegistryImpl(GlowrootService glowrootService, TransactionService transactionService, final ConfigServiceFactory configServiceFactory) {
        this.glowrootService = glowrootService;
        this.transactionService = transactionService;
        this.configServices = CacheBuilder.newBuilder().build(new CacheLoader<String, ConfigService>(){

            @Override
            public ConfigService load(String pluginId) {
                return configServiceFactory.create(pluginId);
            }
        });
    }

    @Override
    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    @Override
    public ConfigService getConfigService(String pluginId) {
        return this.configServices.getUnchecked(pluginId);
    }

    @Nullable
    @UsedByReflection
    public static ServiceRegistry getInstance() {
        return INSTANCE;
    }

    @Nullable
    @UsedByReflection
    public static GlowrootService getGlowrootService() {
        return INSTANCE == null ? null : ServiceRegistryImpl.INSTANCE.glowrootService;
    }

    static ServiceRegistryImpl init(GlowrootService glowrootService, TransactionService transactionService, ConfigServiceFactory configServiceFactory) throws Exception {
        INSTANCE = new ServiceRegistryImpl(glowrootService, transactionService, configServiceFactory);
        return INSTANCE;
    }

    @OnlyUsedByTests
    static void reopen(ServiceRegistryImpl pluginServiceRegistry) throws Exception {
        INSTANCE = pluginServiceRegistry;
    }

    static interface ConfigServiceFactory {
        public ConfigService create(String var1);
    }
}

