/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.ThrowableInfoBase;

@ParametersAreNonnullByDefault
@Immutable
public final class ThrowableInfo
extends ThrowableInfoBase {
    private final String display;
    private final ImmutableList<StackTraceElement> stackTrace;
    private final int framesInCommonWithCaused;
    @Nullable
    private final ThrowableInfo cause;

    private ThrowableInfo(String display, ImmutableList<StackTraceElement> stackTrace, int framesInCommonWithCaused, @Nullable ThrowableInfo cause) {
        this.display = display;
        this.stackTrace = stackTrace;
        this.framesInCommonWithCaused = framesInCommonWithCaused;
        this.cause = cause;
    }

    @Override
    @JsonProperty(value="display")
    public String display() {
        return this.display;
    }

    @JsonProperty(value="stackTrace")
    public ImmutableList<StackTraceElement> stackTrace() {
        return this.stackTrace;
    }

    @Override
    @JsonProperty(value="framesInCommonWithCaused")
    public int framesInCommonWithCaused() {
        return this.framesInCommonWithCaused;
    }

    @Override
    @JsonProperty(value="cause")
    public ThrowableInfo cause() {
        return this.cause;
    }

    public final ThrowableInfo withDisplay(String value) {
        if (this.display == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ThrowableInfo(newValue, this.stackTrace, this.framesInCommonWithCaused, this.cause);
    }

    public final ThrowableInfo withStackTrace(StackTraceElement ... elements) {
        ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
        return new ThrowableInfo(this.display, newValue, this.framesInCommonWithCaused, this.cause);
    }

    public final ThrowableInfo withStackTrace(Iterable<? extends StackTraceElement> elements) {
        if (this.stackTrace == elements) {
            return this;
        }
        ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
        return new ThrowableInfo(this.display, newValue, this.framesInCommonWithCaused, this.cause);
    }

    public final ThrowableInfo withFramesInCommonWithCaused(int value) {
        if (this.framesInCommonWithCaused == value) {
            return this;
        }
        int newValue = value;
        return new ThrowableInfo(this.display, this.stackTrace, newValue, this.cause);
    }

    public final ThrowableInfo withCause(@Nullable ThrowableInfo value) {
        if (this.cause == value) {
            return this;
        }
        ThrowableInfo newValue = value;
        return new ThrowableInfo(this.display, this.stackTrace, this.framesInCommonWithCaused, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ThrowableInfo && this.equalTo((ThrowableInfo)another);
    }

    private boolean equalTo(ThrowableInfo another) {
        return this.display.equals(another.display) && this.stackTrace.equals(another.stackTrace) && this.framesInCommonWithCaused == another.framesInCommonWithCaused && Objects.equal(this.cause, another.cause);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.display.hashCode();
        h = h * 17 + this.stackTrace.hashCode();
        h = h * 17 + this.framesInCommonWithCaused;
        h = h * 17 + Objects.hashCode(this.cause);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThrowableInfo").add("display", this.display).add("stackTrace", this.stackTrace).add("framesInCommonWithCaused", this.framesInCommonWithCaused).add("cause", this.cause).toString();
    }

    @JsonCreator
    public static ThrowableInfo fromAllAttributes(@JsonProperty(value="display") @Nullable String display, @JsonProperty(value="stackTrace") @Nullable List<StackTraceElement> stackTrace, @JsonProperty(value="framesInCommonWithCaused") @Nullable Integer framesInCommonWithCaused, @JsonProperty(value="cause") @Nullable ThrowableInfo cause) {
        Builder builder = ThrowableInfo.builder();
        if (display != null) {
            builder.display(display);
        }
        if (stackTrace != null) {
            builder.addAllStackTrace(stackTrace);
        }
        if (framesInCommonWithCaused != null) {
            builder.framesInCommonWithCaused(framesInCommonWithCaused);
        }
        if (cause != null) {
            builder.cause(cause);
        }
        return builder.build();
    }

    public static ThrowableInfo copyOf(ThrowableInfoBase instance) {
        if (instance instanceof ThrowableInfo) {
            return (ThrowableInfo)instance;
        }
        return ThrowableInfo.builder().display(instance.display()).addAllStackTrace(instance.stackTrace()).framesInCommonWithCaused(instance.framesInCommonWithCaused()).cause(instance.cause()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_DISPLAY = 1L;
        private static final long INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED = 2L;
        private static final long NONDEFAULT_BIT_CAUSE = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String display;
        private ImmutableList.Builder<StackTraceElement> stackTraceBuilder = ImmutableList.builder();
        private int framesInCommonWithCaused;
        @Nullable
        private ThrowableInfo cause;

        private Builder() {
        }

        public final Builder display(String display) {
            this.checkNotIsSet(this.displayIsSet(), "display");
            this.display = Preconditions.checkNotNull(display);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addStackTrace(StackTraceElement element) {
            this.stackTraceBuilder.add((Object)element);
            return this;
        }

        public final Builder addStackTrace(StackTraceElement ... elements) {
            this.stackTraceBuilder.add(elements);
            return this;
        }

        public final Builder addAllStackTrace(Iterable<? extends StackTraceElement> elements) {
            this.stackTraceBuilder.addAll(elements);
            return this;
        }

        public final Builder framesInCommonWithCaused(int framesInCommonWithCaused) {
            this.checkNotIsSet(this.framesInCommonWithCausedIsSet(), "framesInCommonWithCaused");
            this.framesInCommonWithCaused = framesInCommonWithCaused;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder cause(@Nullable ThrowableInfo cause) {
            this.checkNotIsSet(this.causeIsSet(), "cause");
            this.cause = cause;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public ThrowableInfo build() {
            this.checkRequiredAttributes();
            return new ThrowableInfo(this.display, (ImmutableList)this.stackTraceBuilder.build(), this.framesInCommonWithCaused, this.cause);
        }

        private boolean causeIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean displayIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean framesInCommonWithCausedIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ThrowableInfo is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.displayIsSet()) {
                attributes.add("display");
            }
            if (!this.framesInCommonWithCausedIsSet()) {
                attributes.add("framesInCommonWithCaused");
            }
            return "Cannot build ThrowableInfo, some of required attributes are not set " + attributes;
        }
    }
}

