/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.transaction.ThrowableInfo;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ThrowableInfoBase {
    public abstract String display();

    public abstract List<StackTraceElement> stackTrace();

    public abstract int framesInCommonWithCaused();

    @Nullable
    public abstract ThrowableInfo cause();

    public static ThrowableInfo from(Throwable t) {
        return ThrowableInfoBase.from(t, null);
    }

    private static ThrowableInfo from(Throwable t, @Nullable List<StackTraceElement> causedStackTrace) {
        int framesInCommon = 0;
        List<StackTraceElement> stackTrace = ImmutableList.copyOf(t.getStackTrace());
        if (causedStackTrace != null) {
            StackTraceElement causedElement;
            StackTraceElement element;
            ListIterator i = stackTrace.listIterator(stackTrace.size());
            ListIterator<StackTraceElement> j = causedStackTrace.listIterator(causedStackTrace.size());
            while (i.hasPrevious() && j.hasPrevious() && (element = (StackTraceElement)i.previous()).equals(causedElement = j.previous())) {
                ++framesInCommon;
            }
            if (framesInCommon > 0) {
                stackTrace = stackTrace.subList(0, stackTrace.size() - framesInCommon);
            }
        }
        ThrowableInfo.Builder builder = ThrowableInfo.builder().display(t.toString()).addAllStackTrace(stackTrace).framesInCommonWithCaused(framesInCommon);
        Throwable cause = t.getCause();
        if (cause != null) {
            builder.cause(ThrowableInfoBase.from(cause, Arrays.asList(t.getStackTrace())));
        }
        return builder.build();
    }
}

