/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import org.glowroot.plugin.api.transaction.TimerName;
import org.glowroot.plugin.api.weaving.Pointcut;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.TimerNameImpl;

class TimerNameCache {
    private static final Logger logger = LoggerFactory.getLogger(TimerNameCache.class);
    private final LoadingCache<String, TimerNameImpl> names = CacheBuilder.newBuilder().build(new CacheLoader<String, TimerNameImpl>(){

        @Override
        public TimerNameImpl load(String name) {
            return TimerNameImpl.of(name);
        }
    });

    TimerNameCache() {
    }

    TimerName getName(Class<?> adviceClass) {
        if (adviceClass == null) {
            logger.error("get(): argument 'adviceClass' must be non-null");
            return this.getUnknownName();
        }
        Pointcut pointcut = adviceClass.getAnnotation(Pointcut.class);
        if (pointcut == null) {
            logger.warn("advice has no @Pointcut: {}", (Object)adviceClass.getName());
            return this.getUnknownName();
        }
        if (pointcut.timerName().isEmpty()) {
            logger.warn("advice @Pointcut has no timerName() attribute: {}", (Object)adviceClass.getName());
            return this.getUnknownName();
        }
        return this.getName(pointcut.timerName());
    }

    private TimerName getName(String name) {
        return this.names.getUnchecked(name);
    }

    private TimerName getUnknownName() {
        return this.names.getUnchecked("unknown");
    }
}

