/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.common.Clock;
import org.glowroot.config.AdvancedConfig;
import org.glowroot.config.ConfigService;
import org.glowroot.config.PluginConfig;
import org.glowroot.jvm.ThreadAllocatedBytes;
import org.glowroot.plugin.api.config.ConfigListener;
import org.glowroot.plugin.api.internal.NopTransactionService;
import org.glowroot.plugin.api.transaction.MessageSupplier;
import org.glowroot.plugin.api.transaction.QueryEntry;
import org.glowroot.plugin.api.transaction.Timer;
import org.glowroot.plugin.api.transaction.TimerName;
import org.glowroot.plugin.api.transaction.TraceEntry;
import org.glowroot.plugin.api.transaction.TransactionService;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.primitives.Ints;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.ErrorMessage;
import org.glowroot.transaction.ErrorMessageBase;
import org.glowroot.transaction.TimerNameCache;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.UserProfileScheduler;
import org.glowroot.transaction.model.QueryData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.TimerNameImpl;
import org.glowroot.transaction.model.TraceEntryImpl;
import org.glowroot.transaction.model.Transaction;

class TransactionServiceImpl
implements TransactionService,
ConfigListener {
    private static final Logger logger = LoggerFactory.getLogger(TransactionServiceImpl.class);
    private final TransactionRegistry transactionRegistry;
    private final TransactionCollector transactionCollector;
    private final ConfigService configService;
    private final TimerNameCache timerNameCache;
    @Nullable
    private final ThreadAllocatedBytes threadAllocatedBytes;
    private final UserProfileScheduler userProfileScheduler;
    private final Clock clock;
    private final Ticker ticker;
    private final TransactionCompletionCallback transactionCompletionCallback = new TransactionCompletionCallback();
    private boolean captureThreadInfo;
    private boolean captureGcInfo;
    private int maxAggregateQueriesPerQueryType;
    private int maxTraceEntriesPerTransaction;
    @MonotonicNonNull
    private PluginConfig pluginConfig;

    static TransactionServiceImpl create(TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, ConfigService configService, TimerNameCache timerNameCache, @Nullable ThreadAllocatedBytes threadAllocatedBytes, UserProfileScheduler userProfileScheduler, Ticker ticker, Clock clock) {
        TransactionServiceImpl transactionServiceImpl = new TransactionServiceImpl(transactionRegistry, transactionCollector, configService, timerNameCache, threadAllocatedBytes, userProfileScheduler, ticker, clock);
        configService.addConfigListener(transactionServiceImpl);
        return transactionServiceImpl;
    }

    private TransactionServiceImpl(TransactionRegistry transactionRegistry, TransactionCollector transactionCollector, ConfigService configService, TimerNameCache timerNameCache, @Nullable ThreadAllocatedBytes threadAllocatedBytes, UserProfileScheduler userProfileScheduler, Ticker ticker, Clock clock) {
        this.transactionRegistry = transactionRegistry;
        this.transactionCollector = transactionCollector;
        this.configService = configService;
        this.timerNameCache = timerNameCache;
        this.threadAllocatedBytes = threadAllocatedBytes;
        this.userProfileScheduler = userProfileScheduler;
        this.clock = clock;
        this.ticker = ticker;
    }

    @Override
    public TimerName getTimerName(Class<?> adviceClass) {
        return this.timerNameCache.getName(adviceClass);
    }

    @Override
    public TraceEntry startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName) {
        if (transactionType == null) {
            logger.error("startTransaction(): argument 'transactionType' must be non-null");
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        if (transactionName == null) {
            logger.error("startTransaction(): argument 'transactionName' must be non-null");
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        if (messageSupplier == null) {
            logger.error("startTransaction(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        if (timerName == null) {
            logger.error("startTransaction(): argument 'timerName' must be non-null");
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        this.configService.readMemoryBarrier();
        return this.startTransactionInternal(transactionType, transactionName, messageSupplier, timerName);
    }

    @Override
    public TraceEntry startTraceEntry(MessageSupplier messageSupplier, TimerName timerName) {
        if (messageSupplier == null) {
            logger.error("startTraceEntry(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        if (timerName == null) {
            logger.error("startTraceEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopTransactionService.NopTraceEntry.INSTANCE;
        }
        return this.startTraceEntryInternal(transaction, messageSupplier, null, null, 0L, timerName);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, MessageSupplier messageSupplier, TimerName timerName) {
        return this.startQueryEntry(queryType, queryText, 1L, messageSupplier, timerName);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, long queryExecutionCount, MessageSupplier messageSupplier, TimerName timerName) {
        if (queryType == null) {
            logger.error("startQuery(): argument 'queryType' must be non-null");
            return NopTransactionService.NopQueryEntry.INSTANCE;
        }
        if (queryText == null) {
            logger.error("startQuery(): argument 'queryText' must be non-null");
            return NopTransactionService.NopQueryEntry.INSTANCE;
        }
        if (messageSupplier == null) {
            logger.error("startQuery(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.NopQueryEntry.INSTANCE;
        }
        if (timerName == null) {
            logger.error("startQuery(): argument 'timerName' must be non-null");
            return NopTransactionService.NopQueryEntry.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopTransactionService.NopQueryEntry.INSTANCE;
        }
        return this.startTraceEntryInternal(transaction, messageSupplier, queryType, queryText, queryExecutionCount, timerName);
    }

    @Override
    public Timer startTimer(TimerName timerName) {
        if (timerName == null) {
            logger.error("startTimer(): argument 'timerName' must be non-null");
            return NopTransactionService.NopTimer.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopTransactionService.NopTimer.INSTANCE;
        }
        TimerImpl currentTimer = transaction.getCurrentTimer();
        if (currentTimer == null) {
            return NopTransactionService.NopTimer.INSTANCE;
        }
        return currentTimer.startNestedTimer(timerName);
    }

    @Override
    public void addErrorEntry(Throwable t) {
        this.addErrorEntryInternal(ErrorMessageBase.from(t));
    }

    @Override
    public void addErrorEntry(@Nullable String message) {
        this.addErrorEntryInternal(ErrorMessageBase.from(message));
    }

    @Override
    public void addErrorEntry(@Nullable String message, Throwable t) {
        this.addErrorEntryInternal(ErrorMessageBase.from(message, t));
    }

    private void addErrorEntryInternal(ErrorMessage errorMessage) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null && transaction.getEntryCount() < 2 * this.maxTraceEntriesPerTransaction) {
            long currTick = this.ticker.read();
            TraceEntryImpl entry = transaction.addEntry(currTick, currTick, null, errorMessage, true);
            if (errorMessage.throwable() == null) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                entry.setStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(stackTrace).subList(4, stackTrace.length));
            }
        }
    }

    @Override
    public void setTransactionType(@Nullable String transactionType) {
        if (Strings.isNullOrEmpty(transactionType)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionType(transactionType, Transaction.OverrideSource.PLUGIN_API);
        }
    }

    @Override
    public void setTransactionName(@Nullable String transactionName) {
        if (Strings.isNullOrEmpty(transactionName)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionName(transactionName, Transaction.OverrideSource.PLUGIN_API);
        }
    }

    @Override
    public void setTransactionError(@Nullable Throwable t) {
        if (t == null) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(ErrorMessageBase.from(t), Transaction.OverrideSource.PLUGIN_API);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message) {
        if (Strings.isNullOrEmpty(message)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(ErrorMessageBase.from(message), Transaction.OverrideSource.PLUGIN_API);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message, @Nullable Throwable t) {
        if (Strings.isNullOrEmpty(message) && t == null) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setError(ErrorMessageBase.from(message, t), Transaction.OverrideSource.PLUGIN_API);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user) {
        if (Strings.isNullOrEmpty(user)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setUser(user, Transaction.OverrideSource.PLUGIN_API);
            if (transaction.getUserProfileRunnable() == null) {
                this.userProfileScheduler.maybeScheduleUserProfiling(transaction, user);
            }
        }
    }

    @Override
    public void addTransactionCustomAttribute(String name, @Nullable String value) {
        if (name == null) {
            logger.error("addTransactionCustomAttribute(): argument 'name' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.addCustomAttribute(name, value);
        }
    }

    @Override
    public void setTransactionSlowThreshold(long threshold, TimeUnit unit) {
        if (threshold < 0L) {
            logger.error("setTransactionSlowThreshold(): argument 'threshold' must be non-negative");
            return;
        }
        if (unit == null) {
            logger.error("setTransactionSlowThreshold(): argument 'unit' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            int thresholdMillis = Ints.saturatedCast(unit.toMillis(threshold));
            transaction.setSlowThresholdMillis(thresholdMillis, Transaction.OverrideSource.PLUGIN_API);
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.transactionRegistry.getCurrentTransaction() != null;
    }

    private TraceEntry startTransactionInternal(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName) {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            long startTick = this.ticker.read();
            transaction = new Transaction(this.clock.currentTimeMillis(), transactionType, transactionName, messageSupplier, timerName, startTick, this.captureThreadInfo, this.captureGcInfo, this.maxAggregateQueriesPerQueryType, this.threadAllocatedBytes, this.transactionCompletionCallback, this.ticker);
            this.transactionRegistry.addTransaction(transaction);
            return transaction.getRootEntry();
        }
        return this.startTraceEntryInternal(transaction, messageSupplier, null, null, 0L, timerName);
    }

    private QueryEntry startTraceEntryInternal(Transaction transaction, MessageSupplier messageSupplier, @Nullable String queryType, @Nullable String queryText, long queryExecutionCount, TimerName timerName) {
        long startTick = this.ticker.read();
        if (transaction.getEntryCount() < this.maxTraceEntriesPerTransaction) {
            TimerImpl timer = this.startTimer(timerName, startTick, transaction);
            return transaction.pushEntry(startTick, messageSupplier, queryType, queryText, queryExecutionCount, timer);
        }
        return this.startDummyTraceEntry(transaction, timerName, messageSupplier, queryType, queryText, queryExecutionCount, startTick);
    }

    private QueryEntry startDummyTraceEntry(Transaction transaction, TimerName timerName, MessageSupplier messageSupplier, @Nullable String queryType, @Nullable String queryText, long queryExecutionCount, long startTick) {
        QueryData queryData = null;
        if (queryType != null && queryText != null) {
            queryData = transaction.getOrCreateQueryDataIfPossible(queryType, queryText);
        }
        transaction.addEntryLimitExceededMarkerIfNeeded();
        TimerImpl timer = this.startTimer(timerName, startTick, transaction);
        return new DummyTraceEntryOrQuery(timer, startTick, transaction, messageSupplier, queryData, queryExecutionCount);
    }

    private TimerImpl startTimer(TimerName timerName, long startTick, Transaction transaction) {
        TimerImpl currentTimer = transaction.getCurrentTimer();
        if (currentTimer == null) {
            return TimerImpl.createRootTimer(transaction, (TimerNameImpl)timerName);
        }
        return currentTimer.startNestedTimer(timerName, startTick);
    }

    @Override
    public void onChange() {
        AdvancedConfig advancedConfig = this.configService.getAdvancedConfig();
        this.maxAggregateQueriesPerQueryType = advancedConfig.maxAggregateQueriesPerQueryType();
        this.maxTraceEntriesPerTransaction = advancedConfig.maxTraceEntriesPerTransaction();
        this.captureThreadInfo = advancedConfig.captureThreadInfo();
        this.captureGcInfo = advancedConfig.captureGcInfo();
    }

    private class DummyTraceEntryOrQuery
    implements QueryEntry,
    Timer {
        private final TimerImpl timer;
        private final long startTick;
        private final Transaction transaction;
        private final MessageSupplier messageSupplier;
        private int selfNestingLevel;
        @MonotonicNonNull
        private TimerImpl extendedTimer;
        @Nullable
        private final QueryData queryData;
        private long currRow = -1L;
        private long maxRow;

        public DummyTraceEntryOrQuery(TimerImpl timer, long startTick, Transaction transaction, @Nullable MessageSupplier messageSupplier, QueryData queryData, long queryExecutionCount) {
            this.timer = timer;
            this.startTick = startTick;
            this.transaction = transaction;
            this.messageSupplier = messageSupplier;
            this.queryData = queryData;
            if (queryData != null) {
                queryData.start(startTick, queryExecutionCount);
            }
        }

        @Override
        public void end() {
            this.endInternal(TransactionServiceImpl.this.ticker.read());
        }

        @Override
        public void endWithStackTrace(long threshold, TimeUnit unit) {
            if (threshold < 0L) {
                logger.error("endWithStackTrace(): argument 'threshold' must be non-negative");
                this.end();
                return;
            }
            this.endInternal(TransactionServiceImpl.this.ticker.read());
        }

        @Override
        public void endWithError(Throwable t) {
            this.endWithErrorInternal(ErrorMessage.from(t));
        }

        @Override
        public void endWithError(@Nullable String message) {
            this.endWithErrorInternal(ErrorMessage.from(message));
        }

        @Override
        public void endWithError(@Nullable String message, Throwable t) {
            this.endWithErrorInternal(ErrorMessage.from(message, t));
        }

        private void endWithErrorInternal(ErrorMessage errorMessage) {
            long endTick = TransactionServiceImpl.this.ticker.read();
            this.endInternal(endTick);
            if (this.transaction.getEntryCount() < 2 * TransactionServiceImpl.this.maxTraceEntriesPerTransaction) {
                TraceEntryImpl entry = this.transaction.addEntry(this.startTick, endTick, this.messageSupplier, errorMessage, true);
                if (errorMessage.throwable() == null) {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    entry.setStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(stackTrace).subList(4, stackTrace.length));
                }
            }
        }

        private void endInternal(long endTick) {
            this.timer.end(endTick);
            if (this.queryData != null) {
                this.queryData.end(endTick);
            }
        }

        @Override
        public Timer extend() {
            if (this.selfNestingLevel++ == 0) {
                long currTick = TransactionServiceImpl.this.ticker.read();
                this.extendedTimer = this.timer.extend(currTick);
                if (this.queryData != null) {
                    this.queryData.extend(currTick);
                }
            }
            return this;
        }

        @Override
        public void stop() {
            if (--this.selfNestingLevel == 0) {
                long stopTick = TransactionServiceImpl.this.ticker.read();
                Preconditions.checkNotNull(this.extendedTimer);
                this.extendedTimer.end(stopTick);
                if (this.queryData != null) {
                    this.queryData.end(stopTick);
                }
            }
        }

        @Override
        public MessageSupplier getMessageSupplier() {
            return this.messageSupplier;
        }

        @Override
        public void incrementCurrRow() {
            if (this.currRow == -1L) {
                this.currRow = 1L;
                this.maxRow = 1L;
                if (this.queryData != null) {
                    this.queryData.incrementRowCount(1L);
                }
            } else if (this.currRow == this.maxRow) {
                ++this.currRow;
                this.maxRow = this.currRow;
                if (this.queryData != null) {
                    this.queryData.incrementRowCount(1L);
                }
            } else {
                ++this.currRow;
            }
        }

        @Override
        public void setCurrRow(long row) {
            if (row > this.maxRow) {
                if (this.queryData != null) {
                    this.queryData.incrementRowCount(row - this.maxRow);
                }
                this.maxRow = row;
            }
            this.currRow = row;
        }
    }

    private class TransactionCompletionCallback
    implements Transaction.CompletionCallback {
        private TransactionCompletionCallback() {
        }

        @Override
        public void completed(Transaction transaction) {
            TransactionServiceImpl.this.transactionCollector.onCompletedTransaction(transaction);
            TransactionServiceImpl.this.transactionRegistry.removeTransaction(transaction);
        }
    }
}

