/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.glowroot.common.Styles;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.ProfileNode;
import org.glowroot.transaction.model.StackTraceElementPlus;
import org.immutables.value.Value;

public class Profile {
    private static final Pattern timerMarkerMethodPattern = Pattern.compile("^.*\\$glowroot\\$timer\\$(.*)\\$[0-9]+$");
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final List<List<StackTraceElement>> unmergedStackTraces = Lists.newArrayList();
    @GuardedBy(value="lock")
    private final List<String> unmergedStackTraceThreadStates = Lists.newArrayList();
    @GuardedBy(value="lock")
    private final ProfileNode syntheticRootNode = ProfileNode.createSyntheticRoot();
    private final boolean mayHaveSyntheticTimerMethods;

    @VisibleForTesting
    public Profile(boolean mayHaveSyntheticTimerMethods) {
        this.mayHaveSyntheticTimerMethods = mayHaveSyntheticTimerMethods;
    }

    public Object getLock() {
        return this.lock;
    }

    public ProfileNode getSyntheticRootNode() {
        this.mergeTheUnmergedStackTraces();
        return this.syntheticRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampleCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.syntheticRootNode.getSampleCount() + (long)this.unmergedStackTraces.size();
        }
    }

    public boolean mayHaveSyntheticTimerMethods() {
        return this.mayHaveSyntheticTimerMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStackTrace(ThreadInfo threadInfo, int limit) {
        Object object = this.lock;
        synchronized (object) {
            if (this.syntheticRootNode.getSampleCount() + (long)this.unmergedStackTraces.size() >= (long)limit) {
                return;
            }
            List<StackTraceElement> stackTrace = Arrays.asList(threadInfo.getStackTrace());
            this.unmergedStackTraces.add(stackTrace);
            this.unmergedStackTraceThreadStates.add(threadInfo.getThreadState().name());
            if (this.unmergedStackTraces.size() >= 10) {
                this.mergeTheUnmergedStackTraces();
            }
        }
    }

    private void mergeTheUnmergedStackTraces() {
        for (int i = 0; i < this.unmergedStackTraces.size(); ++i) {
            List<StackTraceElement> stackTrace = this.unmergedStackTraces.get(i);
            String threadState = this.unmergedStackTraceThreadStates.get(i);
            if (this.mayHaveSyntheticTimerMethods) {
                this.addToStackTree(Profile.stripSyntheticTimerMethods(stackTrace), threadState);
                continue;
            }
            this.addToStackTree(stackTrace, threadState);
        }
        this.unmergedStackTraces.clear();
        this.unmergedStackTraceThreadStates.clear();
    }

    @VisibleForTesting
    public void addToStackTree(List<? extends Object> stackTrace, String threadState) {
        this.syntheticRootNode.incrementSampleCount(1L);
        ProfileNode lastMatchedNode = this.syntheticRootNode;
        Iterable<ProfileNode> nextChildNodes = this.syntheticRootNode.getChildNodes();
        for (int nextIndex = stackTrace.size() - 1; nextIndex >= 0; --nextIndex) {
            Object element = stackTrace.get(nextIndex);
            ProfileNode matchingNode = null;
            for (ProfileNode childNode : nextChildNodes) {
                if (!Profile.matches(Profile.getStackTraceElement(element), childNode, nextIndex == 0, threadState)) continue;
                matchingNode = childNode;
                break;
            }
            if (matchingNode == null) break;
            matchingNode.incrementSampleCount(1L);
            ImmutableList<String> timerNames = Profile.getTimerNames(element);
            if (timerNames.size() > matchingNode.getTimerNames().size()) {
                matchingNode.setTimerNames(timerNames);
            }
            lastMatchedNode = matchingNode;
            nextChildNodes = lastMatchedNode.getChildNodes();
        }
        for (int i = nextIndex; i >= 0; --i) {
            Object element = stackTrace.get(i);
            StackTraceElement stackTraceElement = Profile.getStackTraceElement(element);
            ProfileNode nextNode = i == 0 ? ProfileNode.create(stackTraceElement, threadState) : ProfileNode.create(stackTraceElement, null);
            nextNode.setTimerNames(Profile.getTimerNames(element));
            nextNode.incrementSampleCount(1L);
            lastMatchedNode.addChildNode(nextNode);
            lastMatchedNode = nextNode;
        }
    }

    public static List<StackTraceElementPlus> stripSyntheticTimerMethods(List<StackTraceElement> stackTrace) {
        ArrayList<StackTraceElementPlus> stackTracePlus = Lists.newArrayListWithCapacity(stackTrace.size());
        Iterator<StackTraceElement> i = stackTrace.iterator();
        while (i.hasNext()) {
            StackTraceElement element = i.next();
            String originalMethodName = element.getMethodName();
            if (originalMethodName == null) continue;
            String timerName = Profile.getTimerName(originalMethodName);
            if (timerName == null) {
                stackTracePlus.add(StackTraceElementPlus.of(element, ImmutableList.<String>of()));
                continue;
            }
            ArrayList<String> timerNames = Lists.newArrayListWithCapacity(2);
            timerNames.add(timerName);
            while (i.hasNext()) {
                StackTraceElement skipElement = i.next();
                String skipMethodName = skipElement.getMethodName();
                if (skipMethodName == null) continue;
                timerName = Profile.getTimerName(skipMethodName);
                if (timerName == null) {
                    originalMethodName = skipMethodName;
                    break;
                }
                timerNames.add(timerName);
            }
            StackTraceElement originalElement = new StackTraceElement(element.getClassName(), originalMethodName, element.getFileName(), element.getLineNumber());
            stackTracePlus.add(StackTraceElementPlus.of(originalElement, timerNames));
        }
        return stackTracePlus;
    }

    @Nullable
    private static String getTimerName(String methodName) {
        if (!methodName.contains("$glowroot$timer$")) {
            return null;
        }
        Matcher matcher = timerMarkerMethodPattern.matcher(methodName);
        if (matcher.matches()) {
            String group = matcher.group(1);
            Preconditions.checkNotNull(group);
            return group.replace("$", " ");
        }
        return null;
    }

    private static boolean matches(StackTraceElement stackTraceElement, ProfileNode childNode, boolean leaf, String threadState) {
        String leafThreadState = childNode.getLeafThreadState();
        if (leafThreadState != null && leaf) {
            return childNode.isSameStackTraceElement(stackTraceElement) && leafThreadState.equals(threadState);
        }
        return leafThreadState == null && !leaf && childNode.isSameStackTraceElement(stackTraceElement);
    }

    private static StackTraceElement getStackTraceElement(Object stackTraceElementOrPlus) {
        StackTraceElement stackTraceElement = stackTraceElementOrPlus instanceof StackTraceElement ? (StackTraceElement)stackTraceElementOrPlus : ((StackTraceElementPlus)stackTraceElementOrPlus).stackTraceElement();
        return stackTraceElement;
    }

    private static ImmutableList<String> getTimerNames(Object stackTraceElementOrPlus) {
        if (stackTraceElementOrPlus instanceof StackTraceElement) {
            return ImmutableList.of();
        }
        return ((StackTraceElementPlus)stackTraceElementOrPlus).timerNames();
    }

    @Value.Immutable
    @Styles.AllParameters
    public static abstract class StackTraceElementPlusBase {
        public abstract StackTraceElement stackTraceElement();

        abstract ImmutableList<String> timerNames();
    }
}

