/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.Profile;

@ParametersAreNonnullByDefault
@Immutable
public final class StackTraceElementPlus
extends Profile.StackTraceElementPlusBase {
    private final StackTraceElement stackTraceElement;
    private final ImmutableList<String> timerNames;

    private StackTraceElementPlus(StackTraceElement stackTraceElement, Iterable<String> timerNames) {
        this.stackTraceElement = Preconditions.checkNotNull(stackTraceElement);
        this.timerNames = ImmutableList.copyOf(timerNames);
    }

    private StackTraceElementPlus(StackTraceElementPlus original, StackTraceElement stackTraceElement, ImmutableList<String> timerNames) {
        this.stackTraceElement = stackTraceElement;
        this.timerNames = timerNames;
    }

    @Override
    @JsonProperty(value="stackTraceElement")
    public StackTraceElement stackTraceElement() {
        return this.stackTraceElement;
    }

    @Override
    @JsonProperty(value="timerNames")
    public ImmutableList<String> timerNames() {
        return this.timerNames;
    }

    public final StackTraceElementPlus withStackTraceElement(StackTraceElement value) {
        if (this.stackTraceElement == value) {
            return this;
        }
        StackTraceElement newValue = Preconditions.checkNotNull(value);
        return new StackTraceElementPlus(this, newValue, this.timerNames);
    }

    public final StackTraceElementPlus withTimerNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new StackTraceElementPlus(this, this.stackTraceElement, newValue);
    }

    public final StackTraceElementPlus withTimerNames(Iterable<String> elements) {
        if (this.timerNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new StackTraceElementPlus(this, this.stackTraceElement, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof StackTraceElementPlus && this.equalTo((StackTraceElementPlus)another);
    }

    private boolean equalTo(StackTraceElementPlus another) {
        return this.stackTraceElement.equals(another.stackTraceElement) && this.timerNames.equals(another.timerNames);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.stackTraceElement.hashCode();
        h = h * 17 + this.timerNames.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StackTraceElementPlus").add("stackTraceElement", this.stackTraceElement).add("timerNames", this.timerNames).toString();
    }

    @JsonCreator
    public static StackTraceElementPlus fromAllAttributes(@JsonProperty(value="stackTraceElement") @Nullable StackTraceElement stackTraceElement, @JsonProperty(value="timerNames") @Nullable ImmutableList<String> timerNames) {
        Builder builder = StackTraceElementPlus.builder();
        if (stackTraceElement != null) {
            builder.stackTraceElement(stackTraceElement);
        }
        if (timerNames != null) {
            builder.addAllTimerNames(timerNames);
        }
        return builder.build();
    }

    public static StackTraceElementPlus of(StackTraceElement stackTraceElement, ImmutableList<String> timerNames) {
        return StackTraceElementPlus.of(stackTraceElement, timerNames);
    }

    public static StackTraceElementPlus of(StackTraceElement stackTraceElement, Iterable<String> timerNames) {
        return new StackTraceElementPlus(stackTraceElement, timerNames);
    }

    public static StackTraceElementPlus copyOf(Profile.StackTraceElementPlusBase instance) {
        if (instance instanceof StackTraceElementPlus) {
            return (StackTraceElementPlus)instance;
        }
        return StackTraceElementPlus.builder().stackTraceElement(instance.stackTraceElement()).addAllTimerNames(instance.timerNames()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_STACK_TRACE_ELEMENT = 1L;
        private long initializedBitset;
        @Nullable
        private StackTraceElement stackTraceElement;
        private ImmutableList.Builder<String> timerNamesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder stackTraceElement(StackTraceElement stackTraceElement) {
            this.checkNotIsSet(this.stackTraceElementIsSet(), "stackTraceElement");
            this.stackTraceElement = Preconditions.checkNotNull(stackTraceElement);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addTimerNames(String element) {
            this.timerNamesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTimerNames(String ... elements) {
            this.timerNamesBuilder.add(elements);
            return this;
        }

        public final Builder addAllTimerNames(Iterable<String> elements) {
            this.timerNamesBuilder.addAll((Iterable)elements);
            return this;
        }

        public StackTraceElementPlus build() {
            this.checkRequiredAttributes();
            return new StackTraceElementPlus(null, this.stackTraceElement, (ImmutableList)this.timerNamesBuilder.build());
        }

        private boolean stackTraceElementIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of StackTraceElementPlus is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.stackTraceElementIsSet()) {
                attributes.add("stackTraceElement");
            }
            return "Cannot build StackTraceElementPlus, some of required attributes are not set " + attributes;
        }
    }
}

