/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.jvm.ThreadAllocatedBytes;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.transaction.model.ThreadInfoData;
import org.glowroot.transaction.model.ThreadInfoSnapshot;
import org.immutables.value.Value;

class ThreadInfoComponent {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final boolean IS_THREAD_CPU_TIME_SUPPORTED = threadMXBean.isThreadCpuTimeSupported();
    private static final boolean IS_THREAD_CONTENTION_MONITORING_SUPPORTED = threadMXBean.isThreadContentionMonitoringSupported();
    private final long threadId;
    private final ThreadInfoSnapshot startingSnapshot;
    @Nullable
    private final ThreadAllocatedBytes threadAllocatedBytes;
    @GuardedBy(value="lock")
    @MonotonicNonNull
    private volatile ThreadInfoData completedThreadInfo;
    private final Object lock = new Object();

    ThreadInfoComponent(@Nullable ThreadAllocatedBytes threadAllocatedBytes) {
        this.threadId = Thread.currentThread().getId();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(this.threadId, 0);
        Preconditions.checkNotNull(threadInfo);
        ThreadInfoSnapshot.Builder builder = ThreadInfoSnapshot.builder();
        if (IS_THREAD_CPU_TIME_SUPPORTED) {
            builder.threadCpuTime(threadMXBean.getCurrentThreadCpuTime());
        }
        if (IS_THREAD_CONTENTION_MONITORING_SUPPORTED) {
            builder.threadBlockedTimeMillis(threadInfo.getBlockedTime());
            builder.threadWaitedTimeMillis(threadInfo.getWaitedTime());
        }
        if (threadAllocatedBytes != null) {
            builder.threadAllocatedBytes(threadAllocatedBytes.getThreadAllocatedBytesSafely(this.threadId));
        }
        this.threadAllocatedBytes = threadAllocatedBytes;
        this.startingSnapshot = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onComplete() {
        Object object = this.lock;
        synchronized (object) {
            this.completedThreadInfo = this.getThreadInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadInfoData getThreadInfo() {
        Object object = this.lock;
        synchronized (object) {
            if (this.completedThreadInfo == null) {
                return this.getThreadInfoInternal();
            }
            return this.completedThreadInfo;
        }
    }

    private ThreadInfoData getThreadInfoInternal() {
        ThreadInfoData.Builder builder = ThreadInfoData.builder();
        ThreadInfo threadInfo = threadMXBean.getThreadInfo(this.threadId, 0);
        if (threadInfo == null) {
            return builder.build();
        }
        if (IS_THREAD_CPU_TIME_SUPPORTED) {
            this.addThreadCpuTime(builder);
        }
        if (IS_THREAD_CONTENTION_MONITORING_SUPPORTED) {
            this.addThreadBlockedAndWaitedTime(builder, threadInfo);
        }
        if (this.threadAllocatedBytes != null) {
            this.addThreadAllocatedBytes(builder);
        }
        return builder.build();
    }

    private void addThreadCpuTime(ThreadInfoData.Builder builder) {
        long threadCpuTime = threadMXBean.getThreadCpuTime(this.threadId);
        if (this.startingSnapshot.threadCpuTime() != -1L && threadCpuTime != -1L) {
            builder.threadCpuTime(threadCpuTime - this.startingSnapshot.threadCpuTime());
        }
    }

    private void addThreadBlockedAndWaitedTime(ThreadInfoData.Builder builder, ThreadInfo threadInfo) {
        long threadBlockedTimeMillis = threadInfo.getBlockedTime();
        if (this.startingSnapshot.threadBlockedTimeMillis() != -1L && threadBlockedTimeMillis != -1L) {
            builder.threadBlockedTime(TimeUnit.MILLISECONDS.toNanos(threadBlockedTimeMillis - this.startingSnapshot.threadBlockedTimeMillis()));
        }
        long threadWaitedTimeMillis = threadInfo.getWaitedTime();
        if (this.startingSnapshot.threadWaitedTimeMillis() != -1L && threadWaitedTimeMillis != -1L) {
            builder.threadWaitedTime(TimeUnit.MILLISECONDS.toNanos(threadWaitedTimeMillis - this.startingSnapshot.threadWaitedTimeMillis()));
        }
    }

    @RequiresNonNull(value={"threadAllocatedBytes"})
    private void addThreadAllocatedBytes(ThreadInfoData.Builder builder) {
        long allocatedBytes = this.threadAllocatedBytes.getThreadAllocatedBytesSafely(this.threadId);
        if (this.startingSnapshot.threadAllocatedBytes() != -1L && allocatedBytes != -1L) {
            builder.threadAllocatedBytes(allocatedBytes - this.startingSnapshot.threadAllocatedBytes());
        }
    }

    @Value.Immutable
    public static abstract class ThreadInfoDataBase {
        @Nullable
        public abstract Long threadCpuTime();

        @Nullable
        public abstract Long threadBlockedTime();

        @Nullable
        public abstract Long threadWaitedTime();

        @Nullable
        public abstract Long threadAllocatedBytes();
    }

    @Value.Immutable
    static abstract class ThreadInfoSnapshotBase {
        ThreadInfoSnapshotBase() {
        }

        long threadCpuTime() {
            return -1L;
        }

        long threadBlockedTimeMillis() {
            return -1L;
        }

        long threadWaitedTimeMillis() {
            return -1L;
        }

        long threadAllocatedBytes() {
            return -1L;
        }
    }
}

