/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.transaction.model.ThreadInfoComponent;

@ParametersAreNonnullByDefault
@Immutable
public final class ThreadInfoData
extends ThreadInfoComponent.ThreadInfoDataBase {
    @Nullable
    private final Long threadCpuTime;
    @Nullable
    private final Long threadBlockedTime;
    @Nullable
    private final Long threadWaitedTime;
    @Nullable
    private final Long threadAllocatedBytes;

    private ThreadInfoData(@Nullable Long threadCpuTime, @Nullable Long threadBlockedTime, @Nullable Long threadWaitedTime, @Nullable Long threadAllocatedBytes) {
        this.threadCpuTime = threadCpuTime;
        this.threadBlockedTime = threadBlockedTime;
        this.threadWaitedTime = threadWaitedTime;
        this.threadAllocatedBytes = threadAllocatedBytes;
    }

    @Override
    @JsonProperty(value="threadCpuTime")
    public Long threadCpuTime() {
        return this.threadCpuTime;
    }

    @Override
    @JsonProperty(value="threadBlockedTime")
    public Long threadBlockedTime() {
        return this.threadBlockedTime;
    }

    @Override
    @JsonProperty(value="threadWaitedTime")
    public Long threadWaitedTime() {
        return this.threadWaitedTime;
    }

    @Override
    @JsonProperty(value="threadAllocatedBytes")
    public Long threadAllocatedBytes() {
        return this.threadAllocatedBytes;
    }

    public final ThreadInfoData withThreadCpuTime(@Nullable Long value) {
        if (this.threadCpuTime == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(newValue, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes);
    }

    public final ThreadInfoData withThreadBlockedTime(@Nullable Long value) {
        if (this.threadBlockedTime == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this.threadCpuTime, newValue, this.threadWaitedTime, this.threadAllocatedBytes);
    }

    public final ThreadInfoData withThreadWaitedTime(@Nullable Long value) {
        if (this.threadWaitedTime == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this.threadCpuTime, this.threadBlockedTime, newValue, this.threadAllocatedBytes);
    }

    public final ThreadInfoData withThreadAllocatedBytes(@Nullable Long value) {
        if (this.threadAllocatedBytes == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ThreadInfoData && this.equalTo((ThreadInfoData)another);
    }

    private boolean equalTo(ThreadInfoData another) {
        return Objects.equal(this.threadCpuTime, another.threadCpuTime) && Objects.equal(this.threadBlockedTime, another.threadBlockedTime) && Objects.equal(this.threadWaitedTime, another.threadWaitedTime) && Objects.equal(this.threadAllocatedBytes, another.threadAllocatedBytes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.threadCpuTime);
        h = h * 17 + Objects.hashCode(this.threadBlockedTime);
        h = h * 17 + Objects.hashCode(this.threadWaitedTime);
        h = h * 17 + Objects.hashCode(this.threadAllocatedBytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThreadInfoData").add("threadCpuTime", this.threadCpuTime).add("threadBlockedTime", this.threadBlockedTime).add("threadWaitedTime", this.threadWaitedTime).add("threadAllocatedBytes", this.threadAllocatedBytes).toString();
    }

    @JsonCreator
    public static ThreadInfoData fromAllAttributes(@JsonProperty(value="threadCpuTime") @Nullable Long threadCpuTime, @JsonProperty(value="threadBlockedTime") @Nullable Long threadBlockedTime, @JsonProperty(value="threadWaitedTime") @Nullable Long threadWaitedTime, @JsonProperty(value="threadAllocatedBytes") @Nullable Long threadAllocatedBytes) {
        Builder builder = ThreadInfoData.builder();
        if (threadCpuTime != null) {
            builder.threadCpuTime(threadCpuTime);
        }
        if (threadBlockedTime != null) {
            builder.threadBlockedTime(threadBlockedTime);
        }
        if (threadWaitedTime != null) {
            builder.threadWaitedTime(threadWaitedTime);
        }
        if (threadAllocatedBytes != null) {
            builder.threadAllocatedBytes(threadAllocatedBytes);
        }
        return builder.build();
    }

    public static ThreadInfoData copyOf(ThreadInfoComponent.ThreadInfoDataBase instance) {
        if (instance instanceof ThreadInfoData) {
            return (ThreadInfoData)instance;
        }
        return ThreadInfoData.builder().threadCpuTime(instance.threadCpuTime()).threadBlockedTime(instance.threadBlockedTime()).threadWaitedTime(instance.threadWaitedTime()).threadAllocatedBytes(instance.threadAllocatedBytes()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_THREAD_CPU_TIME = 1L;
        private static final long NONDEFAULT_BIT_THREAD_BLOCKED_TIME = 2L;
        private static final long NONDEFAULT_BIT_THREAD_WAITED_TIME = 4L;
        private static final long NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES = 8L;
        private long nondefaultBitset;
        @Nullable
        private Long threadCpuTime;
        @Nullable
        private Long threadBlockedTime;
        @Nullable
        private Long threadWaitedTime;
        @Nullable
        private Long threadAllocatedBytes;

        private Builder() {
        }

        public final Builder threadCpuTime(@Nullable Long threadCpuTime) {
            this.checkNotIsSet(this.threadCpuTimeIsSet(), "threadCpuTime");
            this.threadCpuTime = threadCpuTime;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder threadBlockedTime(@Nullable Long threadBlockedTime) {
            this.checkNotIsSet(this.threadBlockedTimeIsSet(), "threadBlockedTime");
            this.threadBlockedTime = threadBlockedTime;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder threadWaitedTime(@Nullable Long threadWaitedTime) {
            this.checkNotIsSet(this.threadWaitedTimeIsSet(), "threadWaitedTime");
            this.threadWaitedTime = threadWaitedTime;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder threadAllocatedBytes(@Nullable Long threadAllocatedBytes) {
            this.checkNotIsSet(this.threadAllocatedBytesIsSet(), "threadAllocatedBytes");
            this.threadAllocatedBytes = threadAllocatedBytes;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public ThreadInfoData build() {
            return new ThreadInfoData(this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes);
        }

        private boolean threadCpuTimeIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean threadBlockedTimeIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean threadWaitedTimeIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean threadAllocatedBytesIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ThreadInfoData is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

