/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.common.Tickers;
import org.glowroot.plugin.api.transaction.Timer;
import org.glowroot.plugin.api.transaction.TimerName;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.NestedTimerMap;
import org.glowroot.transaction.model.TimerNameImpl;
import org.glowroot.transaction.model.Transaction;

public class TimerImpl
implements Timer {
    private static final Logger logger = LoggerFactory.getLogger(TimerImpl.class);
    private static final Ticker ticker = Tickers.getTicker();
    private final Transaction transaction;
    @Nullable
    private final TimerImpl parent;
    private final TimerNameImpl timerName;
    private long total;
    private long count;
    private long startTick;
    private int selfNestingLevel;
    @MonotonicNonNull
    private NestedTimerMap nestedTimers;
    @MonotonicNonNull
    private TimerImpl headChild;
    @Nullable
    private final TimerImpl nextSibling;

    public static TimerImpl createRootTimer(Transaction transaction, TimerNameImpl timerName) {
        return new TimerImpl(transaction, null, null, timerName);
    }

    private TimerImpl(Transaction transaction, @Nullable TimerImpl parent, @Nullable TimerImpl nextSibling, TimerNameImpl timerName) {
        this.timerName = timerName;
        this.parent = parent;
        this.nextSibling = nextSibling;
        this.transaction = transaction;
    }

    public void writeValue(JsonGenerator jg) throws IOException {
        boolean active;
        jg.writeStartObject();
        jg.writeStringField("name", this.timerName.name());
        if (this.timerName.extended()) {
            jg.writeBooleanField("extended", true);
        }
        boolean bl = active = this.selfNestingLevel > 0;
        if (active) {
            long theTotal = this.total;
            long theStartTick = this.startTick;
            long curr = ticker.read() - theStartTick;
            if (theTotal == 0L) {
                jg.writeNumberField("total", curr);
                jg.writeNumberField("count", 1);
                jg.writeBooleanField("active", true);
            } else {
                jg.writeNumberField("total", theTotal + curr);
                jg.writeNumberField("count", this.count + 1L);
                jg.writeBooleanField("active", true);
            }
        } else {
            jg.writeNumberField("total", this.total);
            jg.writeNumberField("count", this.count);
        }
        if (this.headChild != null) {
            jg.writeArrayFieldStart("nestedTimers");
            TimerImpl curr = this.headChild;
            while (curr != null) {
                curr.writeValue(jg);
                curr = curr.nextSibling;
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    @Override
    public void stop() {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(ticker.read());
        }
    }

    public void end(long endTick) {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(endTick);
        }
    }

    public TimerNameImpl getTimerName() {
        return this.timerName;
    }

    public String getName() {
        return this.timerName.name();
    }

    public boolean isExtended() {
        return this.timerName.extended();
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    public Iterable<TimerImpl> getNestedTimers() {
        if (this.headChild == null) {
            return ImmutableList.of();
        }
        return new Iterable<TimerImpl>(){

            @Override
            public Iterator<TimerImpl> iterator() {
                return new Iterator<TimerImpl>(){
                    @Nullable
                    private TimerImpl next;
                    {
                        this.next = TimerImpl.this.headChild;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public TimerImpl next() {
                        TimerImpl curr = this.next;
                        if (curr == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = curr.nextSibling;
                        return curr;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public TimerImpl startNestedTimer(TimerName timerName) {
        if (this.timerName == timerName) {
            ++this.selfNestingLevel;
            return this;
        }
        long nestedTimerStartTick = ticker.read();
        return this.startNestedTimerInternal(timerName, nestedTimerStartTick);
    }

    public TimerImpl startNestedTimer(TimerName timerName, long startTick) {
        if (this.timerName == timerName) {
            ++this.selfNestingLevel;
            return this;
        }
        return this.startNestedTimerInternal(timerName, startTick);
    }

    public TimerImpl extend() {
        TimerImpl currentTimer = this.transaction.getCurrentTimer();
        if (currentTimer == null) {
            logger.warn("extend() transaction currentTimer is null");
            return this;
        }
        if (currentTimer == this.parent) {
            --this.count;
            this.start(ticker.read());
            return this;
        }
        if (currentTimer == this) {
            ++this.selfNestingLevel;
            return this;
        }
        TimerNameImpl extendedTimer = this.timerName.extendedTimer();
        if (extendedTimer == null) {
            logger.warn("extend() should only be accessible to non-extended timers");
            return this;
        }
        return currentTimer.startNestedTimer(extendedTimer);
    }

    public TimerImpl extend(long startTick) {
        TimerImpl currentTimer = this.transaction.getCurrentTimer();
        if (currentTimer == null) {
            logger.warn("extend() transaction currentTimer is null");
            return this;
        }
        if (currentTimer == this.parent) {
            --this.count;
            this.start(startTick);
            return this;
        }
        if (currentTimer == this) {
            ++this.selfNestingLevel;
            return this;
        }
        TimerNameImpl extendedTimer = this.timerName.extendedTimer();
        if (extendedTimer == null) {
            logger.warn("extend() should only be accessible to non-extended timers");
            return this;
        }
        return currentTimer.startNestedTimer(extendedTimer);
    }

    void start(long startTick) {
        this.startTick = startTick;
        ++this.selfNestingLevel;
        this.transaction.setCurrentTimer(this);
    }

    Transaction getTransaction() {
        return this.transaction;
    }

    private void endInternal(long endTick) {
        this.total += endTick - this.startTick;
        ++this.count;
        this.transaction.setCurrentTimer(this.parent);
    }

    private TimerImpl startNestedTimerInternal(TimerName timerName, long nestedTimerStartTick) {
        TimerNameImpl timerNameImpl;
        TimerImpl nestedTimer;
        if (this.nestedTimers == null) {
            this.nestedTimers = new NestedTimerMap();
        }
        if ((nestedTimer = this.nestedTimers.get(timerNameImpl = (TimerNameImpl)timerName)) != null) {
            nestedTimer.start(nestedTimerStartTick);
            return nestedTimer;
        }
        nestedTimer = new TimerImpl(this.transaction, this, this.headChild, timerNameImpl);
        nestedTimer.start(nestedTimerStartTick);
        this.nestedTimers.put(timerNameImpl, nestedTimer);
        this.headChild = nestedTimer;
        return nestedTimer;
    }
}

