/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.common.Tickers;
import org.glowroot.plugin.api.transaction.MessageSupplier;
import org.glowroot.plugin.api.transaction.QueryEntry;
import org.glowroot.plugin.api.transaction.Timer;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.ErrorMessage;
import org.glowroot.transaction.ErrorMessageBase;
import org.glowroot.transaction.model.QueryData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.Transaction;

public class TraceEntryImpl
implements QueryEntry,
Timer {
    private static final Logger logger = LoggerFactory.getLogger(TraceEntryImpl.class);
    private static final Ticker ticker = Tickers.getTicker();
    @Nullable
    private final TraceEntryImpl parentTraceEntry;
    @Nullable
    private final MessageSupplier messageSupplier;
    @Nullable
    private ErrorMessage errorMessage;
    private final long startTick;
    private long revisedStartTick;
    private int selfNestingLevel;
    private long endTick;
    private final int nestingLevel;
    @Nullable
    private TraceEntryImpl nextTraceEntry;
    @Nullable
    private final TimerImpl timer;
    @Nullable
    private ImmutableList<StackTraceElement> stackTrace;
    private long stackTraceThreshold;
    @MonotonicNonNull
    private TimerImpl extendedTimer;
    @Nullable
    private final QueryData queryData;
    private long currRow = -1L;
    private long maxRow;

    TraceEntryImpl(@Nullable TraceEntryImpl parentTraceEntry, @Nullable MessageSupplier messageSupplier, @Nullable QueryData queryData, long queryExecutionCount, long startTick, int nestingLevel, @Nullable TimerImpl timer) {
        this.parentTraceEntry = parentTraceEntry;
        this.messageSupplier = messageSupplier;
        this.queryData = queryData;
        this.startTick = startTick;
        this.nestingLevel = nestingLevel;
        this.timer = timer;
        this.revisedStartTick = startTick;
        this.selfNestingLevel = 1;
        if (queryData != null) {
            queryData.start(startTick, queryExecutionCount);
        }
    }

    @Override
    @Nullable
    public MessageSupplier getMessageSupplier() {
        return this.messageSupplier;
    }

    @Nullable
    public ErrorMessage getErrorMessage() {
        return this.errorMessage;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public long getRevisedStartTick() {
        return this.revisedStartTick;
    }

    public boolean isCompleted() {
        return this.selfNestingLevel == 0;
    }

    public long getEndTick() {
        return this.endTick;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Nullable
    public ImmutableList<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public boolean isLimitExceededMarker() {
        return false;
    }

    public boolean isLimitExtendedMarker() {
        return false;
    }

    @Override
    public void end() {
        long endTick = ticker.read();
        this.endInternal(endTick, null);
    }

    @Override
    public void endWithStackTrace(long threshold, TimeUnit unit) {
        long thresholdNanos;
        if (threshold < 0L) {
            logger.error("endWithStackTrace(): argument 'threshold' must be non-negative");
            this.end();
            return;
        }
        long endTick = ticker.read();
        if (endTick - this.startTick >= (thresholdNanos = unit.toNanos(threshold))) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.stackTrace = ImmutableList.copyOf(stackTrace).subList(3, stackTrace.length);
        } else {
            this.stackTraceThreshold = thresholdNanos;
        }
        this.endInternal(endTick, null);
    }

    @Override
    public void endWithError(Throwable t) {
        this.endWithErrorInternal(ErrorMessageBase.from(t));
    }

    @Override
    public void endWithError(@Nullable String message) {
        this.endWithErrorInternal(ErrorMessageBase.from(message));
    }

    @Override
    public void endWithError(@Nullable String message, Throwable t) {
        this.endWithErrorInternal(ErrorMessageBase.from(message, t));
    }

    @Override
    public Timer extend() {
        Preconditions.checkNotNull(this.timer);
        if (this.selfNestingLevel++ == 0) {
            long priorDuration = this.endTick - this.revisedStartTick;
            long currTick = ticker.read();
            this.revisedStartTick = currTick - priorDuration;
            this.extendedTimer = this.timer.extend(currTick);
            if (this.queryData != null) {
                this.queryData.extend(currTick);
            }
        }
        return this;
    }

    @Override
    public void stop() {
        if (--this.selfNestingLevel == 0) {
            this.endTick = ticker.read();
            Preconditions.checkNotNull(this.extendedTimer);
            this.extendedTimer.end(this.endTick);
            if (this.queryData != null) {
                this.queryData.end(this.endTick);
            }
            if (this.stackTrace == null && this.stackTraceThreshold != 0L && this.endTick - this.revisedStartTick >= this.stackTraceThreshold) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                this.stackTrace = ImmutableList.copyOf(stackTrace).subList(3, stackTrace.length);
            }
        }
    }

    @Override
    public void incrementCurrRow() {
        if (this.currRow == -1L) {
            this.currRow = 1L;
            this.maxRow = 1L;
            if (this.queryData != null) {
                this.queryData.incrementRowCount(1L);
            }
        } else if (this.currRow == this.maxRow) {
            ++this.currRow;
            this.maxRow = this.currRow;
            if (this.queryData != null) {
                this.queryData.incrementRowCount(1L);
            }
        } else {
            ++this.currRow;
        }
    }

    @Override
    public void setCurrRow(long row) {
        if (row > this.maxRow) {
            if (this.queryData != null) {
                this.queryData.incrementRowCount(row - this.maxRow);
            }
            this.maxRow = row;
        }
        this.currRow = row;
    }

    public void setStackTrace(ImmutableList<StackTraceElement> stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean isQueryNavigationAttempted() {
        return this.currRow != -1L;
    }

    public long getRowCount() {
        return this.maxRow;
    }

    @Nullable
    TraceEntryImpl getParentTraceEntry() {
        return this.parentTraceEntry;
    }

    @Nullable
    TraceEntryImpl getNextTraceEntry() {
        return this.nextTraceEntry;
    }

    void setNextTraceEntry(TraceEntryImpl nextTraceEntry) {
        this.nextTraceEntry = nextTraceEntry;
    }

    void setErrorMessage(@Nullable ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    void setEndTick(long endTick) {
        this.endTick = endTick;
        --this.selfNestingLevel;
    }

    private void endWithErrorInternal(ErrorMessage errorMessage) {
        this.endInternal(ticker.read(), errorMessage);
        if (errorMessage.throwable() == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.setStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(stackTrace).subList(4, stackTrace.length));
        }
    }

    private void endInternal(long endTick, @Nullable ErrorMessage errorMessage) {
        Preconditions.checkNotNull(this.timer);
        Transaction transaction = this.timer.getTransaction();
        this.timer.end(endTick);
        if (this.queryData != null) {
            this.queryData.end(endTick);
        }
        this.setErrorMessage(errorMessage);
        this.setEndTick(endTick);
        transaction.popEntry(this, endTick);
    }

    static TraceEntryImpl getLimitExceededMarker() {
        return new LimitExceededTraceEntry();
    }

    static TraceEntryImpl getLimitExtendedMarker() {
        return new LimitExtendedTraceEntry();
    }

    private static class LimitExtendedTraceEntry
    extends TraceEntryImpl {
        private LimitExtendedTraceEntry() {
            super(null, null, null, 0L, 0L, 0, null);
        }

        @Override
        public boolean isLimitExtendedMarker() {
            return true;
        }
    }

    private static class LimitExceededTraceEntry
    extends TraceEntryImpl {
        private LimitExceededTraceEntry() {
            super(null, null, null, 0L, 0L, 0, null);
        }

        @Override
        public boolean isLimitExceededMarker() {
            return true;
        }
    }
}

