/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.plugin.api.weaving.Pointcut;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.objectweb.asm.commons.Method;
import org.glowroot.weaving.AdviceBase;
import org.glowroot.weaving.AdviceParameter;

@ParametersAreNonnullByDefault
@Immutable
public final class Advice
extends AdviceBase {
    private final Pointcut pointcut;
    private final Type adviceType;
    private final String pointcutDeclaringClassName;
    @Nullable
    private final String pointcutTargetClassName;
    @Nullable
    private final Pattern pointcutDeclaringClassNamePattern;
    @Nullable
    private final Pattern pointcutTargetClassNamePattern;
    @Nullable
    private final Pattern pointcutMethodNamePattern;
    @Nullable
    private final Type travelerType;
    @Nullable
    private final Method isEnabledAdvice;
    @Nullable
    private final Method onBeforeAdvice;
    @Nullable
    private final Method onReturnAdvice;
    @Nullable
    private final Method onThrowAdvice;
    @Nullable
    private final Method onAfterAdvice;
    private final ImmutableList<AdviceParameter> isEnabledParameters;
    private final ImmutableList<AdviceParameter> onBeforeParameters;
    private final ImmutableList<AdviceParameter> onReturnParameters;
    private final ImmutableList<AdviceParameter> onThrowParameters;
    private final ImmutableList<AdviceParameter> onAfterParameters;
    private final boolean reweavable;
    private final ImmutableSet<Type> classMetaTypes;
    private final ImmutableSet<Type> methodMetaTypes;

    private Advice(Pointcut pointcut, Type adviceType, String pointcutDeclaringClassName, @Nullable String pointcutTargetClassName, @Nullable Pattern pointcutDeclaringClassNamePattern, @Nullable Pattern pointcutTargetClassNamePattern, @Nullable Pattern pointcutMethodNamePattern, @Nullable Type travelerType, @Nullable Method isEnabledAdvice, @Nullable Method onBeforeAdvice, @Nullable Method onReturnAdvice, @Nullable Method onThrowAdvice, @Nullable Method onAfterAdvice, ImmutableList<AdviceParameter> isEnabledParameters, ImmutableList<AdviceParameter> onBeforeParameters, ImmutableList<AdviceParameter> onReturnParameters, ImmutableList<AdviceParameter> onThrowParameters, ImmutableList<AdviceParameter> onAfterParameters, boolean reweavable) {
        this.pointcut = pointcut;
        this.adviceType = adviceType;
        this.pointcutDeclaringClassName = pointcutDeclaringClassName;
        this.pointcutTargetClassName = pointcutTargetClassName;
        this.pointcutDeclaringClassNamePattern = pointcutDeclaringClassNamePattern;
        this.pointcutTargetClassNamePattern = pointcutTargetClassNamePattern;
        this.pointcutMethodNamePattern = pointcutMethodNamePattern;
        this.travelerType = travelerType;
        this.isEnabledAdvice = isEnabledAdvice;
        this.onBeforeAdvice = onBeforeAdvice;
        this.onReturnAdvice = onReturnAdvice;
        this.onThrowAdvice = onThrowAdvice;
        this.onAfterAdvice = onAfterAdvice;
        this.isEnabledParameters = isEnabledParameters;
        this.onBeforeParameters = onBeforeParameters;
        this.onReturnParameters = onReturnParameters;
        this.onThrowParameters = onThrowParameters;
        this.onAfterParameters = onAfterParameters;
        this.reweavable = reweavable;
        this.classMetaTypes = Preconditions.checkNotNull(super.classMetaTypes());
        this.methodMetaTypes = Preconditions.checkNotNull(super.methodMetaTypes());
    }

    @Override
    @JsonProperty(value="pointcut")
    public Pointcut pointcut() {
        return this.pointcut;
    }

    @Override
    @JsonProperty(value="adviceType")
    public Type adviceType() {
        return this.adviceType;
    }

    @Override
    @JsonProperty(value="pointcutDeclaringClassName")
    public String pointcutDeclaringClassName() {
        return this.pointcutDeclaringClassName;
    }

    @Override
    @JsonProperty(value="pointcutTargetClassName")
    public String pointcutTargetClassName() {
        return this.pointcutTargetClassName;
    }

    @Override
    @JsonProperty(value="pointcutDeclaringClassNamePattern")
    public Pattern pointcutDeclaringClassNamePattern() {
        return this.pointcutDeclaringClassNamePattern;
    }

    @Override
    @JsonProperty(value="pointcutTargetClassNamePattern")
    public Pattern pointcutTargetClassNamePattern() {
        return this.pointcutTargetClassNamePattern;
    }

    @Override
    @JsonProperty(value="pointcutMethodNamePattern")
    public Pattern pointcutMethodNamePattern() {
        return this.pointcutMethodNamePattern;
    }

    @Override
    @JsonProperty(value="travelerType")
    public Type travelerType() {
        return this.travelerType;
    }

    @Override
    @JsonProperty(value="isEnabledAdvice")
    public Method isEnabledAdvice() {
        return this.isEnabledAdvice;
    }

    @Override
    @JsonProperty(value="onBeforeAdvice")
    public Method onBeforeAdvice() {
        return this.onBeforeAdvice;
    }

    @Override
    @JsonProperty(value="onReturnAdvice")
    public Method onReturnAdvice() {
        return this.onReturnAdvice;
    }

    @Override
    @JsonProperty(value="onThrowAdvice")
    public Method onThrowAdvice() {
        return this.onThrowAdvice;
    }

    @Override
    @JsonProperty(value="onAfterAdvice")
    public Method onAfterAdvice() {
        return this.onAfterAdvice;
    }

    @Override
    @JsonProperty(value="isEnabledParameters")
    public ImmutableList<AdviceParameter> isEnabledParameters() {
        return this.isEnabledParameters;
    }

    @Override
    @JsonProperty(value="onBeforeParameters")
    public ImmutableList<AdviceParameter> onBeforeParameters() {
        return this.onBeforeParameters;
    }

    @Override
    @JsonProperty(value="onReturnParameters")
    public ImmutableList<AdviceParameter> onReturnParameters() {
        return this.onReturnParameters;
    }

    @Override
    @JsonProperty(value="onThrowParameters")
    public ImmutableList<AdviceParameter> onThrowParameters() {
        return this.onThrowParameters;
    }

    @Override
    @JsonProperty(value="onAfterParameters")
    public ImmutableList<AdviceParameter> onAfterParameters() {
        return this.onAfterParameters;
    }

    @Override
    @JsonProperty(value="reweavable")
    public boolean reweavable() {
        return this.reweavable;
    }

    @Override
    @JsonProperty(value="classMetaTypes")
    public ImmutableSet<Type> classMetaTypes() {
        return this.classMetaTypes;
    }

    @Override
    @JsonProperty(value="methodMetaTypes")
    public ImmutableSet<Type> methodMetaTypes() {
        return this.methodMetaTypes;
    }

    public final Advice withPointcut(Pointcut value) {
        if (this.pointcut == value) {
            return this;
        }
        Pointcut newValue = Preconditions.checkNotNull(value);
        return new Advice(newValue, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withAdviceType(Type value) {
        if (this.adviceType == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new Advice(this.pointcut, newValue, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutDeclaringClassName(String value) {
        if (this.pointcutDeclaringClassName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Advice(this.pointcut, this.adviceType, newValue, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutTargetClassName(@Nullable String value) {
        if (this.pointcutTargetClassName == value) {
            return this;
        }
        String newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, newValue, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutDeclaringClassNamePattern(@Nullable Pattern value) {
        if (this.pointcutDeclaringClassNamePattern == value) {
            return this;
        }
        Pattern newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, newValue, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutTargetClassNamePattern(@Nullable Pattern value) {
        if (this.pointcutTargetClassNamePattern == value) {
            return this;
        }
        Pattern newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, newValue, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withPointcutMethodNamePattern(@Nullable Pattern value) {
        if (this.pointcutMethodNamePattern == value) {
            return this;
        }
        Pattern newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, newValue, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withTravelerType(@Nullable Type value) {
        if (this.travelerType == value) {
            return this;
        }
        Type newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, newValue, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withIsEnabledAdvice(@Nullable Method value) {
        if (this.isEnabledAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, newValue, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnBeforeAdvice(@Nullable Method value) {
        if (this.onBeforeAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, newValue, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnReturnAdvice(@Nullable Method value) {
        if (this.onReturnAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, newValue, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnThrowAdvice(@Nullable Method value) {
        if (this.onThrowAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, newValue, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnAfterAdvice(@Nullable Method value) {
        if (this.onAfterAdvice == value) {
            return this;
        }
        Method newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, newValue, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withIsEnabledParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, newValue, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withIsEnabledParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.isEnabledParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, newValue, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnBeforeParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, newValue, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnBeforeParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onBeforeParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, newValue, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnReturnParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, newValue, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnReturnParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onReturnParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, newValue, this.onThrowParameters, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnThrowParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, newValue, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnThrowParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onThrowParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, newValue, this.onAfterParameters, this.reweavable);
    }

    public final Advice withOnAfterParameters(AdviceParameter ... elements) {
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, newValue, this.reweavable);
    }

    public final Advice withOnAfterParameters(Iterable<? extends AdviceParameter> elements) {
        if (this.onAfterParameters == elements) {
            return this;
        }
        ImmutableList<AdviceParameter> newValue = ImmutableList.copyOf(elements);
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, newValue, this.reweavable);
    }

    public final Advice withReweavable(boolean value) {
        if (this.reweavable == value) {
            return this;
        }
        boolean newValue = value;
        return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, this.isEnabledParameters, this.onBeforeParameters, this.onReturnParameters, this.onThrowParameters, this.onAfterParameters, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Advice && this.equalTo((Advice)another);
    }

    private boolean equalTo(Advice another) {
        return this.pointcut.equals(another.pointcut) && this.adviceType.equals(another.adviceType) && this.pointcutDeclaringClassName.equals(another.pointcutDeclaringClassName) && Objects.equal(this.pointcutTargetClassName, another.pointcutTargetClassName) && Objects.equal(this.pointcutDeclaringClassNamePattern, another.pointcutDeclaringClassNamePattern) && Objects.equal(this.pointcutTargetClassNamePattern, another.pointcutTargetClassNamePattern) && Objects.equal(this.pointcutMethodNamePattern, another.pointcutMethodNamePattern) && Objects.equal(this.travelerType, another.travelerType) && Objects.equal(this.isEnabledAdvice, another.isEnabledAdvice) && Objects.equal(this.onBeforeAdvice, another.onBeforeAdvice) && Objects.equal(this.onReturnAdvice, another.onReturnAdvice) && Objects.equal(this.onThrowAdvice, another.onThrowAdvice) && Objects.equal(this.onAfterAdvice, another.onAfterAdvice) && this.isEnabledParameters.equals(another.isEnabledParameters) && this.onBeforeParameters.equals(another.onBeforeParameters) && this.onReturnParameters.equals(another.onReturnParameters) && this.onThrowParameters.equals(another.onThrowParameters) && this.onAfterParameters.equals(another.onAfterParameters) && this.reweavable == another.reweavable && this.classMetaTypes.equals(another.classMetaTypes) && this.methodMetaTypes.equals(another.methodMetaTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pointcut.hashCode();
        h = h * 17 + this.adviceType.hashCode();
        h = h * 17 + this.pointcutDeclaringClassName.hashCode();
        h = h * 17 + Objects.hashCode(this.pointcutTargetClassName);
        h = h * 17 + Objects.hashCode(this.pointcutDeclaringClassNamePattern);
        h = h * 17 + Objects.hashCode(this.pointcutTargetClassNamePattern);
        h = h * 17 + Objects.hashCode(this.pointcutMethodNamePattern);
        h = h * 17 + Objects.hashCode(this.travelerType);
        h = h * 17 + Objects.hashCode(this.isEnabledAdvice);
        h = h * 17 + Objects.hashCode(this.onBeforeAdvice);
        h = h * 17 + Objects.hashCode(this.onReturnAdvice);
        h = h * 17 + Objects.hashCode(this.onThrowAdvice);
        h = h * 17 + Objects.hashCode(this.onAfterAdvice);
        h = h * 17 + this.isEnabledParameters.hashCode();
        h = h * 17 + this.onBeforeParameters.hashCode();
        h = h * 17 + this.onReturnParameters.hashCode();
        h = h * 17 + this.onThrowParameters.hashCode();
        h = h * 17 + this.onAfterParameters.hashCode();
        h = h * 17 + Booleans.hashCode(this.reweavable);
        h = h * 17 + this.classMetaTypes.hashCode();
        h = h * 17 + this.methodMetaTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Advice").add("pointcut", this.pointcut).add("adviceType", this.adviceType).add("pointcutDeclaringClassName", this.pointcutDeclaringClassName).add("pointcutTargetClassName", this.pointcutTargetClassName).add("pointcutDeclaringClassNamePattern", this.pointcutDeclaringClassNamePattern).add("pointcutTargetClassNamePattern", this.pointcutTargetClassNamePattern).add("pointcutMethodNamePattern", this.pointcutMethodNamePattern).add("travelerType", this.travelerType).add("isEnabledAdvice", this.isEnabledAdvice).add("onBeforeAdvice", this.onBeforeAdvice).add("onReturnAdvice", this.onReturnAdvice).add("onThrowAdvice", this.onThrowAdvice).add("onAfterAdvice", this.onAfterAdvice).add("isEnabledParameters", this.isEnabledParameters).add("onBeforeParameters", this.onBeforeParameters).add("onReturnParameters", this.onReturnParameters).add("onThrowParameters", this.onThrowParameters).add("onAfterParameters", this.onAfterParameters).add("reweavable", this.reweavable).add("classMetaTypes", this.classMetaTypes).add("methodMetaTypes", this.methodMetaTypes).toString();
    }

    @JsonCreator
    public static Advice fromAllAttributes(@JsonProperty(value="pointcut") @Nullable Pointcut pointcut, @JsonProperty(value="adviceType") @Nullable Type adviceType, @JsonProperty(value="pointcutDeclaringClassName") @Nullable String pointcutDeclaringClassName, @JsonProperty(value="pointcutTargetClassName") @Nullable String pointcutTargetClassName, @JsonProperty(value="pointcutDeclaringClassNamePattern") @Nullable Pattern pointcutDeclaringClassNamePattern, @JsonProperty(value="pointcutTargetClassNamePattern") @Nullable Pattern pointcutTargetClassNamePattern, @JsonProperty(value="pointcutMethodNamePattern") @Nullable Pattern pointcutMethodNamePattern, @JsonProperty(value="travelerType") @Nullable Type travelerType, @JsonProperty(value="isEnabledAdvice") @Nullable Method isEnabledAdvice, @JsonProperty(value="onBeforeAdvice") @Nullable Method onBeforeAdvice, @JsonProperty(value="onReturnAdvice") @Nullable Method onReturnAdvice, @JsonProperty(value="onThrowAdvice") @Nullable Method onThrowAdvice, @JsonProperty(value="onAfterAdvice") @Nullable Method onAfterAdvice, @JsonProperty(value="isEnabledParameters") @Nullable ImmutableList<AdviceParameter> isEnabledParameters, @JsonProperty(value="onBeforeParameters") @Nullable ImmutableList<AdviceParameter> onBeforeParameters, @JsonProperty(value="onReturnParameters") @Nullable ImmutableList<AdviceParameter> onReturnParameters, @JsonProperty(value="onThrowParameters") @Nullable ImmutableList<AdviceParameter> onThrowParameters, @JsonProperty(value="onAfterParameters") @Nullable ImmutableList<AdviceParameter> onAfterParameters, @JsonProperty(value="reweavable") @Nullable Boolean reweavable) {
        Builder builder = Advice.builder();
        if (pointcut != null) {
            builder.pointcut(pointcut);
        }
        if (adviceType != null) {
            builder.adviceType(adviceType);
        }
        if (pointcutDeclaringClassName != null) {
            builder.pointcutDeclaringClassName(pointcutDeclaringClassName);
        }
        if (pointcutTargetClassName != null) {
            builder.pointcutTargetClassName(pointcutTargetClassName);
        }
        if (pointcutDeclaringClassNamePattern != null) {
            builder.pointcutDeclaringClassNamePattern(pointcutDeclaringClassNamePattern);
        }
        if (pointcutTargetClassNamePattern != null) {
            builder.pointcutTargetClassNamePattern(pointcutTargetClassNamePattern);
        }
        if (pointcutMethodNamePattern != null) {
            builder.pointcutMethodNamePattern(pointcutMethodNamePattern);
        }
        if (travelerType != null) {
            builder.travelerType(travelerType);
        }
        if (isEnabledAdvice != null) {
            builder.isEnabledAdvice(isEnabledAdvice);
        }
        if (onBeforeAdvice != null) {
            builder.onBeforeAdvice(onBeforeAdvice);
        }
        if (onReturnAdvice != null) {
            builder.onReturnAdvice(onReturnAdvice);
        }
        if (onThrowAdvice != null) {
            builder.onThrowAdvice(onThrowAdvice);
        }
        if (onAfterAdvice != null) {
            builder.onAfterAdvice(onAfterAdvice);
        }
        if (isEnabledParameters != null) {
            builder.addAllIsEnabledParameters(isEnabledParameters);
        }
        if (onBeforeParameters != null) {
            builder.addAllOnBeforeParameters(onBeforeParameters);
        }
        if (onReturnParameters != null) {
            builder.addAllOnReturnParameters(onReturnParameters);
        }
        if (onThrowParameters != null) {
            builder.addAllOnThrowParameters(onThrowParameters);
        }
        if (onAfterParameters != null) {
            builder.addAllOnAfterParameters(onAfterParameters);
        }
        if (reweavable != null) {
            builder.reweavable(reweavable);
        }
        return builder.build();
    }

    public static Advice copyOf(AdviceBase instance) {
        if (instance instanceof Advice) {
            return (Advice)instance;
        }
        return Advice.builder().pointcut(instance.pointcut()).adviceType(instance.adviceType()).pointcutDeclaringClassName(instance.pointcutDeclaringClassName()).pointcutTargetClassName(instance.pointcutTargetClassName()).pointcutDeclaringClassNamePattern(instance.pointcutDeclaringClassNamePattern()).pointcutTargetClassNamePattern(instance.pointcutTargetClassNamePattern()).pointcutMethodNamePattern(instance.pointcutMethodNamePattern()).travelerType(instance.travelerType()).isEnabledAdvice(instance.isEnabledAdvice()).onBeforeAdvice(instance.onBeforeAdvice()).onReturnAdvice(instance.onReturnAdvice()).onThrowAdvice(instance.onThrowAdvice()).onAfterAdvice(instance.onAfterAdvice()).addAllIsEnabledParameters(instance.isEnabledParameters()).addAllOnBeforeParameters(instance.onBeforeParameters()).addAllOnReturnParameters(instance.onReturnParameters()).addAllOnThrowParameters(instance.onThrowParameters()).addAllOnAfterParameters(instance.onAfterParameters()).reweavable(instance.reweavable()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_POINTCUT = 1L;
        private static final long INITIALIZED_BIT_ADVICE_TYPE = 2L;
        private static final long INITIALIZED_BIT_POINTCUT_DECLARING_CLASS_NAME = 4L;
        private static final long INITIALIZED_BIT_REWEAVABLE = 8L;
        private static final long NONDEFAULT_BIT_POINTCUT_TARGET_CLASS_NAME = 1L;
        private static final long NONDEFAULT_BIT_POINTCUT_DECLARING_CLASS_NAME_PATTERN = 2L;
        private static final long NONDEFAULT_BIT_POINTCUT_TARGET_CLASS_NAME_PATTERN = 4L;
        private static final long NONDEFAULT_BIT_POINTCUT_METHOD_NAME_PATTERN = 8L;
        private static final long NONDEFAULT_BIT_TRAVELER_TYPE = 16L;
        private static final long NONDEFAULT_BIT_IS_ENABLED_ADVICE = 32L;
        private static final long NONDEFAULT_BIT_ON_BEFORE_ADVICE = 64L;
        private static final long NONDEFAULT_BIT_ON_RETURN_ADVICE = 128L;
        private static final long NONDEFAULT_BIT_ON_THROW_ADVICE = 256L;
        private static final long NONDEFAULT_BIT_ON_AFTER_ADVICE = 512L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private Pointcut pointcut;
        @Nullable
        private Type adviceType;
        @Nullable
        private String pointcutDeclaringClassName;
        @Nullable
        private String pointcutTargetClassName;
        @Nullable
        private Pattern pointcutDeclaringClassNamePattern;
        @Nullable
        private Pattern pointcutTargetClassNamePattern;
        @Nullable
        private Pattern pointcutMethodNamePattern;
        @Nullable
        private Type travelerType;
        @Nullable
        private Method isEnabledAdvice;
        @Nullable
        private Method onBeforeAdvice;
        @Nullable
        private Method onReturnAdvice;
        @Nullable
        private Method onThrowAdvice;
        @Nullable
        private Method onAfterAdvice;
        private ImmutableList.Builder<AdviceParameter> isEnabledParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onBeforeParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onReturnParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onThrowParametersBuilder = ImmutableList.builder();
        private ImmutableList.Builder<AdviceParameter> onAfterParametersBuilder = ImmutableList.builder();
        private boolean reweavable;

        private Builder() {
        }

        public final Builder pointcut(Pointcut pointcut) {
            this.checkNotIsSet(this.pointcutIsSet(), "pointcut");
            this.pointcut = Preconditions.checkNotNull(pointcut);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder adviceType(Type adviceType) {
            this.checkNotIsSet(this.adviceTypeIsSet(), "adviceType");
            this.adviceType = Preconditions.checkNotNull(adviceType);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder pointcutDeclaringClassName(String pointcutDeclaringClassName) {
            this.checkNotIsSet(this.pointcutDeclaringClassNameIsSet(), "pointcutDeclaringClassName");
            this.pointcutDeclaringClassName = Preconditions.checkNotNull(pointcutDeclaringClassName);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder pointcutTargetClassName(@Nullable String pointcutTargetClassName) {
            this.checkNotIsSet(this.pointcutTargetClassNameIsSet(), "pointcutTargetClassName");
            this.pointcutTargetClassName = pointcutTargetClassName;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder pointcutDeclaringClassNamePattern(@Nullable Pattern pointcutDeclaringClassNamePattern) {
            this.checkNotIsSet(this.pointcutDeclaringClassNamePatternIsSet(), "pointcutDeclaringClassNamePattern");
            this.pointcutDeclaringClassNamePattern = pointcutDeclaringClassNamePattern;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder pointcutTargetClassNamePattern(@Nullable Pattern pointcutTargetClassNamePattern) {
            this.checkNotIsSet(this.pointcutTargetClassNamePatternIsSet(), "pointcutTargetClassNamePattern");
            this.pointcutTargetClassNamePattern = pointcutTargetClassNamePattern;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder pointcutMethodNamePattern(@Nullable Pattern pointcutMethodNamePattern) {
            this.checkNotIsSet(this.pointcutMethodNamePatternIsSet(), "pointcutMethodNamePattern");
            this.pointcutMethodNamePattern = pointcutMethodNamePattern;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder travelerType(@Nullable Type travelerType) {
            this.checkNotIsSet(this.travelerTypeIsSet(), "travelerType");
            this.travelerType = travelerType;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public final Builder isEnabledAdvice(@Nullable Method isEnabledAdvice) {
            this.checkNotIsSet(this.isEnabledAdviceIsSet(), "isEnabledAdvice");
            this.isEnabledAdvice = isEnabledAdvice;
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder onBeforeAdvice(@Nullable Method onBeforeAdvice) {
            this.checkNotIsSet(this.onBeforeAdviceIsSet(), "onBeforeAdvice");
            this.onBeforeAdvice = onBeforeAdvice;
            this.nondefaultBitset |= 0x40L;
            return this;
        }

        public final Builder onReturnAdvice(@Nullable Method onReturnAdvice) {
            this.checkNotIsSet(this.onReturnAdviceIsSet(), "onReturnAdvice");
            this.onReturnAdvice = onReturnAdvice;
            this.nondefaultBitset |= 0x80L;
            return this;
        }

        public final Builder onThrowAdvice(@Nullable Method onThrowAdvice) {
            this.checkNotIsSet(this.onThrowAdviceIsSet(), "onThrowAdvice");
            this.onThrowAdvice = onThrowAdvice;
            this.nondefaultBitset |= 0x100L;
            return this;
        }

        public final Builder onAfterAdvice(@Nullable Method onAfterAdvice) {
            this.checkNotIsSet(this.onAfterAdviceIsSet(), "onAfterAdvice");
            this.onAfterAdvice = onAfterAdvice;
            this.nondefaultBitset |= 0x200L;
            return this;
        }

        public final Builder addIsEnabledParameters(AdviceParameter element) {
            this.isEnabledParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addIsEnabledParameters(AdviceParameter ... elements) {
            this.isEnabledParametersBuilder.add(elements);
            return this;
        }

        public final Builder addAllIsEnabledParameters(Iterable<? extends AdviceParameter> elements) {
            this.isEnabledParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnBeforeParameters(AdviceParameter element) {
            this.onBeforeParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnBeforeParameters(AdviceParameter ... elements) {
            this.onBeforeParametersBuilder.add(elements);
            return this;
        }

        public final Builder addAllOnBeforeParameters(Iterable<? extends AdviceParameter> elements) {
            this.onBeforeParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnReturnParameters(AdviceParameter element) {
            this.onReturnParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnReturnParameters(AdviceParameter ... elements) {
            this.onReturnParametersBuilder.add(elements);
            return this;
        }

        public final Builder addAllOnReturnParameters(Iterable<? extends AdviceParameter> elements) {
            this.onReturnParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnThrowParameters(AdviceParameter element) {
            this.onThrowParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnThrowParameters(AdviceParameter ... elements) {
            this.onThrowParametersBuilder.add(elements);
            return this;
        }

        public final Builder addAllOnThrowParameters(Iterable<? extends AdviceParameter> elements) {
            this.onThrowParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder addOnAfterParameters(AdviceParameter element) {
            this.onAfterParametersBuilder.add((Object)element);
            return this;
        }

        public final Builder addOnAfterParameters(AdviceParameter ... elements) {
            this.onAfterParametersBuilder.add(elements);
            return this;
        }

        public final Builder addAllOnAfterParameters(Iterable<? extends AdviceParameter> elements) {
            this.onAfterParametersBuilder.addAll(elements);
            return this;
        }

        public final Builder reweavable(boolean reweavable) {
            this.checkNotIsSet(this.reweavableIsSet(), "reweavable");
            this.reweavable = reweavable;
            this.initializedBitset |= 8L;
            return this;
        }

        public Advice build() {
            this.checkRequiredAttributes();
            return new Advice(this.pointcut, this.adviceType, this.pointcutDeclaringClassName, this.pointcutTargetClassName, this.pointcutDeclaringClassNamePattern, this.pointcutTargetClassNamePattern, this.pointcutMethodNamePattern, this.travelerType, this.isEnabledAdvice, this.onBeforeAdvice, this.onReturnAdvice, this.onThrowAdvice, this.onAfterAdvice, (ImmutableList)this.isEnabledParametersBuilder.build(), (ImmutableList)this.onBeforeParametersBuilder.build(), (ImmutableList)this.onReturnParametersBuilder.build(), (ImmutableList)this.onThrowParametersBuilder.build(), (ImmutableList)this.onAfterParametersBuilder.build(), this.reweavable);
        }

        private boolean pointcutTargetClassNameIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean pointcutDeclaringClassNamePatternIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean pointcutTargetClassNamePatternIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean pointcutMethodNamePatternIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean travelerTypeIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private boolean isEnabledAdviceIsSet() {
            return (this.nondefaultBitset & 0x20L) != 0L;
        }

        private boolean onBeforeAdviceIsSet() {
            return (this.nondefaultBitset & 0x40L) != 0L;
        }

        private boolean onReturnAdviceIsSet() {
            return (this.nondefaultBitset & 0x80L) != 0L;
        }

        private boolean onThrowAdviceIsSet() {
            return (this.nondefaultBitset & 0x100L) != 0L;
        }

        private boolean onAfterAdviceIsSet() {
            return (this.nondefaultBitset & 0x200L) != 0L;
        }

        private boolean pointcutIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean adviceTypeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean pointcutDeclaringClassNameIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean reweavableIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Advice is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.pointcutIsSet()) {
                attributes.add("pointcut");
            }
            if (!this.adviceTypeIsSet()) {
                attributes.add("adviceType");
            }
            if (!this.pointcutDeclaringClassNameIsSet()) {
                attributes.add("pointcutDeclaringClassName");
            }
            if (!this.reweavableIsSet()) {
                attributes.add("reweavable");
            }
            return "Cannot build Advice, some of required attributes are not set " + attributes;
        }
    }
}

