/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.plugin.api.weaving.Pointcut;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.primitives.Ints;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.objectweb.asm.commons.Method;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceParameter;
import org.glowroot.weaving.ParameterKind;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AdviceBase {
    static final Ordering<Advice> ordering = new AdviceOrdering();

    abstract Pointcut pointcut();

    abstract Type adviceType();

    abstract String pointcutDeclaringClassName();

    @Nullable
    abstract String pointcutTargetClassName();

    @Nullable
    abstract Pattern pointcutDeclaringClassNamePattern();

    @Nullable
    abstract Pattern pointcutTargetClassNamePattern();

    @Nullable
    abstract Pattern pointcutMethodNamePattern();

    @Nullable
    abstract Type travelerType();

    @Nullable
    abstract Method isEnabledAdvice();

    @Nullable
    abstract Method onBeforeAdvice();

    @Nullable
    abstract Method onReturnAdvice();

    @Nullable
    abstract Method onThrowAdvice();

    @Nullable
    abstract Method onAfterAdvice();

    abstract ImmutableList<AdviceParameter> isEnabledParameters();

    abstract ImmutableList<AdviceParameter> onBeforeParameters();

    abstract ImmutableList<AdviceParameter> onReturnParameters();

    abstract ImmutableList<AdviceParameter> onThrowParameters();

    abstract ImmutableList<AdviceParameter> onAfterParameters();

    abstract boolean reweavable();

    ImmutableSet<Type> classMetaTypes() {
        HashSet<Type> metaTypes = Sets.newHashSet();
        metaTypes.addAll(AdviceBase.getClassMetaTypes(this.isEnabledParameters()));
        metaTypes.addAll(AdviceBase.getClassMetaTypes(this.onBeforeParameters()));
        metaTypes.addAll(AdviceBase.getClassMetaTypes(this.onReturnParameters()));
        metaTypes.addAll(AdviceBase.getClassMetaTypes(this.onThrowParameters()));
        metaTypes.addAll(AdviceBase.getClassMetaTypes(this.onAfterParameters()));
        return ImmutableSet.copyOf(metaTypes);
    }

    ImmutableSet<Type> methodMetaTypes() {
        HashSet<Type> metaTypes = Sets.newHashSet();
        metaTypes.addAll(AdviceBase.getMethodMetaTypes(this.isEnabledParameters()));
        metaTypes.addAll(AdviceBase.getMethodMetaTypes(this.onBeforeParameters()));
        metaTypes.addAll(AdviceBase.getMethodMetaTypes(this.onReturnParameters()));
        metaTypes.addAll(AdviceBase.getMethodMetaTypes(this.onThrowParameters()));
        metaTypes.addAll(AdviceBase.getMethodMetaTypes(this.onAfterParameters()));
        return ImmutableSet.copyOf(metaTypes);
    }

    private static Set<Type> getClassMetaTypes(List<AdviceParameter> parameters) {
        HashSet<Type> types = Sets.newHashSet();
        for (AdviceParameter parameter : parameters) {
            if (parameter.kind() != ParameterKind.CLASS_META) continue;
            types.add(parameter.type());
        }
        return types;
    }

    private static Set<Type> getMethodMetaTypes(List<AdviceParameter> parameters) {
        HashSet<Type> types = Sets.newHashSet();
        for (AdviceParameter parameter : parameters) {
            if (parameter.kind() != ParameterKind.METHOD_META) continue;
            types.add(parameter.type());
        }
        return types;
    }

    @Value.Immutable
    static abstract class AdviceParameterBase {
        AdviceParameterBase() {
        }

        abstract ParameterKind kind();

        abstract Type type();
    }

    private static final class AdviceOrdering
    extends Ordering<Advice> {
        private AdviceOrdering() {
        }

        @Override
        public int compare(@Nullable Advice left, @Nullable Advice right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            int compare = Ints.compare(left.pointcut().priority(), right.pointcut().priority());
            if (compare != 0) {
                return compare;
            }
            String leftTimerName = left.pointcut().timerName();
            String rightTimerName = right.pointcut().timerName();
            if (leftTimerName.isEmpty() && rightTimerName.isEmpty()) {
                return 0;
            }
            if (leftTimerName.isEmpty()) {
                return 1;
            }
            if (rightTimerName.isEmpty()) {
                return -1;
            }
            return leftTimerName.compareToIgnoreCase(rightTimerName);
        }
    }
}

