/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.glowroot.plugin.api.weaving.BindClassMeta;
import org.glowroot.plugin.api.weaving.BindMethodMeta;
import org.glowroot.plugin.api.weaving.BindMethodName;
import org.glowroot.plugin.api.weaving.BindOptionalReturn;
import org.glowroot.plugin.api.weaving.BindParameter;
import org.glowroot.plugin.api.weaving.BindParameterArray;
import org.glowroot.plugin.api.weaving.BindReceiver;
import org.glowroot.plugin.api.weaving.BindReturn;
import org.glowroot.plugin.api.weaving.BindThrowable;
import org.glowroot.plugin.api.weaving.BindTraveler;
import org.glowroot.plugin.api.weaving.IsEnabled;
import org.glowroot.plugin.api.weaving.OnAfter;
import org.glowroot.plugin.api.weaving.OnBefore;
import org.glowroot.plugin.api.weaving.OnReturn;
import org.glowroot.plugin.api.weaving.OnThrow;
import org.glowroot.plugin.api.weaving.Pointcut;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceParameter;
import org.glowroot.weaving.ClassLoaders;
import org.glowroot.weaving.LazyDefinedClass;
import org.glowroot.weaving.ParameterKind;

public class AdviceBuilder {
    private static final ImmutableList<Class<? extends Annotation>> isEnabledBindAnnotationTypes = ImmutableList.of(BindReceiver.class, BindParameter.class, BindParameterArray.class, BindMethodName.class, BindClassMeta.class, BindMethodMeta.class);
    private static final ImmutableList<Class<? extends Annotation>> onBeforeBindAnnotationTypes = ImmutableList.of(BindReceiver.class, BindParameter.class, BindParameterArray.class, BindMethodName.class, BindClassMeta.class, BindMethodMeta.class);
    private static final ImmutableList<Class<? extends Annotation>> onReturnBindAnnotationTypes = ImmutableList.of(BindReceiver.class, BindParameter.class, BindParameterArray.class, BindMethodName.class, BindReturn.class, BindOptionalReturn.class, BindTraveler.class, BindClassMeta.class, BindMethodMeta.class);
    private static final ImmutableList<Class<? extends Annotation>> onThrowBindAnnotationTypes = ImmutableList.of(BindReceiver.class, BindParameter.class, BindParameterArray.class, BindMethodName.class, BindThrowable.class, BindTraveler.class, BindClassMeta.class, BindMethodMeta.class);
    private static final ImmutableList<Class<? extends Annotation>> onAfterBindAnnotationTypes = ImmutableList.of(BindReceiver.class, BindParameter.class, BindParameterArray.class, BindMethodName.class, BindTraveler.class, BindClassMeta.class, BindMethodMeta.class);
    private static final ImmutableMap<Class<? extends Annotation>, ParameterKind> parameterKindMap = new ImmutableMap.Builder<Class<BindReceiver>, ParameterKind>().put(BindReceiver.class, ParameterKind.RECEIVER).put(BindParameter.class, ParameterKind.METHOD_ARG).put(BindParameterArray.class, ParameterKind.METHOD_ARG_ARRAY).put(BindMethodName.class, ParameterKind.METHOD_NAME).put(BindReturn.class, ParameterKind.RETURN).put(BindOptionalReturn.class, ParameterKind.OPTIONAL_RETURN).put(BindThrowable.class, ParameterKind.THROWABLE).put(BindTraveler.class, ParameterKind.TRAVELER).put(BindClassMeta.class, ParameterKind.CLASS_META).put(BindMethodMeta.class, ParameterKind.METHOD_META).build();
    private final Advice.Builder builder = Advice.builder();
    @Nullable
    private final Class<?> adviceClass;
    @Nullable
    private final LazyDefinedClass lazyAdviceClass;
    private boolean hasIsEnabledAdvice;
    private boolean hasOnBeforeAdvice;
    private boolean hasOnReturnAdvice;
    private boolean hasOnThrowAdvice;
    private boolean hasOnAfterAdvice;

    public AdviceBuilder(Class<?> adviceClass, boolean reweavable) {
        this.adviceClass = adviceClass;
        this.lazyAdviceClass = null;
        this.builder.reweavable(reweavable);
    }

    public AdviceBuilder(LazyDefinedClass lazyAdviceClass, boolean reweavable) {
        this.adviceClass = null;
        this.lazyAdviceClass = lazyAdviceClass;
        this.builder.reweavable(reweavable);
    }

    public Advice build() throws Exception {
        Pointcut pointcut;
        Class<?> adviceClass = this.adviceClass;
        if (adviceClass == null) {
            Preconditions.checkNotNull(this.lazyAdviceClass);
            ClassLoader tempClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new URLClassLoader(new URL[0]);
                }
            });
            adviceClass = ClassLoaders.defineClass(this.lazyAdviceClass, tempClassLoader);
        }
        AdviceBuilder.checkState((pointcut = adviceClass.getAnnotation(Pointcut.class)) != null, "Class has no @Pointcut annotation");
        Preconditions.checkNotNull(pointcut);
        this.builder.pointcut(pointcut);
        this.builder.adviceType(Type.getType(adviceClass));
        if (pointcut.declaringClassName().equals("")) {
            this.builder.pointcutDeclaringClassName(pointcut.className());
            this.builder.pointcutDeclaringClassNamePattern(AdviceBuilder.buildPattern(pointcut.className()));
            this.builder.pointcutTargetClassName(null);
            this.builder.pointcutTargetClassNamePattern(null);
        } else {
            this.builder.pointcutDeclaringClassName(pointcut.declaringClassName());
            this.builder.pointcutDeclaringClassNamePattern(AdviceBuilder.buildPattern(pointcut.declaringClassName()));
            this.builder.pointcutTargetClassName(pointcut.className());
            this.builder.pointcutTargetClassNamePattern(AdviceBuilder.buildPattern(pointcut.className()));
        }
        this.builder.pointcutMethodNamePattern(AdviceBuilder.buildPattern(pointcut.methodName()));
        for (Method method : adviceClass.getMethods()) {
            if (method.isAnnotationPresent(IsEnabled.class)) {
                this.initIsEnabledAdvice(adviceClass, method);
                continue;
            }
            if (method.isAnnotationPresent(OnBefore.class)) {
                this.initOnBeforeAdvice(adviceClass, method);
                continue;
            }
            if (method.isAnnotationPresent(OnReturn.class)) {
                this.initOnReturnAdvice(adviceClass, method);
                continue;
            }
            if (method.isAnnotationPresent(OnThrow.class)) {
                this.initOnThrowAdvice(adviceClass, method);
                continue;
            }
            if (!method.isAnnotationPresent(OnAfter.class)) continue;
            this.initOnAfterAdvice(adviceClass, method);
        }
        return this.builder.build();
    }

    private void initIsEnabledAdvice(Class<?> adviceClass, Method method) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasIsEnabledAdvice, "@Pointcut '" + adviceClass.getName() + "' has more than one @IsEnabled method");
        org.glowroot.shaded.objectweb.asm.commons.Method asmMethod = org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(method);
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 1, "@IsEnabled method must return boolean");
        this.builder.isEnabledAdvice(asmMethod);
        List<AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(method.getParameterAnnotations(), method.getParameterTypes(), isEnabledBindAnnotationTypes, IsEnabled.class);
        this.builder.addAllIsEnabledParameters(parameters);
        this.hasIsEnabledAdvice = true;
    }

    private void initOnBeforeAdvice(Class<?> adviceClass, Method method) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnBeforeAdvice, "@Pointcut '" + adviceClass.getName() + "' has more than one @OnBefore method");
        org.glowroot.shaded.objectweb.asm.commons.Method onBeforeAdvice = org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(method);
        this.builder.onBeforeAdvice(onBeforeAdvice);
        List<AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(method.getParameterAnnotations(), method.getParameterTypes(), onBeforeBindAnnotationTypes, OnBefore.class);
        this.builder.addAllOnBeforeParameters(parameters);
        if (onBeforeAdvice.getReturnType().getSort() != 0) {
            this.builder.travelerType(onBeforeAdvice.getReturnType());
        }
        this.hasOnBeforeAdvice = true;
    }

    private void initOnReturnAdvice(Class<?> adviceClass, Method method) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnReturnAdvice, "@Pointcut '" + adviceClass.getName() + "' has more than one @OnReturn method");
        List<AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(method.getParameterAnnotations(), method.getParameterTypes(), onReturnBindAnnotationTypes, OnReturn.class);
        for (int i = 1; i < parameters.size(); ++i) {
            AdviceBuilder.checkState(parameters.get(i).kind() != ParameterKind.RETURN, "@BindReturn must be the first argument to @OnReturn");
            AdviceBuilder.checkState(parameters.get(i).kind() != ParameterKind.OPTIONAL_RETURN, "@BindOptionalReturn must be the first argument to @OnReturn");
        }
        this.builder.onReturnAdvice(org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(method));
        this.builder.addAllOnReturnParameters(parameters);
        this.hasOnReturnAdvice = true;
    }

    private void initOnThrowAdvice(Class<?> adviceClass, Method method) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnThrowAdvice, "@Pointcut '" + adviceClass.getName() + "' has more than one @OnThrow method");
        List<AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(method.getParameterAnnotations(), method.getParameterTypes(), onThrowBindAnnotationTypes, OnThrow.class);
        for (int i = 1; i < parameters.size(); ++i) {
            AdviceBuilder.checkState(parameters.get(i).kind() != ParameterKind.THROWABLE, "@BindThrowable must be the first argument to @OnThrow");
        }
        org.glowroot.shaded.objectweb.asm.commons.Method asmMethod = org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(method);
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 0, "@OnThrow method must return void (for now)");
        this.builder.onThrowAdvice(asmMethod);
        this.builder.addAllOnThrowParameters(parameters);
        this.hasOnThrowAdvice = true;
    }

    private void initOnAfterAdvice(Class<?> adviceClass, Method method) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnAfterAdvice, "@Pointcut '" + adviceClass.getName() + "' has more than one @OnAfter method");
        org.glowroot.shaded.objectweb.asm.commons.Method asmMethod = org.glowroot.shaded.objectweb.asm.commons.Method.getMethod(method);
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 0, "@OnAfter method must return void");
        this.builder.onAfterAdvice(asmMethod);
        List<AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(method.getParameterAnnotations(), method.getParameterTypes(), onAfterBindAnnotationTypes, OnAfter.class);
        this.builder.addAllOnAfterParameters(parameters);
        this.hasOnAfterAdvice = true;
    }

    private static void checkState(boolean condition, String message) throws AdviceConstructionException {
        if (!condition) {
            throw new AdviceConstructionException(message);
        }
    }

    @Nullable
    private static Pattern buildPattern(String maybePattern) {
        if (maybePattern.startsWith("/") && maybePattern.endsWith("/")) {
            return Pattern.compile(maybePattern.substring(1, maybePattern.length() - 1));
        }
        if (maybePattern.contains("|")) {
            Object[] parts = maybePattern.split("\\|");
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = AdviceBuilder.buildSimplePattern((String)parts[i]);
            }
            return Pattern.compile(Joiner.on('|').join(parts));
        }
        if (maybePattern.contains("*")) {
            return Pattern.compile(AdviceBuilder.buildSimplePattern(maybePattern));
        }
        return null;
    }

    public static String buildSimplePattern(String part) {
        String pattern = "\\Q" + part.replace("*", "\\E.*\\Q") + "\\E";
        return pattern.replace("\\Q\\E", "");
    }

    private static List<AdviceParameter> getAdviceParameters(Annotation[][] parameterAnnotations, Class<?>[] parameterTypes, ImmutableList<Class<? extends Annotation>> validBindAnnotationTypes, Class<? extends Annotation> adviceAnnotationType) throws AdviceConstructionException {
        ArrayList<AdviceParameter> parameters = Lists.newArrayList();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Class<? extends Annotation> validBindAnnotationType = AdviceBuilder.getValidBindAnnotationType(parameterAnnotations[i], validBindAnnotationTypes);
            if (validBindAnnotationType == null) {
                ArrayList<String> validBindAnnotationNames = Lists.newArrayList();
                for (Class clazz : validBindAnnotationTypes) {
                    validBindAnnotationNames.add("@" + clazz.getSimpleName());
                }
                throw new AdviceConstructionException("All parameters to @" + adviceAnnotationType.getSimpleName() + " must be annotated with one" + " of " + Joiner.on(", ").join(validBindAnnotationNames));
            }
            parameters.add(AdviceBuilder.getAdviceParameter(validBindAnnotationType, parameterTypes[i]));
        }
        return parameters;
    }

    @Nullable
    private static Class<? extends Annotation> getValidBindAnnotationType(Annotation[] parameterAnnotations, ImmutableList<Class<? extends Annotation>> validBindAnnotationTypes) throws AdviceConstructionException {
        Class<? extends Annotation> foundBindAnnotationType = null;
        for (Annotation annotation : parameterAnnotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!parameterKindMap.containsKey(annotationType)) continue;
            AdviceBuilder.checkState(foundBindAnnotationType == null, "Multiple annotations found on a single parameter");
            AdviceBuilder.checkState(validBindAnnotationTypes.contains(annotationType), "Annotation '" + annotationType.getName() + "' found in an invalid location");
            foundBindAnnotationType = annotationType;
        }
        return foundBindAnnotationType;
    }

    private static AdviceParameter getAdviceParameter(Class<? extends Annotation> validBindAnnotationType, Class<?> parameterType) throws AdviceConstructionException {
        AdviceBuilder.checkState(validBindAnnotationType != BindMethodName.class || parameterType.isAssignableFrom(String.class), "@BindMethodName parameter type must be java.lang.String (or super type of java.lang.String)");
        AdviceBuilder.checkState(validBindAnnotationType != BindThrowable.class || parameterType.isAssignableFrom(Throwable.class), "@BindMethodName parameter type must be java.lang.Throwable (or super type of java.lang.Throwable)");
        ParameterKind parameterKind = parameterKindMap.get(validBindAnnotationType);
        Preconditions.checkNotNull(parameterKind, "Annotation not found in parameterKindMap: " + validBindAnnotationType.getName());
        return AdviceParameter.builder().kind(parameterKind).type(Type.getType(parameterType)).build();
    }

    private static class AdviceConstructionException
    extends Exception {
        private AdviceConstructionException(@Nullable String message) {
            super(message);
        }
    }
}

