/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.glowroot.common.Styles;
import org.glowroot.plugin.api.weaving.MethodModifier;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceMatcher;
import org.immutables.value.Value;

@Value.Immutable
@Styles.AllParameters
abstract class AdviceMatcherBase {
    private static final Logger logger = LoggerFactory.getLogger(AdviceMatcher.class);

    AdviceMatcherBase() {
    }

    static ImmutableList<AdviceMatcher> getAdviceMatchers(String className, List<Advice> advisors) {
        ArrayList<AdviceMatcher> adviceMatchers = Lists.newArrayList();
        for (Advice advice : advisors) {
            if (!AdviceMatcherBase.isDeclaringClassNameMatch(className, advice)) continue;
            adviceMatchers.add(AdviceMatcher.of(advice));
        }
        return ImmutableList.copyOf(adviceMatchers);
    }

    abstract Advice advice();

    boolean isMethodLevelMatch(String methodName, List<Type> parameterTypes, Type returnType, int modifiers) {
        if (!this.isMethodNameMatch(methodName) || !this.isMethodParameterTypesMatch(parameterTypes)) {
            return false;
        }
        return this.isMethodReturnMatch(returnType) && this.isMethodModifiersMatch(modifiers);
    }

    private boolean isMethodNameMatch(String methodName) {
        if (methodName.equals("<clinit>")) {
            return false;
        }
        if (methodName.equals("<init>")) {
            return this.advice().pointcut().methodName().equals("<init>");
        }
        Pattern pointcutMethodNamePattern = this.advice().pointcutMethodNamePattern();
        if (pointcutMethodNamePattern == null) {
            return this.advice().pointcut().methodName().equals(methodName);
        }
        return pointcutMethodNamePattern.matcher(methodName).matches();
    }

    private boolean isMethodParameterTypesMatch(List<Type> parameterTypes) {
        String[] pointcutMethodParameterTypes = this.advice().pointcut().methodParameterTypes();
        for (int i = 0; i < pointcutMethodParameterTypes.length; ++i) {
            String pointcutMethodParameterType = pointcutMethodParameterTypes[i];
            if (pointcutMethodParameterType.equals("..")) {
                if (i != pointcutMethodParameterTypes.length - 1) {
                    logger.warn("'..' can only be used at the end of methodParameterTypes");
                    return false;
                }
                return true;
            }
            if (parameterTypes.size() == i) {
                return false;
            }
            if (this.isMethodParameterTypeMatch(pointcutMethodParameterType, parameterTypes.get(i))) continue;
            return false;
        }
        return parameterTypes.size() == pointcutMethodParameterTypes.length;
    }

    private boolean isMethodParameterTypeMatch(String pointcutMethodParameterType, Type parameterType) {
        return pointcutMethodParameterType.equals("*") || pointcutMethodParameterType.equals(parameterType.getClassName());
    }

    private boolean isMethodReturnMatch(Type returnType) {
        String pointcutMethodReturn = this.advice().pointcut().methodReturnType();
        return pointcutMethodReturn.isEmpty() || pointcutMethodReturn.equals(returnType.getClassName());
    }

    private boolean isMethodModifiersMatch(int modifiers) {
        for (MethodModifier methodModifier : this.advice().pointcut().methodModifiers()) {
            if (this.isMethodModifierMatch(methodModifier, modifiers)) continue;
            return false;
        }
        return true;
    }

    private boolean isMethodModifierMatch(MethodModifier methodModifier, int modifiers) {
        switch (methodModifier) {
            case PUBLIC: {
                return Modifier.isPublic(modifiers);
            }
            case STATIC: {
                return Modifier.isStatic(modifiers);
            }
            case NOT_STATIC: {
                return !Modifier.isStatic(modifiers);
            }
        }
        return false;
    }

    private static boolean isDeclaringClassNameMatch(String className, Advice advice) {
        Pattern pointcutClassNamePattern = advice.pointcutDeclaringClassNamePattern();
        if (pointcutClassNamePattern == null) {
            return advice.pointcutDeclaringClassName().equals(className);
        }
        return pointcutClassNamePattern.matcher(className).matches();
    }
}

