/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.weaving.AnalyzedMethod;
import org.glowroot.weaving.WeavingClassVisitor;

@ParametersAreNonnullByDefault
@Immutable
final class AnalyzedMethodKey
extends WeavingClassVisitor.AnalyzedMethodKeyBase {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final AnalyzedMethod analyzedMethod;

    private AnalyzedMethodKey(String name, ImmutableList<String> parameterTypes, AnalyzedMethod analyzedMethod) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.analyzedMethod = analyzedMethod;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="parameterTypes")
    public ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    @JsonProperty(value="analyzedMethod")
    public AnalyzedMethod analyzedMethod() {
        return this.analyzedMethod;
    }

    public final AnalyzedMethodKey withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AnalyzedMethodKey(newValue, this.parameterTypes, this.analyzedMethod);
    }

    public final AnalyzedMethodKey withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
    }

    public final AnalyzedMethodKey withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
    }

    public final AnalyzedMethodKey withAnalyzedMethod(AnalyzedMethod value) {
        if (this.analyzedMethod == value) {
            return this;
        }
        AnalyzedMethod newValue = Preconditions.checkNotNull(value);
        return new AnalyzedMethodKey(this.name, this.parameterTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AnalyzedMethodKey && this.equalTo((AnalyzedMethodKey)another);
    }

    private boolean equalTo(AnalyzedMethodKey another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.parameterTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedMethodKey").add("name", this.name).add("parameterTypes", this.parameterTypes).toString();
    }

    @JsonCreator
    public static AnalyzedMethodKey fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="parameterTypes") @Nullable ImmutableList<String> parameterTypes, @JsonProperty(value="analyzedMethod") @Nullable AnalyzedMethod analyzedMethod) {
        Builder builder = AnalyzedMethodKey.builder();
        if (name != null) {
            builder.name(name);
        }
        if (parameterTypes != null) {
            builder.addAllParameterTypes(parameterTypes);
        }
        if (analyzedMethod != null) {
            builder.analyzedMethod(analyzedMethod);
        }
        return builder.build();
    }

    static AnalyzedMethodKey copyOf(WeavingClassVisitor.AnalyzedMethodKeyBase instance) {
        if (instance instanceof AnalyzedMethodKey) {
            return (AnalyzedMethodKey)instance;
        }
        return AnalyzedMethodKey.builder().name(instance.name()).addAllParameterTypes(instance.parameterTypes()).analyzedMethod(instance.analyzedMethod()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_ANALYZED_METHOD = 2L;
        private long initializedBitset;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
        @Nullable
        private AnalyzedMethod analyzedMethod;

        private Builder() {
        }

        public final Builder name(String name) {
            this.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addParameterTypes(String element) {
            this.parameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder analyzedMethod(AnalyzedMethod analyzedMethod) {
            this.checkNotIsSet(this.analyzedMethodIsSet(), "analyzedMethod");
            this.analyzedMethod = Preconditions.checkNotNull(analyzedMethod);
            this.initializedBitset |= 2L;
            return this;
        }

        public AnalyzedMethodKey build() {
            this.checkRequiredAttributes();
            return new AnalyzedMethodKey(this.name, (ImmutableList)this.parameterTypesBuilder.build(), this.analyzedMethod);
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean analyzedMethodIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of AnalyzedMethodKey is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.analyzedMethodIsSet()) {
                attributes.add("analyzedMethod");
            }
            return "Cannot build AnalyzedMethodKey, some of required attributes are not set " + attributes;
        }
    }
}

