/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.common.ClassNames;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.objectweb.asm.ClassVisitor;
import org.glowroot.shaded.objectweb.asm.MethodVisitor;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceMatcher;
import org.glowroot.weaving.AnalyzedClass;
import org.glowroot.weaving.AnalyzedMethod;
import org.glowroot.weaving.AnalyzedWorld;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ParseContext;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.WeavingClassVisitor;

class AnalyzingClassVisitor
extends ClassVisitor {
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    private final ImmutableList<Advice> advisors;
    @Nullable
    private final ClassLoader loader;
    private final AnalyzedWorld analyzedWorld;
    @Nullable
    private final CodeSource codeSource;
    private ImmutableList<AdviceMatcher> adviceMatchers = ImmutableList.of();
    private ImmutableList<ShimType> matchedShimTypes = ImmutableList.of();
    private ImmutableList<MixinType> matchedMixinTypes = ImmutableList.of();
    private List<AnalyzedClass> superAnalyzedClasses = ImmutableList.of();
    private AnalyzedClass.Builder analyzedClassBuilder;
    @MonotonicNonNull
    private AnalyzedClass analyzedClass;
    @MonotonicNonNull
    private String className;
    @MonotonicNonNull
    private Set<String> superClassNames;

    public AnalyzingClassVisitor(List<Advice> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, @Nullable ClassLoader loader, AnalyzedWorld analyzedWorld, @Nullable CodeSource codeSource) {
        super(327680);
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.advisors = ImmutableList.copyOf(advisors);
        this.loader = loader;
        this.analyzedWorld = analyzedWorld;
        this.codeSource = codeSource;
    }

    @Override
    public void visit(int version, int access, String internalName, @Nullable String signature, @Nullable String superInternalName, String[] interfaceInternalNamesNullable) {
        AnalyzedClass nonInterestingAnalyzedClass = this.visitAndSometimesReturnNonInterestingAnalyzedClass(access, internalName, superInternalName, interfaceInternalNamesNullable);
        if (nonInterestingAnalyzedClass != null) {
            this.analyzedClass = nonInterestingAnalyzedClass;
            throw WeavingClassVisitor.ShortCircuitException.INSTANCE;
        }
    }

    @Nullable
    public AnalyzedClass visitAndSometimesReturnNonInterestingAnalyzedClass(int access, String internalName, @Nullable String superInternalName, String[] interfaceInternalNamesNullable) {
        ImmutableList<String> interfaceNames = ClassNames.fromInternalNames(interfaceInternalNamesNullable);
        this.className = ClassNames.fromInternalName(internalName);
        String superClassName = ClassNames.fromInternalName(superInternalName);
        this.analyzedClassBuilder = AnalyzedClass.builder().modifiers(access).name(this.className).superName(superClassName).addAllInterfaceNames(interfaceNames);
        this.adviceMatchers = AdviceMatcher.getAdviceMatchers(this.className, this.advisors);
        if (Modifier.isInterface(access)) {
            this.superAnalyzedClasses = ImmutableList.of();
            this.matchedShimTypes = this.getMatchedShimTypes(this.className, ImmutableList.<AnalyzedClass>of(), ImmutableList.<AnalyzedClass>of());
            this.analyzedClassBuilder.addAllShimTypes(this.matchedShimTypes);
            this.matchedMixinTypes = this.getMatchedMixinTypes(this.className, ImmutableList.<AnalyzedClass>of(), ImmutableList.<AnalyzedClass>of());
            this.analyzedClassBuilder.addAllMixinTypes(this.matchedMixinTypes);
            if (this.adviceMatchers.isEmpty()) {
                return this.analyzedClassBuilder.build();
            }
            return null;
        }
        ParseContext parseContext = ParseContext.of(this.className, this.codeSource);
        List<AnalyzedClass> superAnalyzedHierarchy = this.analyzedWorld.getAnalyzedHierarchy(superClassName, this.loader, parseContext);
        List<AnalyzedClass> interfaceAnalyzedHierarchy = this.getAnalyzedHierarchy(interfaceNames, parseContext);
        this.superAnalyzedClasses = Lists.newArrayList();
        this.superAnalyzedClasses.addAll(superAnalyzedHierarchy);
        this.superAnalyzedClasses.addAll(interfaceAnalyzedHierarchy);
        this.matchedShimTypes = this.getMatchedShimTypes(this.className, superAnalyzedHierarchy, interfaceAnalyzedHierarchy);
        this.analyzedClassBuilder.addAllShimTypes(this.matchedShimTypes);
        this.matchedMixinTypes = this.getMatchedMixinTypes(this.className, superAnalyzedHierarchy, interfaceAnalyzedHierarchy);
        this.analyzedClassBuilder.addAllMixinTypes(this.matchedMixinTypes);
        if (this.isNonInteresting()) {
            return this.analyzedClassBuilder.build();
        }
        return null;
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, @Nullable String signature, String[] exceptions) {
        this.visitMethodAndReturnAdvisors(access, name, desc, signature, exceptions);
        return null;
    }

    @Override
    public void visitEnd() {
        Preconditions.checkNotNull(this.analyzedClassBuilder, "Call to visit() is required");
        this.analyzedClass = this.analyzedClassBuilder.build();
    }

    List<Advice> visitMethodAndReturnAdvisors(int access, String name, String desc, @Nullable String signature, String[] exceptions) {
        Type returnType;
        List<Type> parameterTypes = Arrays.asList(Type.getArgumentTypes(desc));
        List<Advice> matchingAdvisors = this.getMatchingAdvisors(name, parameterTypes, returnType = Type.getReturnType(desc), access);
        if (!matchingAdvisors.isEmpty()) {
            Preconditions.checkNotNull(this.analyzedClassBuilder, "Call to visit() is required");
            AnalyzedMethod.Builder builder = AnalyzedMethod.builder();
            builder.name(name);
            for (Type parameterType : parameterTypes) {
                builder.addParameterTypes(parameterType.getClassName());
            }
            builder.returnType(returnType.getClassName()).modifiers(access).signature(signature);
            if (exceptions != null) {
                for (String exception : exceptions) {
                    builder.addExceptions(ClassNames.fromInternalName(exception));
                }
            }
            builder.addAllAdvisors(matchingAdvisors);
            this.analyzedClassBuilder.addAnalyzedMethods(builder.build());
        }
        return matchingAdvisors;
    }

    ImmutableList<ShimType> getMatchedShimTypes() {
        return this.matchedShimTypes;
    }

    ImmutableList<MixinType> getMatchedMixinTypes() {
        return this.matchedMixinTypes;
    }

    List<AnalyzedClass> getSuperAnalyzedClasses() {
        return this.superAnalyzedClasses;
    }

    @Nullable
    AnalyzedClass getAnalyzedClass() {
        return this.analyzedClass;
    }

    private List<AnalyzedClass> getAnalyzedHierarchy(ImmutableList<String> classNames, ParseContext parseContext) {
        ArrayList<AnalyzedClass> analyzedHierarchy = Lists.newArrayList();
        for (String className : classNames) {
            analyzedHierarchy.addAll(this.analyzedWorld.getAnalyzedHierarchy(className, this.loader, parseContext));
        }
        return analyzedHierarchy;
    }

    private ImmutableList<ShimType> getMatchedShimTypes(String className, Iterable<AnalyzedClass> superAnalyzedClasses, List<AnalyzedClass> newInterfaceAnalyzedClasses) {
        HashSet<ShimType> matchedShimTypes = Sets.newHashSet();
        for (ShimType shimType : this.shimTypes) {
            if (!shimType.target().equals(className)) continue;
            matchedShimTypes.add(shimType);
        }
        for (AnalyzedClass newInterfaceAnalyzedClass : newInterfaceAnalyzedClasses) {
            matchedShimTypes.addAll(newInterfaceAnalyzedClass.shimTypes());
        }
        for (AnalyzedClass superAnalyzedClass : superAnalyzedClasses) {
            if (superAnalyzedClass.isInterface()) continue;
            matchedShimTypes.removeAll(superAnalyzedClass.shimTypes());
        }
        return ImmutableList.copyOf(matchedShimTypes);
    }

    private ImmutableList<MixinType> getMatchedMixinTypes(String className, Iterable<AnalyzedClass> superAnalyzedClasses, List<AnalyzedClass> newInterfaceAnalyzedClasses) {
        HashSet<MixinType> matchedMixinTypes = Sets.newHashSet();
        for (MixinType mixinType : this.mixinTypes) {
            if (!mixinType.targets().contains(className)) continue;
            matchedMixinTypes.add(mixinType);
        }
        for (AnalyzedClass newInterfaceAnalyzedClass : newInterfaceAnalyzedClasses) {
            matchedMixinTypes.addAll(newInterfaceAnalyzedClass.mixinTypes());
        }
        for (AnalyzedClass superAnalyzedClass : superAnalyzedClasses) {
            if (superAnalyzedClass.isInterface()) continue;
            matchedMixinTypes.removeAll(superAnalyzedClass.mixinTypes());
        }
        return ImmutableList.copyOf(matchedMixinTypes);
    }

    private boolean isNonInteresting() {
        return !this.hasSuperAdvice() && this.adviceMatchers.isEmpty() && this.matchedShimTypes.isEmpty() && this.matchedMixinTypes.isEmpty();
    }

    private boolean hasSuperAdvice() {
        for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
            if (superAnalyzedClass.analyzedMethods().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private List<Advice> getMatchingAdvisors(String methodName, List<Type> parameterTypes, Type returnType, int modifiers) {
        HashSet<Advice> matchingAdvisors = Sets.newHashSet();
        for (AdviceMatcher adviceMatcher : this.adviceMatchers) {
            if (!adviceMatcher.isMethodLevelMatch(methodName, parameterTypes, returnType, modifiers)) continue;
            matchingAdvisors.add(adviceMatcher.advice());
        }
        Preconditions.checkNotNull(this.superAnalyzedClasses, "Call to visit() is required");
        for (AnalyzedClass superAnalyzedClass : this.superAnalyzedClasses) {
            for (AnalyzedMethod analyzedMethod : superAnalyzedClass.analyzedMethods()) {
                if (!analyzedMethod.isOverriddenBy(methodName, parameterTypes)) continue;
                this.addToMatchingAdvisors(matchingAdvisors, analyzedMethod.advisors());
            }
        }
        return this.sortAdvisors(matchingAdvisors);
    }

    void addToMatchingAdvisors(Set<Advice> matchingAdvisors, List<Advice> advisors) {
        for (Advice advice : advisors) {
            if (advice.pointcut().declaringClassName().equals("")) {
                matchingAdvisors.add(advice);
                continue;
            }
            if (!this.isTargetClassNameMatch(advice)) continue;
            matchingAdvisors.add(advice);
        }
    }

    private boolean isTargetClassNameMatch(Advice advice) {
        Pattern targetClassNamePattern;
        if (this.superClassNames == null) {
            this.superClassNames = this.buildSuperClassNames();
        }
        if ((targetClassNamePattern = advice.pointcutTargetClassNamePattern()) == null) {
            return this.superClassNames.contains(advice.pointcutTargetClassName());
        }
        for (String superClassName : this.superClassNames) {
            if (!targetClassNamePattern.matcher(superClassName).matches()) continue;
            return true;
        }
        return false;
    }

    private Set<String> buildSuperClassNames() {
        Preconditions.checkNotNull(this.className, "Call to visit() is required");
        HashSet<String> superClassNames = Sets.newHashSet();
        superClassNames.add(this.className);
        for (AnalyzedClass analyzedClass : this.superAnalyzedClasses) {
            superClassNames.add(analyzedClass.name());
        }
        return superClassNames;
    }

    private List<Advice> sortAdvisors(Set<Advice> matchingAdvisors) {
        switch (matchingAdvisors.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.copyOf(matchingAdvisors);
            }
        }
        return Advice.ordering.immutableSortedCopy(matchingAdvisors);
    }
}

