/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.common.ClassNames;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.plugin.api.Agent;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.google.common.base.Suppliers;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.google.common.reflect.Reflection;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceFlowOuterHolder;
import org.glowroot.weaving.AnalyzedWorld;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.Weaver;
import org.glowroot.weaving.WeavingTimerService;

@OnlyUsedByTests
public class IsolatedWeavingClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(IsolatedWeavingClassLoader.class);
    private final ImmutableList<Class<?>> bridgeClasses;
    private final ImmutableList<String> excludePackages;
    private final Weaver weaver;
    private final Map<String, Class<?>> classes = Maps.newConcurrentMap();
    private final ThreadLocal<Boolean> inWeaving = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private IsolatedWeavingClassLoader(@Nullable ClassLoader parentClassLoader, List<Advice> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, WeavingTimerService weavingTimerService, List<Class<?>> bridgeClasses, List<String> excludePackages, boolean timerWrapperMethods) {
        super(parentClassLoader);
        this.bridgeClasses = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(bridgeClasses)).add(IsolatedWeavingClassLoader.class)).build();
        this.excludePackages = ImmutableList.copyOf(excludePackages);
        Supplier<List<Advice>> advisorsSupplier = Suppliers.ofInstance(ImmutableList.copyOf(advisors));
        AnalyzedWorld analyzedWorld = new AnalyzedWorld(advisorsSupplier, shimTypes, mixinTypes, null);
        this.weaver = new Weaver(advisorsSupplier, shimTypes, mixinTypes, analyzedWorld, weavingTimerService, timerWrapperMethods);
    }

    public <S, T extends S> S newInstance(Class<T> implClass, Class<S> bridgeClass) throws Exception {
        this.validateBridgeable(bridgeClass.getName());
        return bridgeClass.cast(this.loadClass(implClass.getName()).newInstance());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.loadWithParentClassLoader(name)) {
            return super.loadClass(name, resolve);
        }
        Class<?> c = this.classes.get(name);
        if (c != null) {
            return c;
        }
        c = this.findClass(name);
        this.classes.put(name, c);
        return c;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        for (Class clazz : this.bridgeClasses) {
            if (!clazz.getName().equals(name)) continue;
            return clazz;
        }
        String resourceName = ClassNames.toInternalName(name) + ".class";
        URL uRL = this.getResource(resourceName);
        if (uRL == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            bytes = Resources.toByteArray(uRL);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error loading class", e);
        }
        return this.weaveAndDefineClass(name, bytes);
    }

    public Class<?> weaveAndDefineClass(String name, byte[] bytes) {
        byte[] wovenBytes = this.weaveClass(name, bytes);
        String packageName = Reflection.getPackageName(name);
        if (this.getPackage(packageName) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return super.defineClass(name, wovenBytes, 0, wovenBytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] weaveClass(String name, byte[] bytes) throws ClassFormatError {
        if (this.inWeaving.get().booleanValue()) {
            return bytes;
        }
        this.inWeaving.set(true);
        try {
            byte[] wovenBytes = this.weaver.weave(bytes, ClassNames.toInternalName(name), null, this);
            if (wovenBytes == null) {
                byte[] byArray = bytes;
                return byArray;
            }
            logger.debug("findClass(): transformed {}", (Object)name);
            byte[] byArray = wovenBytes;
            return byArray;
        }
        finally {
            this.inWeaving.remove();
        }
    }

    private void validateBridgeable(String name) {
        if (IsolatedWeavingClassLoader.isInBootstrapClassLoader(name)) {
            return;
        }
        for (Class clazz : this.bridgeClasses) {
            if (!clazz.getName().equals(name)) continue;
            return;
        }
        throw new IllegalStateException("Class '" + name + "' is not bridgeable");
    }

    private boolean loadWithParentClassLoader(String name) {
        if (name.startsWith(Agent.class.getName())) {
            return false;
        }
        if (IsolatedWeavingClassLoader.isInBootstrapClassLoader(name)) {
            return true;
        }
        for (String excludePackage : this.excludePackages) {
            if (!name.startsWith(excludePackage + ".")) continue;
            return true;
        }
        return name.equals(AdviceFlowOuterHolder.class.getName()) || name.equals(AdviceFlowOuterHolder.AdviceFlowHolder.class.getName());
    }

    private static boolean isInBootstrapClassLoader(String name) {
        try {
            Class<?> cls = Class.forName(name, false, ClassLoader.getSystemClassLoader());
            return cls.getClassLoader() == null;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), e);
            return false;
        }
    }

    public static class Builder {
        @Nullable
        private ClassLoader parentClassLoader = Builder.class.getClassLoader();
        private List<ShimType> shimTypes = Lists.newArrayList();
        private List<MixinType> mixinTypes = Lists.newArrayList();
        private List<Advice> advisors = Lists.newArrayList();
        @MonotonicNonNull
        private WeavingTimerService weavingTimerService;
        private boolean timerWrapperMethods = true;
        private final List<Class<?>> bridgeClasses = Lists.newArrayList();
        private final List<String> excludePackages = Lists.newArrayList();

        private Builder() {
        }

        public void setParentClassLoader(ClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        public void setShimTypes(List<ShimType> shimTypes) {
            this.shimTypes = shimTypes;
        }

        public void setMixinTypes(List<MixinType> mixinTypes) {
            this.mixinTypes = mixinTypes;
        }

        public void setAdvisors(List<Advice> advisors) {
            this.advisors = advisors;
        }

        @EnsuresNonNull(value={"#1"})
        public void setWeavingTimerService(WeavingTimerService weavingTimerService) {
            this.weavingTimerService = weavingTimerService;
        }

        public void setTimerWrapperMethods(boolean timerWrapperMethods) {
            this.timerWrapperMethods = timerWrapperMethods;
        }

        public void addBridgeClasses(List<Class<?>> bridgeClasses) {
            this.bridgeClasses.addAll(bridgeClasses);
        }

        public void addBridgeClasses(Class<?> ... bridgeClasses) {
            this.bridgeClasses.addAll(Arrays.asList(bridgeClasses));
        }

        public void addExcludePackages(List<String> excludePackages) {
            this.excludePackages.addAll(excludePackages);
        }

        public void addExcludePackages(String ... excludePackages) {
            this.excludePackages.addAll(Arrays.asList(excludePackages));
        }

        @RequiresNonNull(value={"weavingTimerService"})
        public IsolatedWeavingClassLoader build() {
            return AccessController.doPrivileged(new PrivilegedAction<IsolatedWeavingClassLoader>(){

                @Override
                public IsolatedWeavingClassLoader run() {
                    Preconditions.checkNotNull(Builder.this.weavingTimerService);
                    return new IsolatedWeavingClassLoader(Builder.this.parentClassLoader, Builder.this.advisors, Builder.this.shimTypes, Builder.this.mixinTypes, Builder.this.weavingTimerService, Builder.this.bridgeClasses, Builder.this.excludePackages, Builder.this.timerWrapperMethods);
                }
            });
        }
    }
}

