/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.annotation.Nullable;
import org.glowroot.plugin.api.weaving.Mixin;
import org.glowroot.plugin.api.weaving.MixinInit;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.io.Resources;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.MixinType;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MixinTypeBase {
    private static final Logger logger = LoggerFactory.getLogger(MixinType.class);

    public static MixinType from(Mixin mixin, Class<?> implementation) throws IOException {
        MixinType.Builder builder = MixinType.builder();
        builder.addTargets(mixin.value());
        builder.implementation(Type.getType(implementation));
        for (Class<?> iface : implementation.getInterfaces()) {
            builder.addInterfaces(Type.getType(iface));
        }
        String initMethodName = null;
        for (Method method : implementation.getDeclaredMethods()) {
            if (method.getAnnotation(MixinInit.class) == null) continue;
            if (initMethodName != null) {
                logger.error("mixin has more than one @MixinInit: {}", (Object)implementation.getName());
                continue;
            }
            if (method.getParameterTypes().length > 0) {
                logger.error("@MixinInit method cannot have any parameters: {}", (Object)implementation.getName());
                continue;
            }
            if (method.getReturnType() != Void.TYPE) {
                logger.warn("@MixinInit method must return void: {}", (Object)implementation.getName());
                continue;
            }
            initMethodName = method.getName();
        }
        builder.initMethodName(initMethodName);
        ClassLoader loader = implementation.getClassLoader();
        String resourceName = implementation.getName().replace('.', '/') + ".class";
        URL url = loader == null ? ClassLoader.getSystemResource(resourceName) : loader.getResource(resourceName);
        Preconditions.checkNotNull(url, "Could not find resource: %s", resourceName);
        builder.implementationBytes(Resources.toByteArray(url));
        return builder.build();
    }

    abstract Type implementation();

    abstract ImmutableList<String> targets();

    abstract ImmutableList<Type> interfaces();

    @Nullable
    abstract String initMethodName();

    abstract byte[] implementationBytes();
}

