/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.io.IOException;
import java.security.CodeSource;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.common.ClassNames;
import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.objectweb.asm.ClassReader;
import org.glowroot.shaded.objectweb.asm.ClassVisitor;
import org.glowroot.shaded.objectweb.asm.ClassWriter;
import org.glowroot.shaded.objectweb.asm.MethodVisitor;
import org.glowroot.shaded.objectweb.asm.commons.JSRInlinerAdapter;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AnalyzedClass;
import org.glowroot.weaving.AnalyzedWorld;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ParseContext;
import org.glowroot.weaving.PointcutClassVisitor;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.WeavingClassVisitor;
import org.glowroot.weaving.WeavingTimerService;

class Weaver {
    private static final Logger logger = LoggerFactory.getLogger(Weaver.class);
    private final Supplier<List<Advice>> advisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    private final AnalyzedWorld analyzedWorld;
    private final WeavingTimerService weavingTimerService;
    private final boolean timerWrapperMethods;

    Weaver(Supplier<List<Advice>> advisors, List<ShimType> shimTypes, List<MixinType> mixinTypes, AnalyzedWorld analyzedWorld, WeavingTimerService weavingTimerService, boolean timerWrapperMethods) {
        this.advisors = advisors;
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.analyzedWorld = analyzedWorld;
        this.weavingTimerService = weavingTimerService;
        this.timerWrapperMethods = timerWrapperMethods;
    }

    byte[] weave(byte[] classBytes, String className, @Nullable CodeSource codeSource, @Nullable ClassLoader loader) {
        if (this.timerWrapperMethods) {
            return this.weave$glowroot$timer$glowroot$weaving$0(classBytes, className, codeSource, loader);
        }
        return this.weaveInternal(classBytes, className, codeSource, loader);
    }

    private byte[] weave$glowroot$timer$glowroot$weaving$0(byte[] classBytes, String className, @Nullable CodeSource codeSource, @Nullable ClassLoader loader) {
        return this.weaveInternal(classBytes, className, codeSource, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] weaveInternal(byte[] classBytes, String className, @Nullable CodeSource codeSource, @Nullable ClassLoader loader) {
        WeavingTimerService.WeavingTimer weavingTimer = this.weavingTimerService.start();
        try {
            byte[] byArray = this.weaveUnderTimer(classBytes, className, codeSource, loader);
            return byArray;
        }
        finally {
            weavingTimer.stop();
        }
    }

    private byte[] weaveUnderTimer(byte[] classBytes, String className, @Nullable CodeSource codeSource, @Nullable ClassLoader loader) {
        ComputeFramesClassWriter cw = new ComputeFramesClassWriter(2, this.analyzedWorld, loader, codeSource, className);
        WeavingClassVisitor cv = new WeavingClassVisitor(cw, this.advisors.get(), this.shimTypes, this.mixinTypes, loader, this.analyzedWorld, codeSource, this.timerWrapperMethods);
        ClassReader cr = new ClassReader(classBytes);
        boolean shortCircuitException = false;
        boolean pointcutClassFoundException = false;
        try {
            cr.accept(new JSRInlinerClassVisitor(cv), 4);
        }
        catch (WeavingClassVisitor.ShortCircuitException e) {
            shortCircuitException = true;
        }
        catch (WeavingClassVisitor.PointcutClassFoundException e) {
            pointcutClassFoundException = true;
        }
        if (shortCircuitException || cv.isInterfaceSoNothingToWeave()) {
            return null;
        }
        if (pointcutClassFoundException) {
            ComputeFramesClassWriter cw2 = new ComputeFramesClassWriter(2, this.analyzedWorld, loader, codeSource, className);
            PointcutClassVisitor cv2 = new PointcutClassVisitor(cw2);
            ClassReader cr2 = new ClassReader(classBytes);
            cr2.accept(new JSRInlinerClassVisitor(cv2), 4);
            return cw2.toByteArray();
        }
        return cw.toByteArray();
    }

    @VisibleForTesting
    static class ComputeFramesClassWriter
    extends ClassWriter {
        private final AnalyzedWorld analyzedWorld;
        @Nullable
        private final ClassLoader loader;
        private final ParseContext parseContext;

        public ComputeFramesClassWriter(int flags, AnalyzedWorld analyzedWorld, @Nullable ClassLoader loader, @Nullable CodeSource codeSource, String className) {
            super(flags);
            this.analyzedWorld = analyzedWorld;
            this.loader = loader;
            this.parseContext = ParseContext.of(className, codeSource);
        }

        @Override
        protected String getCommonSuperClass(String type1, String type2) {
            if (type1.equals("java/lang/Object") || type2.equals("java/lang/Object")) {
                return "java/lang/Object";
            }
            try {
                return this.getCommonSuperClassInternal(type1, type2);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
                return "java/lang/Object";
            }
        }

        private String getCommonSuperClassInternal(String type1, String type2) throws IOException {
            AnalyzedClass analyzedClass2;
            AnalyzedClass analyzedClass1;
            try {
                analyzedClass1 = this.analyzedWorld.getAnalyzedClass(ClassNames.fromInternalName(type1), this.loader);
            }
            catch (ClassNotFoundException e) {
                logger.debug("type {} not found while parsing type {}", type1, this.parseContext, e);
                return "java/lang/Object";
            }
            try {
                analyzedClass2 = this.analyzedWorld.getAnalyzedClass(ClassNames.fromInternalName(type2), this.loader);
            }
            catch (ClassNotFoundException e) {
                logger.debug("type {} not found while parsing type {}", type2, this.parseContext, e);
                return "java/lang/Object";
            }
            return this.getCommonSuperClass(analyzedClass1, analyzedClass2, type1, type2);
        }

        private String getCommonSuperClass(AnalyzedClass analyzedClass1, AnalyzedClass analyzedClass2, String type1, String type2) throws IOException {
            if (this.isAssignableFrom(analyzedClass1.name(), analyzedClass2)) {
                return type1;
            }
            if (this.isAssignableFrom(analyzedClass2.name(), analyzedClass1)) {
                return type2;
            }
            if (analyzedClass1.isInterface() || analyzedClass2.isInterface()) {
                return "java/lang/Object";
            }
            return this.getCommonSuperClass(analyzedClass1, analyzedClass2);
        }

        private String getCommonSuperClass(AnalyzedClass analyzedClass1, AnalyzedClass analyzedClass2) throws IOException {
            String superName = analyzedClass1.superName();
            while (superName != null) {
                if (this.isAssignableFrom(superName, analyzedClass2)) {
                    return ClassNames.toInternalName(superName);
                }
                try {
                    AnalyzedClass superAnalyzedClass = this.analyzedWorld.getAnalyzedClass(superName, this.loader);
                    superName = superAnalyzedClass.superName();
                }
                catch (ClassNotFoundException e) {
                    logger.debug("type {} not found while parsing type {}", superName, this.parseContext, e);
                    return "java/lang/Object";
                }
            }
            return "java/lang/Object";
        }

        private boolean isAssignableFrom(String possibleSuperClassName, AnalyzedClass analyzedClass) throws IOException {
            if (analyzedClass.name().equals(possibleSuperClassName)) {
                return true;
            }
            if (this.isAssignableFromInterfaces(possibleSuperClassName, analyzedClass)) {
                return true;
            }
            String superName = analyzedClass.superName();
            if (superName == null) {
                return false;
            }
            return this.isAssignableFromSuperClass(possibleSuperClassName, superName);
        }

        private boolean isAssignableFromInterfaces(String possibleSuperClassName, AnalyzedClass analyzedClass) throws IOException {
            for (String interfaceName : analyzedClass.interfaceNames()) {
                try {
                    AnalyzedClass interfaceAnalyzedClass = this.analyzedWorld.getAnalyzedClass(interfaceName, this.loader);
                    if (!this.isAssignableFrom(possibleSuperClassName, interfaceAnalyzedClass)) continue;
                    return true;
                }
                catch (ClassNotFoundException e) {
                    logger.debug("type {} not found while parsing type {}", interfaceName, this.parseContext, e);
                }
            }
            return false;
        }

        private boolean isAssignableFromSuperClass(String possibleSuperClassName, String superName) throws IOException {
            try {
                AnalyzedClass superAnalyzedClass = this.analyzedWorld.getAnalyzedClass(superName, this.loader);
                return this.isAssignableFrom(possibleSuperClassName, superAnalyzedClass);
            }
            catch (ClassNotFoundException e) {
                logger.debug("type {} not found while parsing type {}", superName, this.parseContext, e);
                return false;
            }
        }
    }

    private static class JSRInlinerClassVisitor
    extends ClassVisitor {
        private final ClassVisitor cv;

        private JSRInlinerClassVisitor(ClassVisitor cv) {
            super(327680, cv);
            this.cv = cv;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String desc, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            return new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
        }
    }
}

