/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.lang.instrument.ClassFileTransformer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.base.Supplier;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AnalyzedWorld;
import org.glowroot.weaving.MixinType;
import org.glowroot.weaving.ShimType;
import org.glowroot.weaving.Weaver;
import org.glowroot.weaving.WeavingTimerService;

public class WeavingClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(WeavingClassFileTransformer.class);
    private final Weaver weaver;
    private final boolean weaveBootstrapClassLoader;

    public WeavingClassFileTransformer(List<ShimType> shimTypes, List<MixinType> mixinTypes, Supplier<List<Advice>> advisors, AnalyzedWorld analyzedWorld, WeavingTimerService weavingTimerService, boolean timerWrapperMethods) {
        this.weaver = new Weaver(advisors, shimTypes, mixinTypes, analyzedWorld, weavingTimerService, timerWrapperMethods);
        this.weaveBootstrapClassLoader = WeavingClassFileTransformer.isInBootstrapClassLoader();
    }

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        if (className == null) {
            return null;
        }
        try {
            return this.transformInternal(loader, className, protectionDomain, bytes);
        }
        catch (Throwable t) {
            logger.error("error weaving {}: {}", className, t.getMessage(), t);
            return null;
        }
    }

    private byte[] transformInternal(@Nullable ClassLoader loader, String className, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        if (WeavingClassFileTransformer.ignoreClass(className)) {
            return null;
        }
        if (loader == null && !this.weaveBootstrapClassLoader) {
            return null;
        }
        logger.trace("transform(): className={}", (Object)className);
        CodeSource codeSource = protectionDomain == null ? null : protectionDomain.getCodeSource();
        byte[] transformedBytes = this.weaver.weave(bytes, className, codeSource, loader);
        if (transformedBytes != null) {
            logger.debug("transform(): transformed {}", (Object)className);
        }
        return transformedBytes;
    }

    private static boolean ignoreClass(String className) {
        if (WeavingClassFileTransformer.isGlowrootCoreClass(className)) {
            return true;
        }
        if (className.startsWith("sun/reflect/Generated")) {
            return true;
        }
        return className.startsWith("com/sun/proxy/$Proxy");
    }

    private static boolean isGlowrootCoreClass(String className) {
        return className.startsWith("org/glowroot/plugin/api/") || className.startsWith("org/glowroot/advicegen/") || className.startsWith("org/glowroot/collector/") || className.startsWith("org/glowroot/common/") || className.startsWith("org/glowroot/config/") || className.startsWith("org/glowroot/jvm/") || className.startsWith("org/glowroot/local/") || className.startsWith("org/glowroot/shaded/") || className.startsWith("org/glowroot/transaction/") || className.startsWith("org/glowroot/weaving/");
    }

    private static boolean isInBootstrapClassLoader() {
        return WeavingClassFileTransformer.class.getClassLoader() == null;
    }
}

