package org.glowroot.collector;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Aggregate.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateBase"})
@Immutable
public final class Aggregate extends AggregateBase {
  private final String transactionType;
  private final @Nullable String transactionName;
  private final long captureTime;
  private final long totalMicros;
  private final long errorCount;
  private final long transactionCount;
  private final @Nullable Long totalCpuMicros;
  private final @Nullable Long totalBlockedMicros;
  private final @Nullable Long totalWaitedMicros;
  private final @Nullable Long totalAllocatedKBytes;
  private final byte[] histogram;
  private final String timers;
  private final @Nullable String queries;
  private final @Nullable String profile;

  private Aggregate(Aggregate.Builder builder) {
    this.transactionType = builder.transactionType;
    this.transactionName = builder.transactionName;
    this.captureTime = builder.captureTime;
    this.totalMicros = builder.totalMicros;
    this.errorCount = builder.errorCount;
    this.transactionCount = builder.transactionCount;
    this.totalCpuMicros = builder.totalCpuMicros;
    this.totalBlockedMicros = builder.totalBlockedMicros;
    this.totalWaitedMicros = builder.totalWaitedMicros;
    this.totalAllocatedKBytes = builder.totalAllocatedKBytes;
    this.histogram = builder.histogram;
    this.timers = builder.timers;
    this.queries = builder.queries;
    this.profile = builder.profile;
  }

  private Aggregate(
      Aggregate original,
      String transactionType,
      @Nullable String transactionName,
      long captureTime,
      long totalMicros,
      long errorCount,
      long transactionCount,
      @Nullable Long totalCpuMicros,
      @Nullable Long totalBlockedMicros,
      @Nullable Long totalWaitedMicros,
      @Nullable Long totalAllocatedKBytes,
      byte[] histogram,
      String timers,
      @Nullable String queries,
      @Nullable String profile) {
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.captureTime = captureTime;
    this.totalMicros = totalMicros;
    this.errorCount = errorCount;
    this.transactionCount = transactionCount;
    this.totalCpuMicros = totalCpuMicros;
    this.totalBlockedMicros = totalBlockedMicros;
    this.totalWaitedMicros = totalWaitedMicros;
    this.totalAllocatedKBytes = totalAllocatedKBytes;
    this.histogram = histogram;
    this.timers = timers;
    this.queries = queries;
    this.profile = profile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @Nullable
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalMicros} attribute
   */
  @Override
  public long totalMicros() {
    return totalMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorCount} attribute
   */
  @Override
  public long errorCount() {
    return errorCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalCpuMicros} attribute
   */
  @Nullable
  @Override
  public Long totalCpuMicros() {
    return totalCpuMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalBlockedMicros} attribute
   */
  @Nullable
  @Override
  public Long totalBlockedMicros() {
    return totalBlockedMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalWaitedMicros} attribute
   */
  @Nullable
  @Override
  public Long totalWaitedMicros() {
    return totalWaitedMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalAllocatedKBytes} attribute
   */
  @Nullable
  @Override
  public Long totalAllocatedKBytes() {
    return totalAllocatedKBytes;
  }
  
  /**
   * {@inheritDoc}
   * @return cloned {@code histogram} array
   */
  @Override
  public byte[] histogram() {
    return histogram.clone();
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timers} attribute
   */
  @JsonRawValue
  @Override
  public String timers() {
    return timers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code queries} attribute
   */
  @JsonRawValue
  @Nullable
  @Override
  public String queries() {
    return queries;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profile} attribute
   */
  @JsonRawValue
  @Nullable
  @Override
  public String profile() {
    return profile;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Aggregate(
        this,
        newValue,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        newValue,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        newValue,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#totalMicros() totalMicros}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalMicros
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTotalMicros(long value) {
    if (this.totalMicros == value) {
      return this;
    }
    long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        newValue,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#errorCount() errorCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorCount
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withErrorCount(long value) {
    if (this.errorCount == value) {
      return this;
    }
    long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        newValue,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        newValue,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#totalCpuMicros() totalCpuMicros}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalCpuMicros, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTotalCpuMicros(@Nullable Long value) {
    if (this.totalCpuMicros == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        newValue,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#totalBlockedMicros() totalBlockedMicros}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalBlockedMicros, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTotalBlockedMicros(@Nullable Long value) {
    if (this.totalBlockedMicros == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        newValue,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#totalWaitedMicros() totalWaitedMicros}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalWaitedMicros, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTotalWaitedMicros(@Nullable Long value) {
    if (this.totalWaitedMicros == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        newValue,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#totalAllocatedKBytes() totalAllocatedKBytes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalAllocatedKBytes, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTotalAllocatedKBytes(@Nullable Long value) {
    if (this.totalAllocatedKBytes == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        newValue,
        this.histogram,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AggregateBase#histogram() histogram}.
   * Array is cloned before saved as the attribute value.
   * @param elements elements for histogram, not null
   * @return modified copy of {@code this} object
   */
  public final Aggregate withHistogram(byte... elements) {
    byte[] newValue = elements.clone();
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        newValue,
        this.timers,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#timers() timers}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for timers
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withTimers(String value) {
    if (this.timers == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        newValue,
        this.queries,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#queries() queries}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for queries, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withQueries(@Nullable String value) {
    if (this.queries == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        newValue,
        this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateBase#profile() profile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profile, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final Aggregate withProfile(@Nullable String value) {
    if (this.profile == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new Aggregate(
        this,
        this.transactionType,
        this.transactionName,
        this.captureTime,
        this.totalMicros,
        this.errorCount,
        this.transactionCount,
        this.totalCpuMicros,
        this.totalBlockedMicros,
        this.totalWaitedMicros,
        this.totalAllocatedKBytes,
        this.histogram,
        this.timers,
        this.queries,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Aggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Aggregate && equalTo((Aggregate) another));
  }
  
  private boolean equalTo(Aggregate another) {
    return transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName)
        && captureTime == another.captureTime
        && totalMicros == another.totalMicros
        && errorCount == another.errorCount
        && transactionCount == another.transactionCount
        && Objects.equal(totalCpuMicros, another.totalCpuMicros)
        && Objects.equal(totalBlockedMicros, another.totalBlockedMicros)
        && Objects.equal(totalWaitedMicros, another.totalWaitedMicros)
        && Objects.equal(totalAllocatedKBytes, another.totalAllocatedKBytes)
        && Arrays.equals(histogram, another.histogram)
        && timers.equals(another.timers)
        && Objects.equal(queries, another.queries)
        && Objects.equal(profile, another.profile);
  }
  
  /**
   * Computes hash code from attributes: {@code transactionType}, {@code transactionName}, {@code captureTime}, {@code totalMicros}, {@code errorCount}, {@code transactionCount}, {@code totalCpuMicros}, {@code totalBlockedMicros}, {@code totalWaitedMicros}, {@code totalAllocatedKBytes}, {@code histogram}, {@code timers}, {@code queries}, {@code profile}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + Longs.hashCode(totalMicros);
    h = h * 17 + Longs.hashCode(errorCount);
    h = h * 17 + Longs.hashCode(transactionCount);
    h = h * 17 + Objects.hashCode(totalCpuMicros);
    h = h * 17 + Objects.hashCode(totalBlockedMicros);
    h = h * 17 + Objects.hashCode(totalWaitedMicros);
    h = h * 17 + Objects.hashCode(totalAllocatedKBytes);
    h = h * 17 + Arrays.hashCode(histogram);
    h = h * 17 + timers.hashCode();
    h = h * 17 + Objects.hashCode(queries);
    h = h * 17 + Objects.hashCode(profile);
    return h;
  }
  
  /**
   * Prints immutable value {@code Aggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Aggregate")
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("captureTime", captureTime)
        .add("totalMicros", totalMicros)
        .add("errorCount", errorCount)
        .add("transactionCount", transactionCount)
        .add("totalCpuMicros", totalCpuMicros)
        .add("totalBlockedMicros", totalBlockedMicros)
        .add("totalWaitedMicros", totalWaitedMicros)
        .add("totalAllocatedKBytes", totalAllocatedKBytes)
        .add("histogram", Arrays.toString(histogram))
        .add("timers", timers)
        .add("queries", queries)
        .add("profile", profile)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link AggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable Aggregate instance
   */
  public static Aggregate copyOf(AggregateBase instance) {
    if (instance instanceof Aggregate) {
      return (Aggregate) instance;
    }
    return Aggregate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.Aggregate}.
   * @return new Aggregate builder
   */
  public static Aggregate.Builder builder() {
    return new Aggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.Aggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7f;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x1L;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x2L;
    private static final long INITIALIZED_BIT_TOTAL_MICROS = 0x4L;
    private static final long INITIALIZED_BIT_ERROR_COUNT = 0x8L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x10L;
    private static final long INITIALIZED_BIT_HISTOGRAM = 0x20L;
    private static final long INITIALIZED_BIT_TIMERS = 0x40L;
    private long initializedBitset;
  
    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private long captureTime;
    private long totalMicros;
    private long errorCount;
    private long transactionCount;
    private @Nullable Long totalCpuMicros;
    private @Nullable Long totalBlockedMicros;
    private @Nullable Long totalWaitedMicros;
    private @Nullable Long totalAllocatedKBytes;
    private @Nullable byte[] histogram;
    private @Nullable String timers;
    private @Nullable String queries;
    private @Nullable String profile;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link AggregateBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(AggregateBase instance) {
      Preconditions.checkNotNull(instance);
      transactionType(instance.transactionType());
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      captureTime(instance.captureTime());
      totalMicros(instance.totalMicros());
      errorCount(instance.errorCount());
      transactionCount(instance.transactionCount());
      @Nullable Long totalCpuMicrosValue = instance.totalCpuMicros();
      if (totalCpuMicrosValue != null) {
        totalCpuMicros(totalCpuMicrosValue);
      }
      @Nullable Long totalBlockedMicrosValue = instance.totalBlockedMicros();
      if (totalBlockedMicrosValue != null) {
        totalBlockedMicros(totalBlockedMicrosValue);
      }
      @Nullable Long totalWaitedMicrosValue = instance.totalWaitedMicros();
      if (totalWaitedMicrosValue != null) {
        totalWaitedMicros(totalWaitedMicrosValue);
      }
      @Nullable Long totalAllocatedKBytesValue = instance.totalAllocatedKBytes();
      if (totalAllocatedKBytesValue != null) {
        totalAllocatedKBytes(totalAllocatedKBytesValue);
      }
      histogram(instance.histogram());
      timers(instance.timers());
      @Nullable String queriesValue = instance.queries();
      if (queriesValue != null) {
        queries(queriesValue);
      }
      @Nullable String profileValue = instance.profile();
      if (profileValue != null) {
        profile(profileValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#totalMicros() totalMicros}.
     * @param totalMicros value for totalMicros
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalMicros(long totalMicros) {
      this.totalMicros = totalMicros;
      initializedBitset |= INITIALIZED_BIT_TOTAL_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#errorCount() errorCount}.
     * @param errorCount value for errorCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorCount(long errorCount) {
      this.errorCount = errorCount;
      initializedBitset |= INITIALIZED_BIT_ERROR_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#totalCpuMicros() totalCpuMicros}.
     * @param totalCpuMicros value for totalCpuMicros, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalCpuMicros(@Nullable Long totalCpuMicros) {
      this.totalCpuMicros = totalCpuMicros;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#totalBlockedMicros() totalBlockedMicros}.
     * @param totalBlockedMicros value for totalBlockedMicros, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalBlockedMicros(@Nullable Long totalBlockedMicros) {
      this.totalBlockedMicros = totalBlockedMicros;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#totalWaitedMicros() totalWaitedMicros}.
     * @param totalWaitedMicros value for totalWaitedMicros, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalWaitedMicros(@Nullable Long totalWaitedMicros) {
      this.totalWaitedMicros = totalWaitedMicros;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#totalAllocatedKBytes() totalAllocatedKBytes}.
     * @param totalAllocatedKBytes value for totalAllocatedKBytes, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalAllocatedKBytes(@Nullable Long totalAllocatedKBytes) {
      this.totalAllocatedKBytes = totalAllocatedKBytes;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#histogram() histogram}.
     * @param elements elements for histogram
     * @return {@code this} builder for chained invocation
     */
    public final Builder histogram(byte... elements) {
      this.histogram = elements.clone();
      initializedBitset |= INITIALIZED_BIT_HISTOGRAM;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#timers() timers}.
     * @param timers value for timers
     * @return {@code this} builder for chained invocation
     */
    public final Builder timers(String timers) {
      this.timers = Preconditions.checkNotNull(timers);
      initializedBitset |= INITIALIZED_BIT_TIMERS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#queries() queries}.
     * @param queries value for queries, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder queries(@Nullable String queries) {
      this.queries = queries;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateBase#profile() profile}.
     * @param profile value for profile, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder profile(@Nullable String profile) {
      this.profile = profile;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.Aggregate}.
     * @return immutable instance of Aggregate
     */
    public Aggregate build() {
      checkRequiredAttributes();
      return new Aggregate(this);
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean totalMicrosIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TOTAL_MICROS) != 0;
    }
  
    private boolean errorCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ERROR_COUNT) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private boolean histogramIsSet() {
      return (initializedBitset & INITIALIZED_BIT_HISTOGRAM) != 0;
    }
  
    private boolean timersIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TIMERS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!totalMicrosIsSet()) {
        attributes.add("totalMicros");
      }
      if (!errorCountIsSet()) {
        attributes.add("errorCount");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      if (!histogramIsSet()) {
        attributes.add("histogram");
      }
      if (!timersIsSet()) {
        attributes.add("timers");
      }
      return "Cannot build Aggregate, some of required attributes are not set " + attributes;
    }
  }
}
