package org.glowroot.collector;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TransactionSummaryBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TransactionSummary.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TransactionSummaryBase"})
@Immutable
public final class TransactionSummary extends TransactionSummaryBase {
  private final @Nullable String transactionName;
  private final long totalMicros;
  private final long transactionCount;

  private TransactionSummary(TransactionSummary.Builder builder) {
    this.transactionName = builder.transactionName;
    this.totalMicros = builder.totalMicros;
    this.transactionCount = builder.transactionCount;
  }

  private TransactionSummary(
      TransactionSummary original,
      @Nullable String transactionName,
      long totalMicros,
      long transactionCount) {
    this.transactionName = transactionName;
    this.totalMicros = totalMicros;
    this.transactionCount = transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @Nullable
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalMicros} attribute
   */
  @JsonProperty("totalMicros")
  @Override
  public long totalMicros() {
    return totalMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionSummaryBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TransactionSummary withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TransactionSummary(this, newValue, this.totalMicros, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionSummaryBase#totalMicros() totalMicros}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalMicros
   * @return modified copy of the {@code this} object
   */
  public final TransactionSummary withTotalMicros(long value) {
    if (this.totalMicros == value) {
      return this;
    }
    long newValue = value;
    return new TransactionSummary(this, this.transactionName, newValue, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionSummaryBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final TransactionSummary withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new TransactionSummary(this, this.transactionName, this.totalMicros, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TransactionSummary} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TransactionSummary && equalTo((TransactionSummary) another));
  }
  
  private boolean equalTo(TransactionSummary another) {
    return Objects.equal(transactionName, another.transactionName)
        && totalMicros == another.totalMicros
        && transactionCount == another.transactionCount;
  }
  
  /**
   * Computes hash code from attributes: {@code transactionName}, {@code totalMicros}, {@code transactionCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + Longs.hashCode(totalMicros);
    h = h * 17 + Longs.hashCode(transactionCount);
    return h;
  }
  
  /**
   * Prints immutable value {@code TransactionSummary{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionSummary")
        .add("transactionName", transactionName)
        .add("totalMicros", totalMicros)
        .add("transactionCount", transactionCount)
        .toString();
  }
  
  @JsonCreator
  public static TransactionSummary fromAllAttributes(
      @JsonProperty("transactionName") @Nullable String transactionName,
      @JsonProperty("totalMicros") @Nullable Long totalMicros,
      @JsonProperty("transactionCount") @Nullable Long transactionCount) {
    TransactionSummary.Builder builder = TransactionSummary.builder();
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    if (totalMicros != null) {
      builder.totalMicros(totalMicros);
    }
    if (transactionCount != null) {
      builder.transactionCount(transactionCount);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link TransactionSummaryBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable TransactionSummary instance
   */
  public static TransactionSummary copyOf(TransactionSummaryBase instance) {
    if (instance instanceof TransactionSummary) {
      return (TransactionSummary) instance;
    }
    return TransactionSummary.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.TransactionSummary}.
   * @return new TransactionSummary builder
   */
  public static TransactionSummary.Builder builder() {
    return new TransactionSummary.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.TransactionSummary}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_TOTAL_MICROS = 0x1L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x2L;
    private long initializedBitset;
  
    private @Nullable String transactionName;
    private long totalMicros;
    private long transactionCount;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link TransactionSummaryBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(TransactionSummaryBase instance) {
      Preconditions.checkNotNull(instance);
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      totalMicros(instance.totalMicros());
      transactionCount(instance.transactionCount());
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionSummaryBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionSummaryBase#totalMicros() totalMicros}.
     * @param totalMicros value for totalMicros
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalMicros(long totalMicros) {
      this.totalMicros = totalMicros;
      initializedBitset |= INITIALIZED_BIT_TOTAL_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionSummaryBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.TransactionSummary}.
     * @return immutable instance of TransactionSummary
     */
    public TransactionSummary build() {
      checkRequiredAttributes();
      return new TransactionSummary(this);
    }
  
    private boolean totalMicrosIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TOTAL_MICROS) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!totalMicrosIsSet()) {
        attributes.add("totalMicros");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      return "Cannot build TransactionSummary, some of required attributes are not set " + attributes;
    }
  }
}
