package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UserInterfaceConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code UserInterfaceConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UserInterfaceConfigBase"})
@Immutable
public final class UserInterfaceConfig extends UserInterfaceConfigBase {
  private final int port;
  private final String adminPasswordHash;
  private final String readOnlyPasswordHash;
  private final AnonymousAccess anonymousAccess;
  private final int sessionTimeoutMinutes;
  private final String version;

  private UserInterfaceConfig(UserInterfaceConfig.Builder builder) {
    this.port = builder.portIsSet()
        ? builder.port
        : super.port();
    this.adminPasswordHash = builder.adminPasswordHash != null
        ? builder.adminPasswordHash
        : Preconditions.checkNotNull(super.adminPasswordHash());
    this.readOnlyPasswordHash = builder.readOnlyPasswordHash != null
        ? builder.readOnlyPasswordHash
        : Preconditions.checkNotNull(super.readOnlyPasswordHash());
    this.anonymousAccess = builder.anonymousAccess != null
        ? builder.anonymousAccess
        : Preconditions.checkNotNull(super.anonymousAccess());
    this.sessionTimeoutMinutes = builder.sessionTimeoutMinutesIsSet()
        ? builder.sessionTimeoutMinutes
        : super.sessionTimeoutMinutes();
    this.version = Preconditions.checkNotNull(super.version());
  }

  private UserInterfaceConfig(
      UserInterfaceConfig original,
      int port,
      String adminPasswordHash,
      String readOnlyPasswordHash,
      AnonymousAccess anonymousAccess,
      int sessionTimeoutMinutes) {
    this.port = port;
    this.adminPasswordHash = adminPasswordHash;
    this.readOnlyPasswordHash = readOnlyPasswordHash;
    this.anonymousAccess = anonymousAccess;
    this.sessionTimeoutMinutes = sessionTimeoutMinutes;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public int port() {
    return port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code adminPasswordHash} attribute
   */
  @JsonProperty("adminPasswordHash")
  @Override
  public String adminPasswordHash() {
    return adminPasswordHash;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code readOnlyPasswordHash} attribute
   */
  @JsonProperty("readOnlyPasswordHash")
  @Override
  public String readOnlyPasswordHash() {
    return readOnlyPasswordHash;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code anonymousAccess} attribute
   */
  @JsonProperty("anonymousAccess")
  @Override
  public AnonymousAccess anonymousAccess() {
    return anonymousAccess;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code sessionTimeoutMinutes} attribute
   */
  @JsonProperty("sessionTimeoutMinutes")
  @Override
  public int sessionTimeoutMinutes() {
    return sessionTimeoutMinutes;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserInterfaceConfigBase#port() port}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for port
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfig withPort(int value) {
    if (this.port == value) {
      return this;
    }
    int newValue = value;
    return new UserInterfaceConfig(
        this,
        newValue,
        this.adminPasswordHash,
        this.readOnlyPasswordHash,
        this.anonymousAccess,
        this.sessionTimeoutMinutes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserInterfaceConfigBase#adminPasswordHash() adminPasswordHash}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for adminPasswordHash
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfig withAdminPasswordHash(String value) {
    if (this.adminPasswordHash == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfig(
        this,
        this.port,
        newValue,
        this.readOnlyPasswordHash,
        this.anonymousAccess,
        this.sessionTimeoutMinutes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserInterfaceConfigBase#readOnlyPasswordHash() readOnlyPasswordHash}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for readOnlyPasswordHash
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfig withReadOnlyPasswordHash(String value) {
    if (this.readOnlyPasswordHash == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfig(this, this.port, this.adminPasswordHash, newValue, this.anonymousAccess, this.sessionTimeoutMinutes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserInterfaceConfigBase#anonymousAccess() anonymousAccess}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for anonymousAccess
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfig withAnonymousAccess(AnonymousAccess value) {
    if (this.anonymousAccess == value) {
      return this;
    }
    AnonymousAccess newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfig(
        this,
        this.port,
        this.adminPasswordHash,
        this.readOnlyPasswordHash,
        newValue,
        this.sessionTimeoutMinutes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserInterfaceConfigBase#sessionTimeoutMinutes() sessionTimeoutMinutes}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for sessionTimeoutMinutes
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfig withSessionTimeoutMinutes(int value) {
    if (this.sessionTimeoutMinutes == value) {
      return this;
    }
    int newValue = value;
    return new UserInterfaceConfig(this, this.port, this.adminPasswordHash, this.readOnlyPasswordHash, this.anonymousAccess, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code UserInterfaceConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof UserInterfaceConfig && equalTo((UserInterfaceConfig) another));
  }
  
  private boolean equalTo(UserInterfaceConfig another) {
    return port == another.port
        && adminPasswordHash.equals(another.adminPasswordHash)
        && readOnlyPasswordHash.equals(another.readOnlyPasswordHash)
        && anonymousAccess.equals(another.anonymousAccess)
        && sessionTimeoutMinutes == another.sessionTimeoutMinutes
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code port}, {@code adminPasswordHash}, {@code readOnlyPasswordHash}, {@code anonymousAccess}, {@code sessionTimeoutMinutes}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + port;
    h = h * 17 + adminPasswordHash.hashCode();
    h = h * 17 + readOnlyPasswordHash.hashCode();
    h = h * 17 + anonymousAccess.hashCode();
    h = h * 17 + sessionTimeoutMinutes;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code UserInterfaceConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UserInterfaceConfig")
        .add("port", port)
        .add("adminPasswordHash", adminPasswordHash)
        .add("readOnlyPasswordHash", readOnlyPasswordHash)
        .add("anonymousAccess", anonymousAccess)
        .add("sessionTimeoutMinutes", sessionTimeoutMinutes)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static UserInterfaceConfig fromAllAttributes(
      @JsonProperty("port") @Nullable Integer port,
      @JsonProperty("adminPasswordHash") @Nullable String adminPasswordHash,
      @JsonProperty("readOnlyPasswordHash") @Nullable String readOnlyPasswordHash,
      @JsonProperty("anonymousAccess") @Nullable AnonymousAccess anonymousAccess,
      @JsonProperty("sessionTimeoutMinutes") @Nullable Integer sessionTimeoutMinutes) {
    UserInterfaceConfig.Builder builder = UserInterfaceConfig.builder();
    if (port != null) {
      builder.port(port);
    }
    if (adminPasswordHash != null) {
      builder.adminPasswordHash(adminPasswordHash);
    }
    if (readOnlyPasswordHash != null) {
      builder.readOnlyPasswordHash(readOnlyPasswordHash);
    }
    if (anonymousAccess != null) {
      builder.anonymousAccess(anonymousAccess);
    }
    if (sessionTimeoutMinutes != null) {
      builder.sessionTimeoutMinutes(sessionTimeoutMinutes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link UserInterfaceConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable UserInterfaceConfig instance
   */
  public static UserInterfaceConfig copyOf(UserInterfaceConfigBase instance) {
    if (instance instanceof UserInterfaceConfig) {
      return (UserInterfaceConfig) instance;
    }
    return UserInterfaceConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.UserInterfaceConfig}.
   * @return new UserInterfaceConfig builder
   */
  public static UserInterfaceConfig.Builder builder() {
    return new UserInterfaceConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.UserInterfaceConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_PORT = 0x1L;
    private static final long NONDEFAULT_BIT_SESSION_TIMEOUT_MINUTES = 0x2L;
    private long nondefaultBitset;
  
    private int port;
    private @Nullable String adminPasswordHash;
    private @Nullable String readOnlyPasswordHash;
    private @Nullable AnonymousAccess anonymousAccess;
    private int sessionTimeoutMinutes;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link UserInterfaceConfigBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(UserInterfaceConfigBase instance) {
      Preconditions.checkNotNull(instance);
      port(instance.port());
      adminPasswordHash(instance.adminPasswordHash());
      readOnlyPasswordHash(instance.readOnlyPasswordHash());
      anonymousAccess(instance.anonymousAccess());
      sessionTimeoutMinutes(instance.sessionTimeoutMinutes());
      return this;
    }
  
    /**
     * Initializes value for {@link UserInterfaceConfigBase#port() port}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserInterfaceConfigBase#port() port}.</em>
     * @param port value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      nondefaultBitset |= NONDEFAULT_BIT_PORT;
      return this;
    }
  
    /**
     * Initializes value for {@link UserInterfaceConfigBase#adminPasswordHash() adminPasswordHash}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserInterfaceConfigBase#adminPasswordHash() adminPasswordHash}.</em>
     * @param adminPasswordHash value for adminPasswordHash
     * @return {@code this} builder for chained invocation
     */
    public final Builder adminPasswordHash(String adminPasswordHash) {
      this.adminPasswordHash = Preconditions.checkNotNull(adminPasswordHash);
      return this;
    }
  
    /**
     * Initializes value for {@link UserInterfaceConfigBase#readOnlyPasswordHash() readOnlyPasswordHash}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserInterfaceConfigBase#readOnlyPasswordHash() readOnlyPasswordHash}.</em>
     * @param readOnlyPasswordHash value for readOnlyPasswordHash
     * @return {@code this} builder for chained invocation
     */
    public final Builder readOnlyPasswordHash(String readOnlyPasswordHash) {
      this.readOnlyPasswordHash = Preconditions.checkNotNull(readOnlyPasswordHash);
      return this;
    }
  
    /**
     * Initializes value for {@link UserInterfaceConfigBase#anonymousAccess() anonymousAccess}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserInterfaceConfigBase#anonymousAccess() anonymousAccess}.</em>
     * @param anonymousAccess value for anonymousAccess
     * @return {@code this} builder for chained invocation
     */
    public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
      this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
      return this;
    }
  
    /**
     * Initializes value for {@link UserInterfaceConfigBase#sessionTimeoutMinutes() sessionTimeoutMinutes}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserInterfaceConfigBase#sessionTimeoutMinutes() sessionTimeoutMinutes}.</em>
     * @param sessionTimeoutMinutes value for sessionTimeoutMinutes
     * @return {@code this} builder for chained invocation
     */
    public final Builder sessionTimeoutMinutes(int sessionTimeoutMinutes) {
      this.sessionTimeoutMinutes = sessionTimeoutMinutes;
      nondefaultBitset |= NONDEFAULT_BIT_SESSION_TIMEOUT_MINUTES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.UserInterfaceConfig}.
     * @return immutable instance of UserInterfaceConfig
     */
    public UserInterfaceConfig build() {
      return new UserInterfaceConfig(this);
    }
  
    private boolean portIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_PORT) != 0;
    }
  
    private boolean sessionTimeoutMinutesIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_SESSION_TIMEOUT_MINUTES) != 0;
    }
  }
}
