package org.glowroot.local.store;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Schemas.ColumnBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Column.builder()}.
 * Use static factory method to create immutable instances:
 * {@code Column.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Schemas.ColumnBase"})
@Immutable
final class Column extends Schemas.ColumnBase {
  private final String name;
  private final int type;
  private final boolean primaryKey;
  private final boolean identity;

  private Column(String name, int type) {
    this.name = Preconditions.checkNotNull(name);
    this.type = type;
    this.primaryKey = super.primaryKey();
    this.identity = super.identity();
  }

  private Column(Column.Builder builder) {
    this.name = builder.name;
    this.type = builder.type;
    this.primaryKey = builder.primaryKeyIsSet()
        ? builder.primaryKey
        : super.primaryKey();
    this.identity = builder.identityIsSet()
        ? builder.identity
        : super.identity();
  }

  private Column(Column original, String name, int type, boolean primaryKey, boolean identity) {
    this.name = name;
    this.type = type;
    this.primaryKey = primaryKey;
    this.identity = identity;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code type} attribute
   */
  @Override
  public int type() {
    return type;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code primaryKey} attribute
   */
  @Override
  public boolean primaryKey() {
    return primaryKey;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code identity} attribute
   */
  @Override
  public boolean identity() {
    return identity;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Schemas.ColumnBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final Column withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Column(this, newValue, this.type, this.primaryKey, this.identity);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Schemas.ColumnBase#type() type}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for type
   * @return modified copy of the {@code this} object
   */
  public final Column withType(int value) {
    if (this.type == value) {
      return this;
    }
    int newValue = value;
    return new Column(this, this.name, newValue, this.primaryKey, this.identity);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Schemas.ColumnBase#primaryKey() primaryKey}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for primaryKey
   * @return modified copy of the {@code this} object
   */
  public final Column withPrimaryKey(boolean value) {
    if (this.primaryKey == value) {
      return this;
    }
    boolean newValue = value;
    return new Column(this, this.name, this.type, newValue, this.identity);
  }
  
  /**
   * Copy current immutable object by setting value for {@link Schemas.ColumnBase#identity() identity}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for identity
   * @return modified copy of the {@code this} object
   */
  public final Column withIdentity(boolean value) {
    if (this.identity == value) {
      return this;
    }
    boolean newValue = value;
    return new Column(this, this.name, this.type, this.primaryKey, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Column} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Column && equalTo((Column) another));
  }
  
  private boolean equalTo(Column another) {
    return name.equals(another.name)
        && type == another.type
        && primaryKey == another.primaryKey
        && identity == another.identity;
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code type}, {@code primaryKey}, {@code identity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + type;
    h = h * 17 + Booleans.hashCode(primaryKey);
    h = h * 17 + Booleans.hashCode(identity);
    return h;
  }
  
  /**
   * Prints immutable value {@code Column{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Column")
        .add("name", name)
        .add("type", type)
        .add("primaryKey", primaryKey)
        .add("identity", identity)
        .toString();
  }

  /**
   * Construct new immutable {@code Column} instance.
   * @param name value for {@code name}
   * @param type value for {@code type}
   * @return immutable Column instance
   */
  public static Column of(String name, int type) {
    return new Column(name, type);
  }
  
  /**
   * Creates immutable copy of {@link Schemas.ColumnBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable Column instance
   */
  static Column copyOf(Schemas.ColumnBase instance) {
    if (instance instanceof Column) {
      return (Column) instance;
    }
    return Column.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.Column}.
   * @return new Column builder
   */
  static Column.Builder builder() {
    return new Column.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.Column}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_TYPE = 0x2L;
    private static final long NONDEFAULT_BIT_PRIMARY_KEY = 0x1L;
    private static final long NONDEFAULT_BIT_IDENTITY = 0x2L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String name;
    private int type;
    private boolean primaryKey;
    private boolean identity;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link Schemas.ColumnBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Schemas.ColumnBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      type(instance.type());
      primaryKey(instance.primaryKey());
      identity(instance.identity());
      return this;
    }
  
    /**
     * Initializes value for {@link Schemas.ColumnBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link Schemas.ColumnBase#type() type}.
     * @param type value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(int type) {
      this.type = type;
      initializedBitset |= INITIALIZED_BIT_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link Schemas.ColumnBase#primaryKey() primaryKey}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link Schemas.ColumnBase#primaryKey() primaryKey}.</em>
     * @param primaryKey value for primaryKey
     * @return {@code this} builder for chained invocation
     */
    public final Builder primaryKey(boolean primaryKey) {
      this.primaryKey = primaryKey;
      nondefaultBitset |= NONDEFAULT_BIT_PRIMARY_KEY;
      return this;
    }
  
    /**
     * Initializes value for {@link Schemas.ColumnBase#identity() identity}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link Schemas.ColumnBase#identity() identity}.</em>
     * @param identity value for identity
     * @return {@code this} builder for chained invocation
     */
    public final Builder identity(boolean identity) {
      this.identity = identity;
      nondefaultBitset |= NONDEFAULT_BIT_IDENTITY;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.Column}.
     * @return immutable instance of Column
     */
    public org.glowroot.local.store.Column build() {
      checkRequiredAttributes();
      return new Column(this);
    }
  
    private boolean primaryKeyIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_PRIMARY_KEY) != 0;
    }
  
    private boolean identityIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_IDENTITY) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean typeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TYPE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!typeIsSet()) {
        attributes.add("type");
      }
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
