package org.glowroot.local.store;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorMessageCountBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorMessageCount.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorMessageCountBase"})
@Immutable
public final class ErrorMessageCount extends ErrorMessageCountBase {
  private final String message;
  private final long count;

  private ErrorMessageCount(ErrorMessageCount.Builder builder) {
    this.message = builder.message;
    this.count = builder.count;
  }

  private ErrorMessageCount(ErrorMessageCount original, String message, long count) {
    this.message = message;
    this.count = count;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public String message() {
    return message;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code count} attribute
   */
  @JsonProperty("count")
  @Override
  public long count() {
    return count;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageCountBase#message() message}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for message
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageCount withMessage(String value) {
    if (this.message == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ErrorMessageCount(this, newValue, this.count);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageCountBase#count() count}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for count
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageCount withCount(long value) {
    if (this.count == value) {
      return this;
    }
    long newValue = value;
    return new ErrorMessageCount(this, this.message, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorMessageCount} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorMessageCount && equalTo((ErrorMessageCount) another));
  }
  
  private boolean equalTo(ErrorMessageCount another) {
    return message.equals(another.message)
        && count == another.count;
  }
  
  /**
   * Computes hash code from attributes: {@code message}, {@code count}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + message.hashCode();
    h = h * 17 + Longs.hashCode(count);
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorMessageCount{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorMessageCount")
        .add("message", message)
        .add("count", count)
        .toString();
  }
  
  @JsonCreator
  public static ErrorMessageCount fromAllAttributes(
      @JsonProperty("message") @Nullable String message,
      @JsonProperty("count") @Nullable Long count) {
    ErrorMessageCount.Builder builder = ErrorMessageCount.builder();
    if (message != null) {
      builder.message(message);
    }
    if (count != null) {
      builder.count(count);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ErrorMessageCountBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable ErrorMessageCount instance
   */
  public static ErrorMessageCount copyOf(ErrorMessageCountBase instance) {
    if (instance instanceof ErrorMessageCount) {
      return (ErrorMessageCount) instance;
    }
    return ErrorMessageCount.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.ErrorMessageCount}.
   * @return new ErrorMessageCount builder
   */
  public static ErrorMessageCount.Builder builder() {
    return new ErrorMessageCount.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.ErrorMessageCount}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_MESSAGE = 0x1L;
    private static final long INITIALIZED_BIT_COUNT = 0x2L;
    private long initializedBitset;
  
    private @Nullable String message;
    private long count;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ErrorMessageCountBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ErrorMessageCountBase instance) {
      Preconditions.checkNotNull(instance);
      message(instance.message());
      count(instance.count());
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageCountBase#message() message}.
     * @param message value for message
     * @return {@code this} builder for chained invocation
     */
    public final Builder message(String message) {
      this.message = Preconditions.checkNotNull(message);
      initializedBitset |= INITIALIZED_BIT_MESSAGE;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageCountBase#count() count}.
     * @param count value for count
     * @return {@code this} builder for chained invocation
     */
    public final Builder count(long count) {
      this.count = count;
      initializedBitset |= INITIALIZED_BIT_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.ErrorMessageCount}.
     * @return immutable instance of ErrorMessageCount
     */
    public ErrorMessageCount build() {
      checkRequiredAttributes();
      return new ErrorMessageCount(this);
    }
  
    private boolean messageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MESSAGE) != 0;
    }
  
    private boolean countIsSet() {
      return (initializedBitset & INITIALIZED_BIT_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!messageIsSet()) {
        attributes.add("message");
      }
      if (!countIsSet()) {
        attributes.add("count");
      }
      return "Cannot build ErrorMessageCount, some of required attributes are not set " + attributes;
    }
  }
}
