package org.glowroot.local.store;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TracePointBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TracePoint.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TracePointBase"})
@Immutable
public final class TracePoint extends TracePointBase {
  private final String id;
  private final long captureTime;
  private final double duration;
  private final boolean error;

  private TracePoint(TracePoint.Builder builder) {
    this.id = builder.id;
    this.captureTime = builder.captureTime;
    this.duration = builder.duration;
    this.error = builder.error;
  }

  private TracePoint(TracePoint original, String id, long captureTime, double duration, boolean error) {
    this.id = id;
    this.captureTime = captureTime;
    this.duration = duration;
    this.error = error;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @Override
  public String id() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code duration} attribute
   */
  @Override
  public double duration() {
    return duration;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code error} attribute
   */
  @Override
  public boolean error() {
    return error;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointBase#id() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final TracePoint withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TracePoint(this, newValue, this.captureTime, this.duration, this.error);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final TracePoint withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new TracePoint(this, this.id, newValue, this.duration, this.error);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointBase#duration() duration}.
   * @param value new value for duration
   * @return modified copy of the {@code this} object
   */
  public final TracePoint withDuration(double value) {
    double newValue = value;
    return new TracePoint(this, this.id, this.captureTime, newValue, this.error);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointBase#error() error}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for error
   * @return modified copy of the {@code this} object
   */
  public final TracePoint withError(boolean value) {
    if (this.error == value) {
      return this;
    }
    boolean newValue = value;
    return new TracePoint(this, this.id, this.captureTime, this.duration, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TracePoint} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TracePoint && equalTo((TracePoint) another));
  }
  
  private boolean equalTo(TracePoint another) {
    return id.equals(another.id)
        && captureTime == another.captureTime
        && Double.doubleToLongBits(duration) == Double.doubleToLongBits(another.duration)
        && error == another.error;
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code captureTime}, {@code duration}, {@code error}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + Doubles.hashCode(duration);
    h = h * 17 + Booleans.hashCode(error);
    return h;
  }
  
  /**
   * Prints immutable value {@code TracePoint{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TracePoint")
        .add("id", id)
        .add("captureTime", captureTime)
        .add("duration", duration)
        .add("error", error)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link TracePointBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable TracePoint instance
   */
  public static TracePoint copyOf(TracePointBase instance) {
    if (instance instanceof TracePoint) {
      return (TracePoint) instance;
    }
    return TracePoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.TracePoint}.
   * @return new TracePoint builder
   */
  public static TracePoint.Builder builder() {
    return new TracePoint.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.TracePoint}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x2L;
    private static final long INITIALIZED_BIT_DURATION = 0x4L;
    private static final long INITIALIZED_BIT_ERROR = 0x8L;
    private long initializedBitset;
  
    private @Nullable String id;
    private long captureTime;
    private double duration;
    private boolean error;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link TracePointBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(TracePointBase instance) {
      Preconditions.checkNotNull(instance);
      id(instance.id());
      captureTime(instance.captureTime());
      duration(instance.duration());
      error(instance.error());
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointBase#id() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointBase#duration() duration}.
     * @param duration value for duration
     * @return {@code this} builder for chained invocation
     */
    public final Builder duration(double duration) {
      this.duration = duration;
      initializedBitset |= INITIALIZED_BIT_DURATION;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointBase#error() error}.
     * @param error value for error
     * @return {@code this} builder for chained invocation
     */
    public final Builder error(boolean error) {
      this.error = error;
      initializedBitset |= INITIALIZED_BIT_ERROR;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.TracePoint}.
     * @return immutable instance of TracePoint
     */
    public TracePoint build() {
      checkRequiredAttributes();
      return new TracePoint(this);
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean durationIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DURATION) != 0;
    }
  
    private boolean errorIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ERROR) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!durationIsSet()) {
        attributes.add("duration");
      }
      if (!errorIsSet()) {
        attributes.add("error");
      }
      return "Cannot build TracePoint, some of required attributes are not set " + attributes;
    }
  }
}
