package org.glowroot.local.store;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TracePointQueryBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TracePointQuery.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TracePointQueryBase"})
@Immutable
public final class TracePointQuery extends TracePointQueryBase {
  private final long from;
  private final long to;
  private final long durationLow;
  private final @Nullable Long durationHigh;
  private final @Nullable String transactionType;
  private final @Nullable StringComparator transactionNameComparator;
  private final @Nullable String transactionName;
  private final @Nullable StringComparator headlineComparator;
  private final @Nullable String headline;
  private final @Nullable StringComparator errorComparator;
  private final @Nullable String error;
  private final @Nullable StringComparator userComparator;
  private final @Nullable String user;
  private final @Nullable String customAttributeName;
  private final @Nullable StringComparator customAttributeValueComparator;
  private final @Nullable String customAttributeValue;
  private final boolean errorOnly;
  private final int limit;

  private TracePointQuery(TracePointQuery.Builder builder) {
    this.from = builder.from;
    this.to = builder.to;
    this.durationLow = builder.durationLow;
    this.durationHigh = builder.durationHigh;
    this.transactionType = builder.transactionType;
    this.transactionNameComparator = builder.transactionNameComparator;
    this.transactionName = builder.transactionName;
    this.headlineComparator = builder.headlineComparator;
    this.headline = builder.headline;
    this.errorComparator = builder.errorComparator;
    this.error = builder.error;
    this.userComparator = builder.userComparator;
    this.user = builder.user;
    this.customAttributeName = builder.customAttributeName;
    this.customAttributeValueComparator = builder.customAttributeValueComparator;
    this.customAttributeValue = builder.customAttributeValue;
    this.limit = builder.limit;
    this.errorOnly = builder.errorOnlyIsSet()
        ? builder.errorOnly
        : super.errorOnly();
  }

  private TracePointQuery(
      TracePointQuery original,
      long from,
      long to,
      long durationLow,
      @Nullable Long durationHigh,
      @Nullable String transactionType,
      @Nullable StringComparator transactionNameComparator,
      @Nullable String transactionName,
      @Nullable StringComparator headlineComparator,
      @Nullable String headline,
      @Nullable StringComparator errorComparator,
      @Nullable String error,
      @Nullable StringComparator userComparator,
      @Nullable String user,
      @Nullable String customAttributeName,
      @Nullable StringComparator customAttributeValueComparator,
      @Nullable String customAttributeValue,
      boolean errorOnly,
      int limit) {
    this.from = from;
    this.to = to;
    this.durationLow = durationLow;
    this.durationHigh = durationHigh;
    this.transactionType = transactionType;
    this.transactionNameComparator = transactionNameComparator;
    this.transactionName = transactionName;
    this.headlineComparator = headlineComparator;
    this.headline = headline;
    this.errorComparator = errorComparator;
    this.error = error;
    this.userComparator = userComparator;
    this.user = user;
    this.customAttributeName = customAttributeName;
    this.customAttributeValueComparator = customAttributeValueComparator;
    this.customAttributeValue = customAttributeValue;
    this.errorOnly = errorOnly;
    this.limit = limit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code durationLow} attribute
   */
  @Override
  public long durationLow() {
    return durationLow;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code durationHigh} attribute
   */
  @Nullable
  @Override
  public Long durationHigh() {
    return durationHigh;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @Nullable
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionNameComparator} attribute
   */
  @Nullable
  @Override
  public StringComparator transactionNameComparator() {
    return transactionNameComparator;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @Nullable
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code headlineComparator} attribute
   */
  @Nullable
  @Override
  public StringComparator headlineComparator() {
    return headlineComparator;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code headline} attribute
   */
  @Nullable
  @Override
  public String headline() {
    return headline;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorComparator} attribute
   */
  @Nullable
  @Override
  public StringComparator errorComparator() {
    return errorComparator;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code error} attribute
   */
  @Nullable
  @Override
  public String error() {
    return error;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code userComparator} attribute
   */
  @Nullable
  @Override
  public StringComparator userComparator() {
    return userComparator;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code user} attribute
   */
  @Nullable
  @Override
  public String user() {
    return user;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code customAttributeName} attribute
   */
  @Nullable
  @Override
  public String customAttributeName() {
    return customAttributeName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code customAttributeValueComparator} attribute
   */
  @Nullable
  @Override
  public StringComparator customAttributeValueComparator() {
    return customAttributeValueComparator;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code customAttributeValue} attribute
   */
  @Nullable
  @Override
  public String customAttributeValue() {
    return customAttributeValue;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorOnly} attribute
   */
  @Override
  public boolean errorOnly() {
    return errorOnly;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code limit} attribute
   */
  @Override
  public int limit() {
    return limit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new TracePointQuery(
        this,
        newValue,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        newValue,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#durationLow() durationLow}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for durationLow
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withDurationLow(long value) {
    if (this.durationLow == value) {
      return this;
    }
    long newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        newValue,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#durationHigh() durationHigh}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for durationHigh, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withDurationHigh(@Nullable Long value) {
    if (this.durationHigh == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        newValue,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withTransactionType(@Nullable String value) {
    if (this.transactionType == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        newValue,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#transactionNameComparator() transactionNameComparator}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionNameComparator, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withTransactionNameComparator(@Nullable StringComparator value) {
    if (this.transactionNameComparator == value) {
      return this;
    }
    @Nullable StringComparator newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        newValue,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        newValue,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#headlineComparator() headlineComparator}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for headlineComparator, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withHeadlineComparator(@Nullable StringComparator value) {
    if (this.headlineComparator == value) {
      return this;
    }
    @Nullable StringComparator newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        newValue,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#headline() headline}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for headline, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withHeadline(@Nullable String value) {
    if (this.headline == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        newValue,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#errorComparator() errorComparator}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorComparator, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withErrorComparator(@Nullable StringComparator value) {
    if (this.errorComparator == value) {
      return this;
    }
    @Nullable StringComparator newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        newValue,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#error() error}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for error, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withError(@Nullable String value) {
    if (this.error == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        newValue,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#userComparator() userComparator}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for userComparator, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withUserComparator(@Nullable StringComparator value) {
    if (this.userComparator == value) {
      return this;
    }
    @Nullable StringComparator newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        newValue,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#user() user}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for user, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withUser(@Nullable String value) {
    if (this.user == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        newValue,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#customAttributeName() customAttributeName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for customAttributeName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withCustomAttributeName(@Nullable String value) {
    if (this.customAttributeName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        newValue,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#customAttributeValueComparator() customAttributeValueComparator}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for customAttributeValueComparator, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withCustomAttributeValueComparator(@Nullable StringComparator value) {
    if (this.customAttributeValueComparator == value) {
      return this;
    }
    @Nullable StringComparator newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        newValue,
        this.customAttributeValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#customAttributeValue() customAttributeValue}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for customAttributeValue, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withCustomAttributeValue(@Nullable String value) {
    if (this.customAttributeValue == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        newValue,
        this.errorOnly,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#errorOnly() errorOnly}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorOnly
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withErrorOnly(boolean value) {
    if (this.errorOnly == value) {
      return this;
    }
    boolean newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        newValue,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TracePointQueryBase#limit() limit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for limit
   * @return modified copy of the {@code this} object
   */
  public final TracePointQuery withLimit(int value) {
    if (this.limit == value) {
      return this;
    }
    int newValue = value;
    return new TracePointQuery(
        this,
        this.from,
        this.to,
        this.durationLow,
        this.durationHigh,
        this.transactionType,
        this.transactionNameComparator,
        this.transactionName,
        this.headlineComparator,
        this.headline,
        this.errorComparator,
        this.error,
        this.userComparator,
        this.user,
        this.customAttributeName,
        this.customAttributeValueComparator,
        this.customAttributeValue,
        this.errorOnly,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TracePointQuery} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TracePointQuery && equalTo((TracePointQuery) another));
  }
  
  private boolean equalTo(TracePointQuery another) {
    return from == another.from
        && to == another.to
        && durationLow == another.durationLow
        && Objects.equal(durationHigh, another.durationHigh)
        && Objects.equal(transactionType, another.transactionType)
        && Objects.equal(transactionNameComparator, another.transactionNameComparator)
        && Objects.equal(transactionName, another.transactionName)
        && Objects.equal(headlineComparator, another.headlineComparator)
        && Objects.equal(headline, another.headline)
        && Objects.equal(errorComparator, another.errorComparator)
        && Objects.equal(error, another.error)
        && Objects.equal(userComparator, another.userComparator)
        && Objects.equal(user, another.user)
        && Objects.equal(customAttributeName, another.customAttributeName)
        && Objects.equal(customAttributeValueComparator, another.customAttributeValueComparator)
        && Objects.equal(customAttributeValue, another.customAttributeValue)
        && errorOnly == another.errorOnly
        && limit == another.limit;
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code durationLow}, {@code durationHigh}, {@code transactionType}, {@code transactionNameComparator}, {@code transactionName}, {@code headlineComparator}, {@code headline}, {@code errorComparator}, {@code error}, {@code userComparator}, {@code user}, {@code customAttributeName}, {@code customAttributeValueComparator}, {@code customAttributeValue}, {@code errorOnly}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + Longs.hashCode(durationLow);
    h = h * 17 + Objects.hashCode(durationHigh);
    h = h * 17 + Objects.hashCode(transactionType);
    h = h * 17 + Objects.hashCode(transactionNameComparator);
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + Objects.hashCode(headlineComparator);
    h = h * 17 + Objects.hashCode(headline);
    h = h * 17 + Objects.hashCode(errorComparator);
    h = h * 17 + Objects.hashCode(error);
    h = h * 17 + Objects.hashCode(userComparator);
    h = h * 17 + Objects.hashCode(user);
    h = h * 17 + Objects.hashCode(customAttributeName);
    h = h * 17 + Objects.hashCode(customAttributeValueComparator);
    h = h * 17 + Objects.hashCode(customAttributeValue);
    h = h * 17 + Booleans.hashCode(errorOnly);
    h = h * 17 + limit;
    return h;
  }
  
  /**
   * Prints immutable value {@code TracePointQuery{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TracePointQuery")
        .add("from", from)
        .add("to", to)
        .add("durationLow", durationLow)
        .add("durationHigh", durationHigh)
        .add("transactionType", transactionType)
        .add("transactionNameComparator", transactionNameComparator)
        .add("transactionName", transactionName)
        .add("headlineComparator", headlineComparator)
        .add("headline", headline)
        .add("errorComparator", errorComparator)
        .add("error", error)
        .add("userComparator", userComparator)
        .add("user", user)
        .add("customAttributeName", customAttributeName)
        .add("customAttributeValueComparator", customAttributeValueComparator)
        .add("customAttributeValue", customAttributeValue)
        .add("errorOnly", errorOnly)
        .add("limit", limit)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link TracePointQueryBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable TracePointQuery instance
   */
  public static TracePointQuery copyOf(TracePointQueryBase instance) {
    if (instance instanceof TracePointQuery) {
      return (TracePointQuery) instance;
    }
    return TracePointQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.TracePointQuery}.
   * @return new TracePointQuery builder
   */
  public static TracePointQuery.Builder builder() {
    return new TracePointQuery.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.TracePointQuery}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_DURATION_LOW = 0x4L;
    private static final long INITIALIZED_BIT_LIMIT = 0x8L;
    private static final long NONDEFAULT_BIT_ERROR_ONLY = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private long from;
    private long to;
    private long durationLow;
    private @Nullable Long durationHigh;
    private @Nullable String transactionType;
    private @Nullable StringComparator transactionNameComparator;
    private @Nullable String transactionName;
    private @Nullable StringComparator headlineComparator;
    private @Nullable String headline;
    private @Nullable StringComparator errorComparator;
    private @Nullable String error;
    private @Nullable StringComparator userComparator;
    private @Nullable String user;
    private @Nullable String customAttributeName;
    private @Nullable StringComparator customAttributeValueComparator;
    private @Nullable String customAttributeValue;
    private boolean errorOnly;
    private int limit;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link TracePointQueryBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(TracePointQueryBase instance) {
      Preconditions.checkNotNull(instance);
      from(instance.from());
      to(instance.to());
      durationLow(instance.durationLow());
      @Nullable Long durationHighValue = instance.durationHigh();
      if (durationHighValue != null) {
        durationHigh(durationHighValue);
      }
      @Nullable String transactionTypeValue = instance.transactionType();
      if (transactionTypeValue != null) {
        transactionType(transactionTypeValue);
      }
      @Nullable StringComparator transactionNameComparatorValue = instance.transactionNameComparator();
      if (transactionNameComparatorValue != null) {
        transactionNameComparator(transactionNameComparatorValue);
      }
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      @Nullable StringComparator headlineComparatorValue = instance.headlineComparator();
      if (headlineComparatorValue != null) {
        headlineComparator(headlineComparatorValue);
      }
      @Nullable String headlineValue = instance.headline();
      if (headlineValue != null) {
        headline(headlineValue);
      }
      @Nullable StringComparator errorComparatorValue = instance.errorComparator();
      if (errorComparatorValue != null) {
        errorComparator(errorComparatorValue);
      }
      @Nullable String errorValue = instance.error();
      if (errorValue != null) {
        error(errorValue);
      }
      @Nullable StringComparator userComparatorValue = instance.userComparator();
      if (userComparatorValue != null) {
        userComparator(userComparatorValue);
      }
      @Nullable String userValue = instance.user();
      if (userValue != null) {
        user(userValue);
      }
      @Nullable String customAttributeNameValue = instance.customAttributeName();
      if (customAttributeNameValue != null) {
        customAttributeName(customAttributeNameValue);
      }
      @Nullable StringComparator customAttributeValueComparatorValue = instance.customAttributeValueComparator();
      if (customAttributeValueComparatorValue != null) {
        customAttributeValueComparator(customAttributeValueComparatorValue);
      }
      @Nullable String customAttributeValueValue = instance.customAttributeValue();
      if (customAttributeValueValue != null) {
        customAttributeValue(customAttributeValueValue);
      }
      errorOnly(instance.errorOnly());
      limit(instance.limit());
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#durationLow() durationLow}.
     * @param durationLow value for durationLow
     * @return {@code this} builder for chained invocation
     */
    public final Builder durationLow(long durationLow) {
      this.durationLow = durationLow;
      initializedBitset |= INITIALIZED_BIT_DURATION_LOW;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#durationHigh() durationHigh}.
     * @param durationHigh value for durationHigh, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder durationHigh(@Nullable Long durationHigh) {
      this.durationHigh = durationHigh;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#transactionType() transactionType}.
     * @param transactionType value for transactionType, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(@Nullable String transactionType) {
      this.transactionType = transactionType;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#transactionNameComparator() transactionNameComparator}.
     * @param transactionNameComparator value for transactionNameComparator, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionNameComparator(@Nullable StringComparator transactionNameComparator) {
      this.transactionNameComparator = transactionNameComparator;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#headlineComparator() headlineComparator}.
     * @param headlineComparator value for headlineComparator, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder headlineComparator(@Nullable StringComparator headlineComparator) {
      this.headlineComparator = headlineComparator;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#headline() headline}.
     * @param headline value for headline, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder headline(@Nullable String headline) {
      this.headline = headline;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#errorComparator() errorComparator}.
     * @param errorComparator value for errorComparator, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorComparator(@Nullable StringComparator errorComparator) {
      this.errorComparator = errorComparator;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#error() error}.
     * @param error value for error, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#userComparator() userComparator}.
     * @param userComparator value for userComparator, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder userComparator(@Nullable StringComparator userComparator) {
      this.userComparator = userComparator;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#user() user}.
     * @param user value for user, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder user(@Nullable String user) {
      this.user = user;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#customAttributeName() customAttributeName}.
     * @param customAttributeName value for customAttributeName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder customAttributeName(@Nullable String customAttributeName) {
      this.customAttributeName = customAttributeName;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#customAttributeValueComparator() customAttributeValueComparator}.
     * @param customAttributeValueComparator value for customAttributeValueComparator, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder customAttributeValueComparator(@Nullable StringComparator customAttributeValueComparator) {
      this.customAttributeValueComparator = customAttributeValueComparator;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#customAttributeValue() customAttributeValue}.
     * @param customAttributeValue value for customAttributeValue, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder customAttributeValue(@Nullable String customAttributeValue) {
      this.customAttributeValue = customAttributeValue;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#errorOnly() errorOnly}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link TracePointQueryBase#errorOnly() errorOnly}.</em>
     * @param errorOnly value for errorOnly
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorOnly(boolean errorOnly) {
      this.errorOnly = errorOnly;
      nondefaultBitset |= NONDEFAULT_BIT_ERROR_ONLY;
      return this;
    }
  
    /**
     * Initializes value for {@link TracePointQueryBase#limit() limit}.
     * @param limit value for limit
     * @return {@code this} builder for chained invocation
     */
    public final Builder limit(int limit) {
      this.limit = limit;
      initializedBitset |= INITIALIZED_BIT_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.TracePointQuery}.
     * @return immutable instance of TracePointQuery
     */
    public TracePointQuery build() {
      checkRequiredAttributes();
      return new TracePointQuery(this);
    }
  
    private boolean errorOnlyIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ERROR_ONLY) != 0;
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean durationLowIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DURATION_LOW) != 0;
    }
  
    private boolean limitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LIMIT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!durationLowIsSet()) {
        attributes.add("durationLow");
      }
      if (!limitIsSet()) {
        attributes.add("limit");
      }
      return "Cannot build TracePointQuery, some of required attributes are not set " + attributes;
    }
  }
}
