package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorJsonService.ErrorMessageRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorMessageRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorJsonService.ErrorMessageRequestBase"})
@Immutable
final class ErrorMessageRequest extends ErrorJsonService.ErrorMessageRequestBase {
  private final long from;
  private final long to;
  private final String transactionType;
  private final @Nullable String transactionName;
  private final ImmutableList<String> include;
  private final ImmutableList<String> exclude;
  private final int errorMessageLimit;

  private ErrorMessageRequest(ErrorMessageRequest.Builder builder) {
    this.from = builder.from;
    this.to = builder.to;
    this.transactionType = builder.transactionType;
    this.transactionName = builder.transactionName;
    this.include = builder.includeBuilder.build();
    this.exclude = builder.excludeBuilder.build();
    this.errorMessageLimit = builder.errorMessageLimit;
  }

  private ErrorMessageRequest(
      ErrorMessageRequest original,
      long from,
      long to,
      String transactionType,
      @Nullable String transactionName,
      ImmutableList<String> include,
      ImmutableList<String> exclude,
      int errorMessageLimit) {
    this.from = from;
    this.to = to;
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.include = include;
    this.exclude = exclude;
    this.errorMessageLimit = errorMessageLimit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @Nullable
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code include} attribute
   */
  @JsonProperty("include")
  @Override
  public ImmutableList<String> include() {
    return include;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code exclude} attribute
   */
  @JsonProperty("exclude")
  @Override
  public ImmutableList<String> exclude() {
    return exclude;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorMessageLimit} attribute
   */
  @JsonProperty("errorMessageLimit")
  @Override
  public int errorMessageLimit() {
    return errorMessageLimit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorMessageRequestBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageRequest withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new ErrorMessageRequest(
        this,
        newValue,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        this.exclude,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorMessageRequestBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageRequest withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new ErrorMessageRequest(
        this,
        this.from,
        newValue,
        this.transactionType,
        this.transactionName,
        this.include,
        this.exclude,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorMessageRequestBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageRequest withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        newValue,
        this.transactionName,
        this.include,
        this.exclude,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorMessageRequestBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageRequest withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        this.transactionType,
        newValue,
        this.include,
        this.exclude,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorJsonService.ErrorMessageRequestBase#include() include}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageRequest withInclude(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        newValue,
        this.exclude,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorJsonService.ErrorMessageRequestBase#include() include}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of include elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageRequest withInclude(Iterable<String> elements) {
    if (this.include == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        newValue,
        this.exclude,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorJsonService.ErrorMessageRequestBase#exclude() exclude}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageRequest withExclude(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        newValue,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorJsonService.ErrorMessageRequestBase#exclude() exclude}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of exclude elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageRequest withExclude(Iterable<String> elements) {
    if (this.exclude == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        newValue,
        this.errorMessageLimit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorMessageRequestBase#errorMessageLimit() errorMessageLimit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorMessageLimit
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageRequest withErrorMessageLimit(int value) {
    if (this.errorMessageLimit == value) {
      return this;
    }
    int newValue = value;
    return new ErrorMessageRequest(
        this,
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        this.exclude,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorMessageRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorMessageRequest && equalTo((ErrorMessageRequest) another));
  }
  
  private boolean equalTo(ErrorMessageRequest another) {
    return from == another.from
        && to == another.to
        && transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName)
        && include.equals(another.include)
        && exclude.equals(another.exclude)
        && errorMessageLimit == another.errorMessageLimit;
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code transactionType}, {@code transactionName}, {@code include}, {@code exclude}, {@code errorMessageLimit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + include.hashCode();
    h = h * 17 + exclude.hashCode();
    h = h * 17 + errorMessageLimit;
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorMessageRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorMessageRequest")
        .add("from", from)
        .add("to", to)
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("include", include)
        .add("exclude", exclude)
        .add("errorMessageLimit", errorMessageLimit)
        .toString();
  }
  
  @JsonCreator
  public static ErrorMessageRequest fromAllAttributes(
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("transactionName") @Nullable String transactionName,
      @JsonProperty("include") @Nullable ImmutableList<String> include,
      @JsonProperty("exclude") @Nullable ImmutableList<String> exclude,
      @JsonProperty("errorMessageLimit") @Nullable Integer errorMessageLimit) {
    ErrorMessageRequest.Builder builder = ErrorMessageRequest.builder();
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    if (include != null) {
      builder.addAllInclude(include);
    }
    if (exclude != null) {
      builder.addAllExclude(exclude);
    }
    if (errorMessageLimit != null) {
      builder.errorMessageLimit(errorMessageLimit);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ErrorJsonService.ErrorMessageRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable ErrorMessageRequest instance
   */
  static ErrorMessageRequest copyOf(ErrorJsonService.ErrorMessageRequestBase instance) {
    if (instance instanceof ErrorMessageRequest) {
      return (ErrorMessageRequest) instance;
    }
    return ErrorMessageRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.ErrorMessageRequest}.
   * @return new ErrorMessageRequest builder
   */
  static ErrorMessageRequest.Builder builder() {
    return new ErrorMessageRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.ErrorMessageRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x4L;
    private static final long INITIALIZED_BIT_ERROR_MESSAGE_LIMIT = 0x8L;
    private long initializedBitset;
  
    private long from;
    private long to;
    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private ImmutableList.Builder<String> includeBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> excludeBuilder = ImmutableList.builder();
    private int errorMessageLimit;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link ErrorJsonService.ErrorMessageRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ErrorJsonService.ErrorMessageRequestBase instance) {
      Preconditions.checkNotNull(instance);
      from(instance.from());
      to(instance.to());
      transactionType(instance.transactionType());
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      addAllInclude(instance.include());
      addAllExclude(instance.exclude());
      errorMessageLimit(instance.errorMessageLimit());
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorMessageRequestBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorMessageRequestBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorMessageRequestBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorMessageRequestBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }
  
    /**
     * Adds one element to {@link ErrorJsonService.ErrorMessageRequestBase#include() include} list.
     * @param element include element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInclude(String element) {
      includeBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ErrorJsonService.ErrorMessageRequestBase#include() include} list.
     * @param elements array of include elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInclude(String... elements) {
      includeBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ErrorJsonService.ErrorMessageRequestBase#include() include} list.
     * @param elements iterable of include elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder include(Iterable<String> elements) {
      includeBuilder = ImmutableList.builder();
      return addAllInclude(elements);
    }
  
    /**
     * Adds elements to {@link ErrorJsonService.ErrorMessageRequestBase#include() include} list.
     * @param elements iterable of include elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllInclude(Iterable<String> elements) {
      includeBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link ErrorJsonService.ErrorMessageRequestBase#exclude() exclude} list.
     * @param element exclude element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExclude(String element) {
      excludeBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ErrorJsonService.ErrorMessageRequestBase#exclude() exclude} list.
     * @param elements array of exclude elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExclude(String... elements) {
      excludeBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ErrorJsonService.ErrorMessageRequestBase#exclude() exclude} list.
     * @param elements iterable of exclude elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder exclude(Iterable<String> elements) {
      excludeBuilder = ImmutableList.builder();
      return addAllExclude(elements);
    }
  
    /**
     * Adds elements to {@link ErrorJsonService.ErrorMessageRequestBase#exclude() exclude} list.
     * @param elements iterable of exclude elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllExclude(Iterable<String> elements) {
      excludeBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorMessageRequestBase#errorMessageLimit() errorMessageLimit}.
     * @param errorMessageLimit value for errorMessageLimit
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorMessageLimit(int errorMessageLimit) {
      this.errorMessageLimit = errorMessageLimit;
      initializedBitset |= INITIALIZED_BIT_ERROR_MESSAGE_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.ErrorMessageRequest}.
     * @return immutable instance of ErrorMessageRequest
     */
    public org.glowroot.local.ui.ErrorMessageRequest build() {
      checkRequiredAttributes();
      return new ErrorMessageRequest(this);
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean errorMessageLimitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ERROR_MESSAGE_LIMIT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!errorMessageLimitIsSet()) {
        attributes.add("errorMessageLimit");
      }
      return "Cannot build ErrorMessageRequest, some of required attributes are not set " + attributes;
    }
  }
}
