package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.MBeanAttribute;

/**
 * Immutable implementation of {@link GaugeJsonService.GaugeConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugeConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeJsonService.GaugeConfigDtoBase"})
@Immutable
final class GaugeConfigDto extends GaugeJsonService.GaugeConfigDtoBase {
  private final @Nullable String display;
  private final String mbeanObjectName;
  private final ImmutableList<MBeanAttribute> mbeanAttributes;
  private final @Nullable String version;

  private GaugeConfigDto(GaugeConfigDto.Builder builder) {
    this.display = builder.display;
    this.mbeanObjectName = builder.mbeanObjectName;
    this.mbeanAttributes = builder.mbeanAttributesBuilder.build();
    this.version = builder.version;
  }

  private GaugeConfigDto(
      GaugeConfigDto original,
      @Nullable String display,
      String mbeanObjectName,
      ImmutableList<MBeanAttribute> mbeanAttributes,
      @Nullable String version) {
    this.display = display;
    this.mbeanObjectName = mbeanObjectName;
    this.mbeanAttributes = mbeanAttributes;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code display} attribute
   */
  @Nullable
  @JsonProperty("display")
  @Override
  public String display() {
    return display;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanObjectName} attribute
   */
  @JsonProperty("mbeanObjectName")
  @Override
  public String mbeanObjectName() {
    return mbeanObjectName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanAttributes} attribute
   */
  @JsonProperty("mbeanAttributes")
  @Override
  public ImmutableList<MBeanAttribute> mbeanAttributes() {
    return mbeanAttributes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @Nullable
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeConfigDtoBase#display() display}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for display, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final GaugeConfigDto withDisplay(@Nullable String value) {
    if (this.display == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new GaugeConfigDto(this, newValue, this.mbeanObjectName, this.mbeanAttributes, this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeConfigDtoBase#mbeanObjectName() mbeanObjectName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanObjectName
   * @return modified copy of the {@code this} object
   */
  public final GaugeConfigDto withMbeanObjectName(String value) {
    if (this.mbeanObjectName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GaugeConfigDto(this, this.display, newValue, this.mbeanAttributes, this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.GaugeConfigDtoBase#mbeanAttributes() mbeanAttributes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeConfigDto withMbeanAttributes(MBeanAttribute... elements) {
    ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
    return new GaugeConfigDto(this, this.display, this.mbeanObjectName, newValue, this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.GaugeConfigDtoBase#mbeanAttributes() mbeanAttributes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of mbeanAttributes elements to set
   * @return modified copy of {@code this} object
   */
  public final GaugeConfigDto withMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
    if (this.mbeanAttributes == elements) {
      return this;
    }
    ImmutableList<MBeanAttribute> newValue = ImmutableList.copyOf(elements);
    return new GaugeConfigDto(this, this.display, this.mbeanObjectName, newValue, this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.GaugeConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final GaugeConfigDto withVersion(@Nullable String value) {
    if (this.version == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new GaugeConfigDto(this, this.display, this.mbeanObjectName, this.mbeanAttributes, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugeConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugeConfigDto && equalTo((GaugeConfigDto) another));
  }
  
  private boolean equalTo(GaugeConfigDto another) {
    return Objects.equal(display, another.display)
        && mbeanObjectName.equals(another.mbeanObjectName)
        && mbeanAttributes.equals(another.mbeanAttributes)
        && Objects.equal(version, another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code display}, {@code mbeanObjectName}, {@code mbeanAttributes}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(display);
    h = h * 17 + mbeanObjectName.hashCode();
    h = h * 17 + mbeanAttributes.hashCode();
    h = h * 17 + Objects.hashCode(version);
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugeConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugeConfigDto")
        .add("display", display)
        .add("mbeanObjectName", mbeanObjectName)
        .add("mbeanAttributes", mbeanAttributes)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static GaugeConfigDto fromAllAttributes(
      @JsonProperty("display") @Nullable String display,
      @JsonProperty("mbeanObjectName") @Nullable String mbeanObjectName,
      @JsonProperty("mbeanAttributes") @Nullable ImmutableList<MBeanAttribute> mbeanAttributes,
      @JsonProperty("version") @Nullable String version) {
    GaugeConfigDto.Builder builder = GaugeConfigDto.builder();
    if (display != null) {
      builder.display(display);
    }
    if (mbeanObjectName != null) {
      builder.mbeanObjectName(mbeanObjectName);
    }
    if (mbeanAttributes != null) {
      builder.addAllMbeanAttributes(mbeanAttributes);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeJsonService.GaugeConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @return copied immutable GaugeConfigDto instance
   */
  static GaugeConfigDto copyOf(GaugeJsonService.GaugeConfigDtoBase instance) {
    if (instance instanceof GaugeConfigDto) {
      return (GaugeConfigDto) instance;
    }
    return GaugeConfigDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.GaugeConfigDto}.
   * @return new GaugeConfigDto builder
   */
  static GaugeConfigDto.Builder builder() {
    return new GaugeConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.GaugeConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_MBEAN_OBJECT_NAME = 0x1L;
    private long initializedBitset;
  
    private @Nullable String display;
    private @Nullable String mbeanObjectName;
    private ImmutableList.Builder<MBeanAttribute> mbeanAttributesBuilder = ImmutableList.builder();
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Adjust builder with values from provided {@link GaugeJsonService.GaugeConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(GaugeJsonService.GaugeConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      @Nullable String displayValue = instance.display();
      if (displayValue != null) {
        display(displayValue);
      }
      mbeanObjectName(instance.mbeanObjectName());
      addAllMbeanAttributes(instance.mbeanAttributes());
      @Nullable String versionValue = instance.version();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeConfigDtoBase#display() display}.
     * @param display value for display, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder display(@Nullable String display) {
      this.display = display;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeConfigDtoBase#mbeanObjectName() mbeanObjectName}.
     * @param mbeanObjectName value for mbeanObjectName
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanObjectName(String mbeanObjectName) {
      this.mbeanObjectName = Preconditions.checkNotNull(mbeanObjectName);
      initializedBitset |= INITIALIZED_BIT_MBEAN_OBJECT_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link GaugeJsonService.GaugeConfigDtoBase#mbeanAttributes() mbeanAttributes} list.
     * @param element mbeanAttributes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAttributes(MBeanAttribute element) {
      mbeanAttributesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.GaugeConfigDtoBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements array of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAttributes(MBeanAttribute... elements) {
      mbeanAttributesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link GaugeJsonService.GaugeConfigDtoBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements iterable of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
      mbeanAttributesBuilder = ImmutableList.builder();
      return addAllMbeanAttributes(elements);
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.GaugeConfigDtoBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements iterable of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMbeanAttributes(Iterable<? extends MBeanAttribute> elements) {
      mbeanAttributesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.GaugeConfigDtoBase#version() version}.
     * @param version value for version, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.GaugeConfigDto}.
     * @return immutable instance of GaugeConfigDto
     */
    public org.glowroot.local.ui.GaugeConfigDto build() {
      checkRequiredAttributes();
      return new GaugeConfigDto(this);
    }
  
    private boolean mbeanObjectNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MBEAN_OBJECT_NAME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!mbeanObjectNameIsSet()) {
        attributes.add("mbeanObjectName");
      }
      return "Cannot build GaugeConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
